/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.factories;

import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.factories.DelegatingNodeFactory;
import org.eclipse.n4js.flowgraphs.factories.ReentrantASTIterator;
import org.eclipse.n4js.flowgraphs.model.CatchToken;
import org.eclipse.n4js.flowgraphs.model.ComplexNode;
import org.eclipse.n4js.flowgraphs.model.HelperNode;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ConditionalExpression;
import org.eclipse.n4js.n4JS.ControlFlowElement;

class ConditionalExpressionFactory {
    ConditionalExpressionFactory() {
    }

    static ComplexNode buildComplexNode(ReentrantASTIterator astpp, ConditionalExpression condExpr) {
        ComplexNode cNode = new ComplexNode(astpp.container(), (ControlFlowElement)condExpr);
        HelperNode entryNode = new HelperNode("entry", astpp.pos(), (ControlFlowElement)condExpr);
        Node conditionNode = DelegatingNodeFactory.createOrHelper(astpp, "condition", (ControlFlowElement)condExpr, (ControlFlowElement)condExpr.getExpression());
        HelperNode conditionForkNode = new HelperNode("conditionFork", astpp.pos(), (ControlFlowElement)condExpr);
        Node thenNode = DelegatingNodeFactory.createOrHelper(astpp, "then", (ControlFlowElement)condExpr, (ControlFlowElement)condExpr.getTrueExpression());
        Node elseNode = DelegatingNodeFactory.createOrHelper(astpp, "else", (ControlFlowElement)condExpr, (ControlFlowElement)condExpr.getFalseExpression());
        RepresentingNode exitNode = new RepresentingNode("exit", astpp.pos(), (ControlFlowElement)condExpr);
        cNode.addNode(entryNode);
        cNode.addNode(conditionNode);
        cNode.addNode(conditionForkNode);
        cNode.addNode(thenNode);
        cNode.addNode(elseNode);
        cNode.addNode(exitNode);
        cNode.connectInternalSucc(entryNode, conditionNode, conditionForkNode);
        cNode.connectInternalSucc(ControlFlowType.IfTrue, conditionForkNode, thenNode);
        cNode.connectInternalSucc(thenNode, exitNode);
        cNode.connectInternalSucc(ControlFlowType.IfFalse, conditionForkNode, elseNode);
        cNode.connectInternalSucc(elseNode, exitNode);
        thenNode.addCatchToken(new CatchToken(ControlFlowType.IfTrue));
        elseNode.addCatchToken(new CatchToken(ControlFlowType.IfFalse));
        cNode.setEntryNode(entryNode);
        cNode.setExitNode(exitNode);
        return cNode;
    }
}

