/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.xpect.ui.methods.quickfix;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Scanner;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.n4js.generator.GeneratorOption;
import org.eclipse.n4js.runner.SystemLoaderInfo;
import org.eclipse.n4js.tests.util.EclipseGracefulUIShutdownEnabler;
import org.eclipse.n4js.tests.util.EditorsUtil;
import org.eclipse.n4js.xpect.common.N4JSOffsetAdapter;
import org.eclipse.n4js.xpect.common.ResourceTweaker;
import org.eclipse.n4js.xpect.common.XpectCommentRemovalUtil;
import org.eclipse.n4js.xpect.config.Config;
import org.eclipse.n4js.xpect.config.VarDef;
import org.eclipse.n4js.xpect.config.XpEnvironmentData;
import org.eclipse.n4js.xpect.ui.common.QuickFixTestHelper;
import org.eclipse.n4js.xpect.ui.common.XpectN4JSES5TranspilerHelper;
import org.eclipse.n4js.xpect.ui.methods.contentassist.RegionWithCursor;
import org.eclipse.n4js.xpect.ui.methods.quickfix.LineBasedTokenizer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xpect.XpectImport;
import org.eclipse.xpect.expectation.CommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.ICommaSeparatedValuesExpectation;
import org.eclipse.xpect.expectation.IStringDiffExpectation;
import org.eclipse.xpect.expectation.IStringExpectation;
import org.eclipse.xpect.expectation.StringDiffExpectation;
import org.eclipse.xpect.expectation.StringExpectation;
import org.eclipse.xpect.parameter.ParameterParser;
import org.eclipse.xpect.runner.Xpect;
import org.eclipse.xpect.setup.ISetupInitializer;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.ThisResource;
import org.eclipse.xpect.xtext.lib.tests.ValidationTestModuleSetup;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.validation.CheckMode;
import org.eclipse.xtext.validation.Issue;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.junit.Assert;

@XpectImport(value={N4JSOffsetAdapter.class, XpEnvironmentData.class, VarDef.class, Config.class, ValidationTestModuleSetup.class})
public class QuickFixXpectMethod {
    private static Logger logger;

    static {
        EclipseGracefulUIShutdownEnabler.enableOnce();
        logger = Logger.getLogger(QuickFixXpectMethod.class);
    }

    @ParameterParser(syntax="('at' (arg2=STRING ('apply' arg3=STRING)? ('resource=' arg5=STRING)?  (arg4=ID)? )? )? )?")
    @Xpect
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void quickFix(@StringDiffExpectation(whitespaceSensitive=false) IStringDiffExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor offset, String selected, String mode, String specifiedResourcePath, @ValidationTestModuleSetup.IssuesByLine Multimap<Integer, Issue> offset2issue) throws Exception {
        this.quickFix(expectation, resource, offset, selected, mode, specifiedResourcePath, offset2issue, true);
    }

    private void quickFix(IStringDiffExpectation expectation, XtextResource resource, RegionWithCursor offset, String selected, String mode, String specifiedResourcePath, Multimap<Integer, Issue> offset2issue, boolean reparseResource) throws Exception {
        Optional editor = Optional.empty();
        try {
            String beforeApplication;
            List<IssueResolution> resolutions = this.collectAllResolutions(resource, offset, offset2issue);
            IssueResolution res = QuickFixTestHelper.selectSingleOrFail(resolutions, selected);
            URI targetResourceUri = resource.getURI();
            if (specifiedResourcePath != null && !specifiedResourcePath.isEmpty()) {
                URI specifiedURI;
                targetResourceUri = specifiedURI = resource.getURI().trimSegments(1).appendSegments(specifiedResourcePath.split("/"));
                beforeApplication = this.getContentForResourceUri(specifiedURI);
            } else {
                beforeApplication = this.getContentForResourceUri(resource.getURI());
            }
            Display.getDefault().syncExec(() -> res.apply());
            editor = EditorsUtil.openXtextEditor((URI)targetResourceUri, (String)"org.eclipse.n4js.N4JS");
            Assert.assertTrue((String)("No editor for provided resource " + targetResourceUri.path()), (boolean)editor.isPresent());
            String textAfterApplication = ((XtextEditor)editor.get()).getDocument().get();
            if (specifiedResourcePath == null || specifiedResourcePath.isEmpty()) {
                resource.reparse(textAfterApplication);
                ValidationTestModuleSetup.TestingResourceValidator trVal = (ValidationTestModuleSetup.TestingResourceValidator)resource.getResourceServiceProvider().getResourceValidator();
                if ("fileValid".equals(mode)) {
                    List remainingIssues = trVal.validateDelegate((Resource)resource, CheckMode.ALL, CancelIndicator.NullImpl, null);
                    Assert.assertEquals((String)("Expecting all issues resolved, but got still left: " + remainingIssues), (long)0L, (long)remainingIssues.size());
                }
            }
            if (reparseResource) {
                resource.reparse(this.getContentForResourceUri(resource.getURI()));
            }
            if (expectation != null) {
                String before = XpectCommentRemovalUtil.removeAllXpectComments((String)beforeApplication);
                String after = XpectCommentRemovalUtil.removeAllXpectComments((String)textAfterApplication);
                if ("whitespaceSensitive".equals(mode)) {
                    LineBasedTokenizer tokenizer = new LineBasedTokenizer();
                    expectation.assertDiffEquals(tokenizer.apply(before), tokenizer.apply(after), (IStringDiffExpectation.ITokenAdapter)new WSAwareTokenAdapter());
                } else {
                    expectation.assertDiffEquals(before, after);
                }
            }
        }
        catch (Throwable throwable) {
            editor.ifPresent(e -> EditorsUtil.forceCloseAllEditors());
            throw throwable;
        }
        editor.ifPresent(e -> EditorsUtil.forceCloseAllEditors());
    }

    @Xpect
    @ParameterParser(syntax="('at' arg2=STRING)? ('apply'  arg3=STRING )?")
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void quickFixAndRun(@StringExpectation(caseSensitive=true) IStringExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor offset, String selected, @ValidationTestModuleSetup.IssuesByLine Multimap<Integer, Issue> offset2issue, ISetupInitializer<Object> init, FileSetupContext fileSetupContext) throws Exception {
        try {
            long timeStart = System.currentTimeMillis();
            logger.info((Object)("Execution started: " + new Date(timeStart)));
            ExecutionResult exRes = new ExecutionResult();
            ResourceTweaker resourceTweaker = resourceToTweak -> {
                try {
                    this.quickFix(null, resourceToTweak, offset, selected, "fileValid", "", offset2issue, false);
                }
                catch (Exception e) {
                    Exceptions.sneakyThrow((Throwable)e);
                }
            };
            Display.getDefault().syncExec(() -> {
                String string = executionResult.result = this.compileAndExecute(resource, init, fileSetupContext, resourceTweaker);
            });
            String executionResult = exRes.result;
            long timeEnd = System.currentTimeMillis();
            logger.info((Object)("Execution finished: " + new Date(timeEnd)));
            logger.info((Object)("Execution took " + ((double)(timeEnd - timeStart) + 0.0) / 1000.0 + " seconds."));
            expectation.assertEquals((Object)executionResult);
            resource.reparse(this.getContentForResourceUri(resource.getURI()));
        }
        finally {
            logger.info((Object)"Closing all editors");
            EditorsUtil.forceCloseAllEditors();
        }
        logger.info((Object)"Successful End of Execution");
    }

    private String compileAndExecute(XtextResource resource, ISetupInitializer<Object> init, FileSetupContext fileSetupContext, ResourceTweaker resourceTweaker) {
        try {
            XpectN4JSES5TranspilerHelper transpilerHelper = (XpectN4JSES5TranspilerHelper)resource.getResourceServiceProvider().get(XpectN4JSES5TranspilerHelper.class);
            return transpilerHelper.doCompileAndExecute(resource, init, fileSetupContext, false, resourceTweaker, GeneratorOption.DEFAULT_OPTIONS, SystemLoaderInfo.SYSTEM_JS);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while compiling script.", e);
        }
    }

    @Xpect
    @ParameterParser(syntax="('at' (arg2=STRING (arg3=ID  (arg4=STRING)?  (arg5=ID)? )? )? )?")
    @ValidationTestModuleSetup.ConsumedIssues(value={Severity.INFO, Severity.ERROR, Severity.WARNING})
    public void quickFixList(@CommaSeparatedValuesExpectation(quoted=true, ordered=true) ICommaSeparatedValuesExpectation expectation, @ThisResource XtextResource resource, RegionWithCursor offset, String checkType, String selected, String mode, @ValidationTestModuleSetup.IssuesByLine Multimap<Integer, Issue> offset2issue) throws Exception {
        List<IssueResolution> resolutions = this.collectAllResolutions(resource, offset, offset2issue);
        ArrayList resolutionNames = Lists.newArrayList();
        for (IssueResolution resolution : resolutions) {
            resolutionNames.add(resolution.getLabel());
        }
        expectation.assertEquals((Iterable)resolutionNames);
    }

    List<IssueResolution> collectAllResolutions(XtextResource resource, RegionWithCursor offset, Multimap<Integer, Issue> offset2issue) {
        EObject script = (EObject)resource.getContents().get(0);
        ICompositeNode scriptNode = NodeModelUtils.getNode((EObject)script);
        ILeafNode offsetNode = NodeModelUtils.findLeafNodeAtOffset((INode)scriptNode, (int)offset.getGlobalCursorOffset());
        int offStartLine = offsetNode.getTotalStartLine();
        List<Issue> allIssues = QuickFixTestHelper.extractAllIssuesInLine(offStartLine, offset2issue);
        ArrayList resolutions = Lists.newArrayList();
        for (Issue issue : allIssues) {
            if (issue.getLineNumber().intValue() != offsetNode.getStartLine() || issue.getLineNumber() > offsetNode.getEndLine()) continue;
            IssueResolutionProvider quickfixProvider = (IssueResolutionProvider)resource.getResourceServiceProvider().get(IssueResolutionProvider.class);
            Display.getDefault().syncExec(() -> {
                boolean bl = resolutions.addAll(quickfixProvider.getResolutions(issue));
            });
        }
        return resolutions;
    }

    private String getContentForResourceUri(URI uri) throws Exception {
        String platformStr = uri.toString().replace("platform:/resource/", "");
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(platformStr));
        InputStream fileStream = file.getContents();
        Scanner s = new Scanner(fileStream, file.getCharset());
        s.useDelimiter("\\A");
        String content = s.hasNext() ? s.next() : "";
        fileStream.close();
        s.close();
        return content;
    }

    private static class ExecutionResult {
        public String result;

        private ExecutionResult() {
        }
    }

    private final class WSAwareTokenAdapter
    implements IStringDiffExpectation.ITokenAdapter<String> {
        private WSAwareTokenAdapter() {
        }

        public boolean isHidden(String token, String segment) {
            return false;
        }

        public Iterable<String> splitIntoSegments(String token) {
            return Collections.singleton(token);
        }

        public float similarity(String token1, String segment1, String token2, String segment2) {
            return token1.equals(token2) ? 0.0f : 1.0f;
        }
    }
}

