/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.contentassist;

import com.google.inject.Inject;
import com.google.inject.Injector;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xpect.registry.DefaultBinding;
import org.eclipse.xpect.services.XpectGrammarAccess;
import org.eclipse.xpect.ui.internal.XpectActivator;
import org.eclipse.xpect.ui.util.XpectFileAccess;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.eclipse.xtext.ui.editor.contentassist.IContentProposalProvider;
import org.eclipse.xtext.ui.editor.contentassist.RepeatedContentAssistProcessor;

public class XtProposalProvider
implements IContentProposalProvider,
RepeatedContentAssistProcessor.ModeAware {
    private final Injector xpectInjector = XpectActivator.getInstance().getInjector("org.eclipse.xpect.Xpect");
    @Inject
    @DefaultBinding
    private IContentProposalProvider dslDelegate;
    private IContentProposalProvider xpectDelegate = (IContentProposalProvider)this.xpectInjector.getInstance(IContentProposalProvider.class);
    private ContentAssistContext.Factory xpectContextFactory = (ContentAssistContext.Factory)this.xpectInjector.getInstance(ContentAssistContext.Factory.class);
    private XpectGrammarAccess xpectGrammarAccess = (XpectGrammarAccess)this.xpectInjector.getInstance(XpectGrammarAccess.class);

    public void createProposals(ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        if (this.showXpectProposals(context)) {
            XtextResource xpectResource = XpectFileAccess.getXpectResource((Resource)context.getResource());
            ContentAssistContext[] contexts = this.xpectContextFactory.create(context.getViewer(), context.getOffset(), xpectResource);
            boolean showDslProposals = false;
            ContentAssistContext[] contentAssistContextArray = contexts;
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                ContentAssistContext xpectContext = contentAssistContextArray[n2];
                if (acceptor.canAcceptMoreProposals()) {
                    if (this.isXpectText(xpectContext)) {
                        showDslProposals = true;
                    }
                    this.xpectDelegate.createProposals(xpectContext, acceptor);
                }
                ++n2;
            }
            if (showDslProposals && acceptor.canAcceptMoreProposals()) {
                this.dslDelegate.createProposals(context, acceptor);
            }
        } else {
            this.dslDelegate.createProposals(context, acceptor);
        }
    }

    protected boolean isXpectText(ContentAssistContext context) {
        INode node = context.getCurrentNode();
        if (node == null || !(node.getGrammarElement() instanceof RuleCall)) {
            return false;
        }
        RuleCall rc = (RuleCall)node.getGrammarElement();
        return rc.getRule() == this.xpectGrammarAccess.getANY_OTHERRule();
    }

    protected boolean showXpectProposals(ContentAssistContext context) {
        if (!(context.getCurrentNode() instanceof ILeafNode)) {
            return false;
        }
        ILeafNode node = (ILeafNode)context.getCurrentNode();
        if (!node.isHidden()) {
            return false;
        }
        String text = node.getText();
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getNextCategory() {
        if (this.dslDelegate instanceof RepeatedContentAssistProcessor.ModeAware) {
            return ((RepeatedContentAssistProcessor.ModeAware)this.dslDelegate).getNextCategory();
        }
        return "";
    }

    public boolean isLastMode() {
        if (this.dslDelegate instanceof RepeatedContentAssistProcessor.ModeAware) {
            return ((RepeatedContentAssistProcessor.ModeAware)this.dslDelegate).isLastMode();
        }
        return true;
    }

    public void nextMode() {
        if (this.dslDelegate instanceof RepeatedContentAssistProcessor.ModeAware) {
            ((RepeatedContentAssistProcessor.ModeAware)this.dslDelegate).nextMode();
        }
    }

    public void reset() {
        if (this.dslDelegate instanceof RepeatedContentAssistProcessor.ModeAware) {
            ((RepeatedContentAssistProcessor.ModeAware)this.dslDelegate).reset();
        }
    }
}

