/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.ui.adoc;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.adoc.JSDoc2ADocSpecProcessor;
import org.eclipse.n4js.jsdoc2spec.ui.ComparePageVisibilityListener;
import org.eclipse.n4js.jsdoc2spec.ui.SpecChangeSetProvider;
import org.eclipse.n4js.jsdoc2spec.ui.SpecComparePage;
import org.eclipse.n4js.jsdoc2spec.ui.SpecExportCodeSummaryPage;
import org.eclipse.n4js.jsdoc2spec.ui.SpecPage;
import org.eclipse.n4js.jsdoc2spec.ui.SpecProcessPage;
import org.eclipse.n4js.jsdoc2spec.ui.SummaryPageVisibilityListener;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.ConfigAdoc;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.SpecConfigAdocPage;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.TaskGenerateAdoc;
import org.eclipse.n4js.jsdoc2spec.ui.adoc.TaskWriteFiles;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.xtext.ui.resource.IResourceSetProvider;

public class ADocSpecExportWizard
extends Wizard
implements IExportWizard,
SpecChangeSetProvider {
    static final String WIZARD_NAME = "AdocSpecExportWizard";
    @Inject
    private JSDoc2ADocSpecProcessor jsDoc2SpecProcessor;
    @Inject
    private IResourceSetProvider resourceSetProvider;
    @Inject
    private IN4JSCore n4JSCore;
    private SpecConfigAdocPage configAdocPage;
    private SpecProcessPage processAdocPage;
    private SpecComparePage comparePage;
    private SpecExportCodeSummaryPage summaryPage;
    private SpecProcessPage processOutputPage;
    private IStructuredSelection selection;
    private ConfigAdoc configAdoc;
    private TaskGenerateAdoc taskGenAdoc;
    private TaskWriteFiles taskWriteFiles;

    public ADocSpecExportWizard() {
        IDialogSettings workbenchSettings = WorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(WIZARD_NAME);
        if (section == null) {
            section = workbenchSettings.addNewSection(WIZARD_NAME);
        }
        this.setDialogSettings(section);
    }

    public boolean performFinish() {
        return true;
    }

    public void init(IWorkbench targetWorkbench, IStructuredSelection currentSelection) {
        this.selection = currentSelection;
        List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
        if (!selectedResources.isEmpty()) {
            this.selection = new StructuredSelection(selectedResources);
        }
        this.setWindowTitle("AsciiDoc Specification Export");
        this.setNeedsProgressMonitor(true);
        this.configAdocPage = new SpecConfigAdocPage("Configuration Page");
        this.processAdocPage = new SpecProcessPage("Process Page");
        this.comparePage = new SpecComparePage("Compare Page", "Adoc");
        this.summaryPage = new SpecExportCodeSummaryPage("Summary Page");
        this.processOutputPage = new SpecProcessPage("Process Page");
        this.taskGenAdoc = new TaskGenerateAdoc(this.jsDoc2SpecProcessor, this.resourceSetProvider, this.n4JSCore, this.selection, this.configAdocPage, this.processAdocPage);
        this.taskWriteFiles = new TaskWriteFiles(this.processOutputPage, this.taskGenAdoc);
        this.addVisibilityListeners();
    }

    private void addVisibilityListeners() {
        this.processAdocPage.setChangeListener(new SpecPage.VisibilityChangedListener(){
            boolean tasksPerformed = false;

            @Override
            public void isVisibleChanged(boolean visible) {
                if (visible && !this.tasksPerformed) {
                    ADocSpecExportWizard.this.performAdocTasks();
                    this.tasksPerformed = true;
                }
            }
        });
        this.comparePage.setChangeListener(new ComparePageVisibilityListener(this, this.comparePage));
        this.summaryPage.setChangeListener(new SummaryPageVisibilityListener(this, this.summaryPage));
        this.processOutputPage.setChangeListener(new SpecPage.VisibilityChangedListener(){
            boolean tasksPerformed = false;

            @Override
            public void isVisibleChanged(boolean visible) {
                if (visible && !this.tasksPerformed) {
                    ADocSpecExportWizard.this.performWriteFileTasks();
                    this.tasksPerformed = true;
                    ADocSpecExportWizard.this.processOutputPage.displayMessage("done.");
                }
            }
        });
    }

    public void addPages() {
        this.addPage((IWizardPage)this.configAdocPage);
        this.addPage((IWizardPage)this.processAdocPage);
        this.addPage((IWizardPage)this.comparePage);
        this.addPage((IWizardPage)this.summaryPage);
        this.addPage((IWizardPage)this.processOutputPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.configAdocPage) {
            return this.processAdocPage;
        }
        if (page == this.processAdocPage) {
            if (this.getSpecChangeSet() == null || this.getSpecChangeSet().isEmpty()) {
                return this.processOutputPage;
            }
            return this.comparePage;
        }
        if (page == this.comparePage) {
            return this.summaryPage;
        }
        if (page == this.summaryPage) {
            return this.processOutputPage;
        }
        if (page == this.processOutputPage) {
            return null;
        }
        throw new RuntimeException("Missing page successor.");
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.configAdocPage) {
            return null;
        }
        if (page == this.processAdocPage) {
            return this.configAdocPage;
        }
        if (page == this.comparePage) {
            return this.processAdocPage;
        }
        if (page == this.summaryPage) {
            return this.comparePage;
        }
        if (page == this.processOutputPage) {
            return null;
        }
        throw new RuntimeException("Missing page predecessor.");
    }

    @Override
    public Set<SpecFile> getSpecChangeSet() {
        return this.taskGenAdoc.getSpecChangeSet();
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean canFinish() {
        IWizardPage curPage = this.getContainer().getCurrentPage();
        return curPage == this.processOutputPage;
    }

    void performAdocTasks() {
        try {
            this.configAdoc = this.configAdocPage.getConfig();
            this.taskGenAdoc.setConfig(this.configAdoc);
            this.getContainer().run(true, true, (IRunnableWithProgress)this.taskGenAdoc);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.processAdocPage.setErrorMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    void performWriteFileTasks() {
        try {
            this.configAdoc = this.configAdocPage.getConfig();
            this.taskWriteFiles.setConfig(this.configAdoc);
            this.getContainer().run(true, true, (IRunnableWithProgress)this.taskWriteFiles);
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.processOutputPage.setErrorMessage(e.getMessage());
            e.printStackTrace();
        }
    }
}

