/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.analysis;

import com.google.common.base.Preconditions;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.analysis.NextEdgesProvider;
import org.eclipse.n4js.flowgraphs.model.ControlFlowEdge;
import org.eclipse.n4js.flowgraphs.model.Node;

abstract class DeadFlowContext {
    DeadFlowContext() {
    }

    static DeadFlowContext create(DeadFlowContext deadCtx, NextEdgesProvider edgeProv, ControlFlowEdge edge) {
        if (edgeProv.isForward()) {
            return new Forward(deadCtx, edgeProv, edge);
        }
        return new Backward(deadCtx);
    }

    abstract void follow(DeadFlowContext var1);

    abstract void update(Node var1);

    abstract void update(NextEdgesProvider var1, ControlFlowEdge var2);

    abstract void joinWith(DeadFlowContext var1);

    abstract boolean isForwardDeadFlow();

    abstract boolean isDead();

    public String toString() {
        return this.isDead() ? "dead" : "live";
    }

    static class Backward
    extends DeadFlowContext {
        boolean isDeadCode = false;

        Backward(DeadFlowContext deadContext) {
            if (deadContext != null) {
                this.follow(deadContext);
            }
        }

        @Override
        void follow(DeadFlowContext deadContext) {
            this.isDeadCode = deadContext.isDead();
        }

        @Override
        void update(Node node) {
            this.setDeadCode(node);
        }

        @Override
        void update(NextEdgesProvider edgeProvider, ControlFlowEdge edge) {
            Node nextNode = edgeProvider.getNextNode(edge);
            this.setDeadCode(nextNode);
        }

        @Override
        void joinWith(DeadFlowContext deadContext) {
        }

        @Override
        boolean isForwardDeadFlow() {
            return false;
        }

        @Override
        boolean isDead() {
            return this.isDeadCode;
        }

        private void setDeadCode(Node node) {
            Preconditions.checkState((boolean)node.isVisited());
            this.isDeadCode = node.isUnreachable();
        }
    }

    static class Forward
    extends DeadFlowContext {
        private ControlFlowEdge switchEdge;

        Forward(DeadFlowContext deadContext, NextEdgesProvider edgeProv, ControlFlowEdge edge) {
            if (deadContext != null) {
                this.follow(deadContext);
            }
            this.update(edgeProv, edge);
        }

        @Override
        void follow(DeadFlowContext deadContext) {
            this.switchEdge = ((Forward)deadContext).switchEdge;
        }

        @Override
        void update(Node node) {
            this.setDeadCode(node);
        }

        @Override
        void update(NextEdgesProvider edgeProvider, ControlFlowEdge edge) {
            if (edge.cfType == ControlFlowType.DeadCode) {
                this.switchEdge = edge;
            }
            Node nextNode = edgeProvider.getNextNode(edge);
            this.setDeadCode(nextNode);
        }

        @Override
        void joinWith(DeadFlowContext deadContext) {
            if (((Forward)deadContext).switchEdge == null) {
                this.switchEdge = null;
            }
        }

        @Override
        boolean isForwardDeadFlow() {
            return this.switchEdge != null;
        }

        @Override
        boolean isDead() {
            return this.switchEdge != null;
        }

        private void setDeadCode(Node nextNode) {
            if (!nextNode.isReachable()) {
                if (this.isDead()) {
                    nextNode.setUnreachable();
                } else {
                    nextNode.setReachable();
                }
            }
        }
    }
}

