/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.ui.editor;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IEditorAssociationOverride;
import org.eclipse.xpect.registry.ILanguageInfo;
import org.eclipse.xpect.ui.util.ContentTypeUtil;
import org.eclipse.xpect.util.URIDelegationHandler;

public class XpectEditorAssociationOverride
implements IEditorAssociationOverride {
    @Inject
    private ContentTypeUtil contentTypeHelper;
    private final IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
    @Inject
    private URIDelegationHandler uriHandler;
    private final IEditorDescriptor xpectEditor = this.registry.findEditor("org.eclipse.xpect.Xpect");
    private final IEditorDescriptor xtEditor = this.registry.findEditor("org.eclipse.xpect.Xt");

    protected IFile getFile(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile();
        }
        return null;
    }

    protected boolean isXtFile(IFile file) {
        String extension = this.uriHandler.getOriginalFileExtension(file.getName());
        return extension != null && ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension(extension) != null;
    }

    protected boolean hasFavoriteEditor(IFile file) {
        block4: {
            if (file.exists()) break block4;
            return false;
        }
        try {
            String favoriteEditor = file.getPersistentProperty(IDE.EDITOR_KEY);
            if (favoriteEditor != null) {
                return true;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return false;
    }

    public IEditorDescriptor overrideDefaultEditor(IEditorInput editorInput, IContentType contentType, IEditorDescriptor editorDescriptor) {
        IFile file = this.getFile(editorInput);
        if (file == null || this.hasFavoriteEditor(file)) {
            return editorDescriptor;
        }
        ContentTypeUtil.XpectContentType type = this.contentTypeHelper.getContentType(file);
        switch (type) {
            case XPECT: {
                if (this.isXtFile(file)) {
                    return this.xtEditor;
                }
                return this.xpectEditor;
            }
        }
        return editorDescriptor;
    }

    public IEditorDescriptor overrideDefaultEditor(String fileName, IContentType contentType, IEditorDescriptor editorDescriptor) {
        return editorDescriptor;
    }

    public IEditorDescriptor[] overrideEditors(IEditorInput editorInput, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        IFile file = this.getFile(editorInput);
        if (file == null) {
            return editorDescriptors;
        }
        ContentTypeUtil.XpectContentType type = this.contentTypeHelper.getContentType(file);
        switch (type) {
            case XPECT: {
                LinkedHashSet editors = Sets.newLinkedHashSet();
                Collections.addAll(editors, editorDescriptors);
                String extension = this.uriHandler.getOriginalFileExtension(file.getName());
                if (extension != null && ILanguageInfo.Registry.INSTANCE.getLanguageByFileExtension(extension) != null) {
                    Collections.addAll(editors, this.registry.getEditors("*." + extension));
                    editors.add(this.xtEditor);
                }
                editors.add(this.xpectEditor);
                return editors.toArray(new IEditorDescriptor[editors.size()]);
            }
        }
        return editorDescriptors;
    }

    public IEditorDescriptor[] overrideEditors(String fileName, IContentType contentType, IEditorDescriptor[] editorDescriptors) {
        return editorDescriptors;
    }
}

