/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.log;

import java.io.File;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.log.EquinoxLogFactory;
import org.eclipse.osgi.internal.log.EquinoxLogWriter;
import org.eclipse.osgi.internal.log.LogServiceManager;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.storage.StorageUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.log.LogLevel;

public class EquinoxLogServices {
    static final String EQUINOX_LOGGER_NAME = "org.eclipse.equinox.logger";
    static final String PERF_LOGGER_NAME = "org.eclipse.performance.logger";
    private static final String PROP_LOG_ENABLED = "eclipse.log.enabled";
    private static final String LOG_EXT = ".log";
    private final LogServiceManager logServiceManager;
    private final EquinoxLogFactory eclipseLogFactory;
    private final EquinoxLogWriter logWriter;
    private final EquinoxLogWriter perfWriter;
    private final FrameworkLog rootFrameworkLog;
    private ServiceRegistration<?> frameworkLogReg;
    private ServiceRegistration<?> perfLogReg;

    public EquinoxLogServices(EquinoxConfiguration environmentInfo) {
        File logFile;
        Location configuration = environmentInfo.getEquinoxLocations().getConfigurationLocation();
        String logFilePath = environmentInfo.getConfiguration("osgi.logfile");
        if (logFilePath == null) {
            logFilePath = String.valueOf(Long.toString(System.currentTimeMillis())) + LOG_EXT;
        }
        if (!(logFile = new File(logFilePath)).isAbsolute()) {
            File configAreaDirectory = null;
            if (configuration != null) {
                configAreaDirectory = new File(configuration.getURL().getPath());
            }
            logFile = configAreaDirectory != null ? new File(configAreaDirectory, logFilePath) : null;
        }
        boolean enabled = "true".equals(environmentInfo.getConfiguration(PROP_LOG_ENABLED, "true"));
        if (logFile != null) {
            environmentInfo.setConfiguration("osgi.logfile", logFile.getAbsolutePath());
            this.logWriter = new EquinoxLogWriter(logFile, EQUINOX_LOGGER_NAME, enabled, environmentInfo);
            File perfLogFile = new File(logFile.getParentFile(), "performance.log");
            this.perfWriter = new EquinoxLogWriter(perfLogFile, PERF_LOGGER_NAME, true, environmentInfo);
        } else {
            this.logWriter = new EquinoxLogWriter(null, EQUINOX_LOGGER_NAME, enabled, environmentInfo);
            this.perfWriter = new EquinoxLogWriter(null, PERF_LOGGER_NAME, true, environmentInfo);
        }
        if ("true".equals(environmentInfo.getConfiguration("eclipse.consoleLog"))) {
            this.logWriter.setConsoleLog(true);
        }
        String logHistoryMaxProp = environmentInfo.getConfiguration("equinox.log.history.max");
        int logHistoryMax = 0;
        if (logHistoryMaxProp != null) {
            try {
                logHistoryMax = Integer.parseInt(logHistoryMaxProp);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        LogLevel defaultLevel = LogLevel.WARN;
        try {
            String defaultLevelConfig = environmentInfo.getConfiguration("org.osgi.service.log.admin.loglevel");
            if (defaultLevelConfig != null) {
                defaultLevel = LogLevel.valueOf(defaultLevelConfig);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.logServiceManager = new LogServiceManager(logHistoryMax, defaultLevel, this.logWriter, this.perfWriter);
        this.eclipseLogFactory = new EquinoxLogFactory(this.logWriter, this.logServiceManager);
        this.rootFrameworkLog = this.eclipseLogFactory.createFrameworkLog(null, this.logWriter);
        this.logWriter.setLoggerAdmin(this.logServiceManager.getLoggerAdmin());
        this.perfWriter.setLoggerAdmin(this.logServiceManager.getLoggerAdmin());
    }

    public void start(BundleContext context) throws BundleException {
        this.logServiceManager.start(context);
        this.frameworkLogReg = StorageUtil.register(FrameworkLog.class.getName(), this.eclipseLogFactory, context);
        this.perfLogReg = this.registerPerformanceLog(context);
    }

    public void stop(BundleContext context) throws BundleException {
        this.frameworkLogReg.unregister();
        this.perfLogReg.unregister();
        this.logServiceManager.stop(context);
    }

    public FrameworkLog getFrameworkLog() {
        return this.rootFrameworkLog;
    }

    private ServiceRegistration<?> registerPerformanceLog(BundleContext context) {
        FrameworkLog service = this.createPerformanceLog(context.getBundle());
        String serviceName = FrameworkLog.class.getName();
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>(7);
        Dictionary<String, String> headers = context.getBundle().getHeaders();
        ((Dictionary)serviceProperties).put("service.vendor", headers.get("Bundle-Vendor"));
        ((Dictionary)serviceProperties).put("service.ranking", Integer.MIN_VALUE);
        ((Dictionary)serviceProperties).put("service.pid", String.valueOf(context.getBundle().getBundleId() + 46L) + service.getClass().getName());
        ((Dictionary)serviceProperties).put("performance", Boolean.TRUE.toString());
        return context.registerService(serviceName, (Object)service, serviceProperties);
    }

    private FrameworkLog createPerformanceLog(Bundle systemBundle) {
        return this.eclipseLogFactory.createFrameworkLog(systemBundle, this.perfWriter);
    }

    public void log(String entry, int severity, String message, Throwable throwable) {
        this.log(entry, severity, message, throwable, null);
    }

    public void log(String entry, int severity, String message, Throwable throwable, FrameworkLogEntry[] children) {
        this.getFrameworkLog().log(new FrameworkLogEntry(entry, severity, 0, message, 0, throwable, children));
    }
}

