/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.ui;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.n4js.runner.RunConfiguration;
import org.eclipse.n4js.runner.RunnerFrontEnd;

@Singleton
public class RunConfigurationConverter {
    @Inject
    private RunnerFrontEnd runnerFrontEnd;

    public RunConfiguration toRunConfiguration(ILaunchConfiguration launchConfig) throws CoreException {
        try {
            Map properties = launchConfig.getAttributes();
            properties.put("NAME", launchConfig.getName());
            return this.runnerFrontEnd.createConfiguration(properties);
        }
        catch (Exception e) {
            String msg = "Error occurred while trying to launch module.";
            if (e.getMessage() != null) {
                msg = String.valueOf(msg) + "\nReason: " + e.getMessage();
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.n4js.runner.ui", msg, (Throwable)e));
        }
    }

    public ILaunchConfiguration toLaunchConfiguration(ILaunchConfigurationType type, RunConfiguration runConfig) {
        try {
            ILaunchConfiguration[] configs;
            ILaunchConfiguration[] iLaunchConfigurationArray = configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunchConfiguration config = iLaunchConfigurationArray[n2];
                if (this.equals(runConfig, config)) {
                    return config;
                }
                ++n2;
            }
            IContainer container = null;
            ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(container, runConfig.getName());
            workingCopy.setAttributes(runConfig.readPersistentValues());
            return workingCopy.doSave();
        }
        catch (Exception e) {
            throw new WrappedException("could not convert N4JS RunConfiguration to Eclipse ILaunchConfiguration", e);
        }
    }

    private boolean equals(RunConfiguration runConfig, ILaunchConfiguration launchConfig) {
        return runConfig.getName().equals(launchConfig.getName());
    }
}

