/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.jsdoc.dom.FullMemberReference;
import org.eclipse.n4js.jsdoc2spec.IJSDoc2SpecIssueAcceptor;
import org.eclipse.n4js.jsdoc2spec.KeyUtils;
import org.eclipse.n4js.jsdoc2spec.RepoRelativePath;
import org.eclipse.n4js.jsdoc2spec.SpecElementRef;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.SpecTestInfo;
import org.eclipse.n4js.jsdoc2spec.adoc.RepoRelativePathHolder;
import org.eclipse.n4js.n4JS.N4JSPackage;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.scoping.N4JSGlobalScopeProvider;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.SyntaxRelatedTElement;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TVariable;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.utils.ContainerTypesHelper;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class SpecInfosByName {
    private final Multimap<String, SpecInfo> specInfoByName = HashMultimap.create();
    private final IJSDoc2SpecIssueAcceptor issueAcceptor;
    private final ContainerTypesHelper containerTypesHelper;
    private final N4JSGlobalScopeProvider globalScopeProvider;
    private final IN4JSCore n4jsCore;

    SpecInfosByName(IJSDoc2SpecIssueAcceptor issueAcceptor, N4JSGlobalScopeProvider globalScopeProvider, ContainerTypesHelper containerTypesHelper, IN4JSCore n4jsCore) {
        this.issueAcceptor = issueAcceptor;
        this.globalScopeProvider = globalScopeProvider;
        this.containerTypesHelper = containerTypesHelper;
        this.n4jsCore = n4jsCore;
    }

    void createTypeSpecInfo(Type type, RepoRelativePathHolder rrph) {
        SpecInfo typeInfo = new SpecInfo((IdentifiableElement)type);
        String regionName = KeyUtils.getSpecKeyWithoutProjectFolder(rrph, (IdentifiableElement)type);
        this.specInfoByName.put((Object)regionName, (Object)typeInfo);
        Collection identicalSpecInfo = this.specInfoByName.get((Object)regionName);
        if (identicalSpecInfo.size() > 1) {
            SpecInfo polyfillAware = null;
            LinkedList<SpecInfo> polyfilling = new LinkedList<SpecInfo>();
            for (SpecInfo si : identicalSpecInfo) {
                Type moduleType = si.specElementRef.getElementAsType();
                if (moduleType == null) continue;
                TModule typeModule = moduleType.getContainingModule();
                if (typeModule.isStaticPolyfillModule()) {
                    polyfilling.add(si);
                    continue;
                }
                if (!typeModule.isStaticPolyfillAware()) continue;
                polyfillAware = si;
            }
            if (polyfillAware != null) {
                Type polyfillAwareType = polyfillAware.specElementRef.getElementAsType();
                for (SpecInfo si : polyfilling) {
                    si.specElementRef.polyfillAware = polyfillAwareType;
                }
            }
        }
    }

    void createTVarSpecInfo(TVariable tvar, RepoRelativePathHolder rrph) {
        String name = KeyUtils.getSpecKeyWithoutProjectFolder(rrph, (IdentifiableElement)tvar);
        this.specInfoByName.put((Object)name, (Object)new SpecInfo((IdentifiableElement)tvar));
    }

    void addTestInfoForCodeElement(RepoRelativePath rrpOfTest, Doclet testMethodDoclet, FullMemberReference ref, TMember testMember) {
        RepoRelativePath rrpOfTestee = this.computeRRP(ref, testMember);
        String fullTypeName = ref.fullTypeName();
        String regionName = KeyUtils.getSpecKeyWithoutProjectFolder(rrpOfTestee, fullTypeName);
        Collection specInfos = this.specInfoByName.get((Object)regionName);
        boolean testeeMemberFound = false;
        for (SpecInfo specInfo : specInfos) {
            for (Type testee : specInfo.specElementRef.getTypes()) {
                if (!(testee instanceof ContainerType) || !ref.memberNameSet()) continue;
                TMember testeeMember = this.getRefMember((ContainerType)testee, ref);
                if (testeeMember != null) {
                    String testeeName = testeeMember.getName();
                    SpecTestInfo testSpecInfo = this.createTestSpecInfo(testeeName, testMethodDoclet, testMember, rrpOfTest);
                    specInfo.addMemberTestInfo(testeeMember, testSpecInfo);
                }
                testeeMemberFound = true;
            }
        }
        if (!testeeMemberFound) {
            for (SpecInfo specInfo : specInfos) {
                String elementName = specInfo.specElementRef.identifiableElement.getName();
                SpecTestInfo testSpecInfo = this.createTestSpecInfo(elementName, testMethodDoclet, testMember, rrpOfTest);
                specInfo.addTypeTestInfo(testSpecInfo);
            }
            if (specInfos.isEmpty()) {
                this.issueAcceptor.addWarning("Testee " + fullTypeName + " not found", (EObject)testMember);
            }
        }
    }

    private RepoRelativePath computeRRP(FullMemberReference ref, TMember testMember) {
        QualifiedName qn;
        IScope scope = this.globalScopeProvider.getScope(testMember.eResource(), N4JSPackage.Literals.IMPORT_DECLARATION__MODULE);
        IEObjectDescription eod = scope.getSingleElement(qn = QualifiedName.create((String[])ref.getModuleName().split("/")));
        if (eod != null) {
            URI uri = eod.getEObjectURI();
            RepoRelativePath rrp = RepoRelativePath.compute(uri, this.n4jsCore);
            return rrp;
        }
        this.issueAcceptor.addWarning("Cannot resolve testee " + ref, (EObject)testMember);
        return null;
    }

    private SpecTestInfo createTestSpecInfo(String testeeName, Doclet doclet, TMember testMember, RepoRelativePath rrpOfTest) {
        String moduleName = testMember.getContainingModule().getModuleSpecifier();
        String typeName = testMember.getContainingType().getName();
        String memberName = testMember.getName();
        QualifiedName qualifiedName = QualifiedName.create((String[])new String[]{moduleName, typeName, memberName});
        RepoRelativePath repoRelPath = rrpOfTest != null ? rrpOfTest.withLine((SyntaxRelatedTElement)testMember) : null;
        return new SpecTestInfo(testeeName, qualifiedName, doclet, repoRelPath);
    }

    private TMember getRefMember(ContainerType<?> ct, FullMemberReference ref) {
        TMember member = null;
        String memberName = ref.getMemberName();
        boolean _static = ref.isStaticMember();
        ContainerTypesHelper.MemberCollector memberCollector = this.containerTypesHelper.fromContext(ct);
        member = memberCollector.findMember(ct, memberName, false, _static);
        if (member == null) {
            member = memberCollector.findMember(ct, memberName, false, !_static);
            if (member == null && (member = memberCollector.findMember(ct, memberName, true, _static)) == null) {
                member = memberCollector.findMember(ct, memberName, true, !_static);
            }
        }
        return member;
    }

    void addTestInfoForRequirement(RepoRelativePath rrp, Doclet testMethodDoclet, String reqid, TMember testMember) {
        Collection specInfos = this.specInfoByName.get((Object)SpecElementRef.reqidKey(reqid));
        if (specInfos.isEmpty()) {
            SpecInfo specInfo = new SpecInfo(reqid);
            this.specInfoByName.put((Object)SpecElementRef.reqidKey(reqid), (Object)specInfo);
        }
        for (SpecInfo specInfo : specInfos) {
            specInfo.addTypeTestInfo(this.createTestSpecInfo(reqid, testMethodDoclet, testMember, rrp));
        }
    }

    Collection<SpecInfo> values() {
        return this.specInfoByName.values();
    }
}

