/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.json.JSON.JSONArray;
import org.eclipse.n4js.json.JSON.JSONDocument;
import org.eclipse.n4js.json.JSON.JSONObject;
import org.eclipse.n4js.json.JSON.JSONStringLiteral;
import org.eclipse.n4js.json.JSON.JSONValue;
import org.eclipse.n4js.json.model.utils.JSONModelUtils;
import org.eclipse.n4js.packagejson.PackageJsonHelper;
import org.eclipse.n4js.packagejson.PackageJsonProperties;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.util.Pair;
import org.eclipse.xtext.util.Tuples;

@Singleton
public class ProjectDescriptionLoader {
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private PackageJsonHelper packageJsonHelper;

    public ProjectDescription loadProjectDescriptionAtLocation(URI location) {
        JSONDocument packageJSON = this.loadPackageJSONAtLocation(location);
        if (packageJSON == null) {
            return null;
        }
        return this.loadProjectDescriptionAtLocation(location, packageJSON);
    }

    public ProjectDescription loadProjectDescriptionAtLocation(URI location, JSONDocument packageJSON) {
        ProjectDescription pdFromPackageJSON;
        this.adjustMainPath(location, packageJSON);
        String defaultProjectName = ProjectDescriptionUtils.deriveN4JSProjectNameFromURI(location);
        ProjectDescription projectDescription = pdFromPackageJSON = packageJSON != null ? this.packageJsonHelper.convertToProjectDescription(packageJSON, true, defaultProjectName) : null;
        if (pdFromPackageJSON != null) {
            this.setInformationFromFileSystem(location, pdFromPackageJSON);
            return pdFromPackageJSON;
        }
        return null;
    }

    public Pair<String, Boolean> loadVersionAndN4JSNatureFromProjectDescriptionAtLocation(URI location) {
        JSONDocument packageJSON = this.loadPackageJSONAtLocation(location);
        JSONValue versionValue = null;
        boolean hasN4JSNature = false;
        if (packageJSON != null) {
            versionValue = JSONModelUtils.getProperty((JSONDocument)packageJSON, (String)PackageJsonProperties.VERSION.name).orElse(null);
            hasN4JSNature = JSONModelUtils.getProperty((JSONDocument)packageJSON, (String)PackageJsonProperties.N4JS.name).isPresent();
        }
        Pair result = Tuples.create((Object)JSONModelUtils.asNonEmptyStringOrNull(versionValue), (Object)hasN4JSNature);
        return result;
    }

    public List<String> loadWorkspacesFromProjectDescriptionAtLocation(URI location) {
        JSONValue value;
        JSONDocument packageJSON = this.loadPackageJSONAtLocation(location);
        if (packageJSON != null && (value = (JSONValue)JSONModelUtils.getProperty((JSONDocument)packageJSON, (String)PackageJsonProperties.WORKSPACES.name).orElse(null)) instanceof JSONArray) {
            ArrayList<String> result = new ArrayList<String>();
            for (JSONValue element : ((JSONArray)value).getElements()) {
                if (!(element instanceof JSONStringLiteral)) continue;
                result.add(((JSONStringLiteral)element).getValue());
            }
            return result;
        }
        return null;
    }

    private void adjustMainPath(URI location, JSONDocument packageJSON) {
        JSONValue content = packageJSON.getContent();
        if (!(content instanceof JSONObject)) {
            return;
        }
        JSONObject contentCasted = (JSONObject)content;
        String main = JSONModelUtils.asNonEmptyStringOrNull((JSONValue)JSONModelUtils.getProperty((JSONObject)contentCasted, (String)PackageJsonProperties.MAIN.name).orElse(null));
        if (main == null) {
            return;
        }
        String pattern = File.separatorChar != '/' ? String.valueOf(Pattern.quote(File.separator)) + "|" + Pattern.quote("/") : Pattern.quote("/");
        String[] mainSegments = main.split(pattern, -1);
        URI locationWithMain = location.appendSegments(mainSegments);
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        if (!main.endsWith(".js") && this.isFile(resourceSet, locationWithMain.appendFileExtension("js"))) {
            main = String.valueOf(main) + ".js";
            JSONModelUtils.setProperty((JSONObject)contentCasted, (String)PackageJsonProperties.MAIN.name, (String)main);
        } else if (this.isDirectory(resourceSet, locationWithMain)) {
            if (!main.endsWith("/") && !main.endsWith(File.separator)) {
                main = String.valueOf(main) + "/";
            }
            main = String.valueOf(main) + "index.js";
            JSONModelUtils.setProperty((JSONObject)contentCasted, (String)PackageJsonProperties.MAIN.name, (String)main);
        }
    }

    private void setInformationFromFileSystem(URI location, ProjectDescription target) {
        ResourceSet resourceSet = (ResourceSet)this.resourceSetProvider.get();
        boolean hasNestedNodeModulesFolder = this.exists(resourceSet, location.appendSegment("node_modules"));
        target.setHasNestedNodeModulesFolder(hasNestedNodeModulesFolder);
    }

    private JSONDocument loadPackageJSONAtLocation(URI location) {
        JSONDocument packageJSON = this.loadXtextFileAtLocation(location, "package.json", JSONDocument.class);
        if (packageJSON == null) {
            packageJSON = this.loadXtextFileAtLocation(location, "package.json" + PackageJsonProperties.OUTPUT.defaultValue + "xt", JSONDocument.class);
        }
        return packageJSON;
    }

    private <T extends EObject> T loadXtextFileAtLocation(URI location, String name, Class<T> expectedTypeOfRoot) {
        if (!location.isPlatformResource() && !location.isFile()) {
            return null;
        }
        T result = this.loadXtextFile(location.appendSegment(name), expectedTypeOfRoot);
        return result;
    }

    private <T extends EObject> T loadXtextFile(URI uri, Class<T> expectedTypeOfRoot) {
        block4: {
            EObject root;
            EList contents;
            ResourceSet resourceSet;
            block3: {
                try {
                    resourceSet = (ResourceSet)this.resourceSetProvider.get();
                    if (this.exists(resourceSet, uri)) break block3;
                }
                catch (Exception e) {
                    throw new WrappedException("failed to load Xtext file at " + uri, e);
                }
                return null;
            }
            Resource resource = resourceSet.getResource(uri, true);
            if (resource == null || (contents = resource.getContents()).isEmpty() || !expectedTypeOfRoot.isInstance(root = (EObject)contents.get(0))) break block4;
            EObject rootCasted = root;
            contents.clear();
            return (T)rootCasted;
        }
        return null;
    }

    private boolean exists(ResourceSet resourceSet, URI uri) {
        return resourceSet.getURIConverter().exists(uri, null);
    }

    private boolean isDirectory(ResourceSet resourceSet, URI uri) {
        Map attributes = resourceSet.getURIConverter().getAttributes(uri, null);
        boolean isDirectory = Objects.equals(attributes.get("directory"), Boolean.TRUE);
        return isDirectory;
    }

    private boolean isFile(ResourceSet resourceSet, URI uri) {
        return this.exists(resourceSet, uri) && !this.isDirectory(resourceSet, uri);
    }
}

