/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.flowgraphs.model;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.flowgraphs.ControlFlowType;
import org.eclipse.n4js.flowgraphs.FGUtils;
import org.eclipse.n4js.flowgraphs.factories.CFEMapper;
import org.eclipse.n4js.flowgraphs.factories.ListUtils;
import org.eclipse.n4js.flowgraphs.model.ControlFlowable;
import org.eclipse.n4js.flowgraphs.model.Node;
import org.eclipse.n4js.flowgraphs.model.RepresentingNode;
import org.eclipse.n4js.n4JS.ControlFlowElement;

public class ComplexNode
implements ControlFlowable {
    private final ControlFlowElement container;
    private final ControlFlowElement astElement;
    private final Map<String, Node> nodeMap = new HashMap<String, Node>();
    private Node entry;
    private Node exit;
    private Node jump;
    private RepresentingNode represent;

    public ComplexNode(ControlFlowElement container, ControlFlowElement astElement) {
        this.container = container;
        this.astElement = astElement;
    }

    public void connectInternalSucc(Node ... nodes) {
        this.connectInternalSucc(ControlFlowType.Successor, Arrays.asList(nodes));
    }

    public void connectInternalSucc(List<Node> nodes) {
        this.connectInternalSucc(ControlFlowType.Successor, nodes);
    }

    public void connectInternalSucc(ControlFlowType cfType, Node ... nodes) {
        this.connectInternalSucc(cfType, Arrays.asList(nodes));
    }

    public void connectInternalSucc(ControlFlowType cfType, List<Node> nodes) {
        Iterator<Node> iter = (nodes = ListUtils.filterNulls(nodes)).iterator();
        if (!iter.hasNext()) {
            return;
        }
        Node nNext = iter.next();
        while (iter.hasNext()) {
            Preconditions.checkState((boolean)this.nodeMap.values().contains(nNext), (Object)"FlowGraph malformed: Node not child of complex node");
            Node nLast = nNext;
            nNext = iter.next();
            nLast.addInternalSuccessor(nNext, cfType);
            nNext.addInternalPredecessor(nLast, cfType);
        }
        Preconditions.checkState((boolean)this.nodeMap.values().contains(nNext), (Object)"FlowGraph malformed: Node not child of complex node");
    }

    public void addNode(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof RepresentingNode) {
            Preconditions.checkState((this.represent == null ? 1 : 0) != 0, (Object)"FlowGraph malformed: Only one RepresentingNode can be added");
            this.represent = (RepresentingNode)node;
        }
        this.nodeMap.put(node.name, node);
    }

    public void removeNode(Node node) {
        this.removeNodeChecks(node);
        this.nodeMap.remove(node.name);
    }

    public void removeNodeChecks(Node node) {
        Preconditions.checkState((this.entry != node ? 1 : 0) != 0, (Object)"FlowGraph malformed: Node not child of complex node");
        Preconditions.checkState((this.exit != node ? 1 : 0) != 0, (Object)"FlowGraph malformed: Node not child of complex node");
        Preconditions.checkState((this.represent != node ? 1 : 0) != 0, (Object)"FlowGraph malformed: Node not child of complex node");
    }

    public void setEntryNode(Node entryNode) {
        Preconditions.checkState((boolean)this.nodeMap.values().contains(entryNode), (Object)"FlowGraph malformed: Node not child of complex node");
        this.entry = entryNode;
    }

    public void setExitNode(Node exitNode) {
        Preconditions.checkState((boolean)this.nodeMap.values().contains(exitNode), (Object)"FlowGraph malformed: Node not child of complex node");
        this.exit = exitNode;
    }

    public void setJumpNode(Node jumpNode) {
        Preconditions.checkState((boolean)this.nodeMap.values().contains(jumpNode), (Object)"FlowGraph malformed: Node not child of complex node");
        Preconditions.checkState((!jumpNode.jumpToken.isEmpty() ? 1 : 0) != 0, (Object)"Jump nodes must provide jump tokens");
        this.jump = jumpNode;
    }

    public ControlFlowElement getControlFlowContainer() {
        return CFEMapper.map(this.container);
    }

    @Override
    public ControlFlowElement getControlFlowElement() {
        return CFEMapper.map(this.astElement);
    }

    public Collection<Node> getNodes() {
        return this.nodeMap.values();
    }

    public Node getNode(String name) {
        return this.nodeMap.get(name);
    }

    @Override
    public Node getEntry() {
        return this.entry;
    }

    @Override
    public Node getExit() {
        return this.exit;
    }

    public Node getJump() {
        return this.jump;
    }

    public boolean hasRepresentingNode() {
        return this.represent != null;
    }

    public RepresentingNode getRepresent() {
        return this.represent;
    }

    public List<Node> getAllButExitNodes() {
        LinkedList<Node> mNodes = new LinkedList<Node>();
        mNodes.addAll(this.nodeMap.values());
        mNodes.remove(this.exit);
        return mNodes;
    }

    public boolean isControlStatement() {
        ControlFlowElement cfe = this.getControlFlowElement();
        return FGUtils.isControlStatement(cfe);
    }

    public String toString() {
        return "CN[" + FGUtils.getClassName((EObject)this.astElement) + "]";
    }
}

