/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.utils;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.n4js.n4JS.FormalParameter;
import org.eclipse.n4js.n4JS.FunctionDefinition;
import org.eclipse.n4js.ts.scoping.builtin.BuiltInTypeScope;
import org.eclipse.n4js.ts.scoping.builtin.N4Scheme;
import org.eclipse.n4js.ts.typeRefs.BaseTypeRef;
import org.eclipse.n4js.ts.typeRefs.BoundThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.DeferredTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRef;
import org.eclipse.n4js.ts.typeRefs.ThisTypeRefStructural;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeRefsPackage;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeVariableMapping;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.VersionedParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.AnyType;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.MemberType;
import org.eclipse.n4js.ts.types.NullType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TEnum;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TField;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TFunction;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TMethod;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.TStructMember;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.types.TypingStrategy;
import org.eclipse.n4js.ts.types.UndefinedType;
import org.eclipse.n4js.ts.types.VoidType;
import org.eclipse.n4js.utils.RecursionGuard;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.util.Arrays;

public class TypeUtils {
    public static TSetter createTSetter(String name, String fparName, TypeRef fparTypeRef) {
        TSetter ph = TypesFactory.eINSTANCE.createTSetter();
        ph.setName(name);
        if (fparName != null || fparTypeRef != null) {
            TFormalParameter fpar = TypesFactory.eINSTANCE.createTFormalParameter();
            fpar.setName(fparName);
            fpar.setTypeRef((TypeRef)TypeUtils.copyIfContained(TypeRefsFactory.eINSTANCE.createUnknownTypeRef()));
            ph.setFpar(fpar);
        }
        return ph;
    }

    public static TypeRef wrapTypeInTypeRef(BuiltInTypeScope builtinTypeScope, Type type, TypeArgument ... typeArgs) {
        if (type instanceof TStructuralType) {
            return TypeUtils.createParameterizedTypeRefStructural((Type)builtinTypeScope.getObjectType(), TypingStrategy.STRUCTURAL, (TStructuralType)type);
        }
        return TypeUtils.wrapTypeInTypeRef(type, typeArgs);
    }

    public static TypeRef wrapTypeInTypeRef(Type type, TypeArgument ... typeArgs) {
        if (type == null) {
            return null;
        }
        if (type instanceof TEnum) {
            return TypeUtils.createTypeTypeRef(type, false);
        }
        if (type instanceof TEnumLiteral) {
            return TypeUtils.createTypeTypeRef((Type)((TEnum)type.eContainer()), false);
        }
        if (type instanceof TClass) {
            TClass declaredTypeCasted = (TClass)type;
            if (declaredTypeCasted.isAbstract()) {
                return TypeUtils.createTypeTypeRef((TypeArgument)TypeUtils.createTypeRef((Type)declaredTypeCasted, typeArgs), false);
            }
            return TypeUtils.createConstructorTypeRef((Type)declaredTypeCasted, typeArgs);
        }
        if (type instanceof TInterface) {
            return TypeUtils.createTypeTypeRef((TypeArgument)TypeUtils.createTypeRef(type, typeArgs), false);
        }
        if (type instanceof TObjectPrototype) {
            return TypeUtils.createConstructorTypeRef(type, typeArgs);
        }
        return TypeUtils.createTypeRef(type, typeArgs);
    }

    public static ParameterizedTypeRef createTypeRef(Type declaredType, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef(declaredType, TypingStrategy.DEFAULT, typeArgs);
    }

    public static ParameterizedTypeRef createTypeRef(Type declaredType, TypingStrategy typingStrategy, TypeArgument ... typeArgs) {
        return TypeUtils.createTypeRef(declaredType, typingStrategy, false, typeArgs);
    }

    public static ParameterizedTypeRef createTypeRef(Type declaredType, TypingStrategy typingStrategy, boolean autoCreateTypeArgs, TypeArgument ... typeArgs) {
        if (declaredType == null) {
            return null;
        }
        Object ref = declaredType instanceof TFunction ? TypeRefsFactory.eINSTANCE.createFunctionTypeRef() : (typingStrategy != TypingStrategy.DEFAULT && typingStrategy != TypingStrategy.NOMINAL ? TypeRefsFactory.eINSTANCE.createParameterizedTypeRefStructural() : TypeRefsFactory.eINSTANCE.createParameterizedTypeRef());
        ref.setDefinedTypingStrategy(typingStrategy);
        ref.setDeclaredType(declaredType);
        EList refTypeArgs = ref.getTypeArgs();
        TypeArgument[] typeArgumentArray = typeArgs;
        int n = typeArgs.length;
        int n2 = 0;
        while (n2 < n) {
            TypeArgument typeArg = typeArgumentArray[n2];
            refTypeArgs.add((Object)TypeUtils.copyIfContained(typeArg));
            ++n2;
        }
        if (autoCreateTypeArgs) {
            int l = declaredType.getTypeVars().size();
            int i = refTypeArgs.size();
            while (i < l) {
                refTypeArgs.add((Object)TypeUtils.createWildcard());
                ++i;
            }
        }
        return ref;
    }

    public static ParameterizedTypeRefStructural createParameterizedTypeRefStructural(Type declaredType, TypingStrategy typingStrategy, TStructuralType structuralType) {
        ParameterizedTypeRefStructural ref = TypeRefsFactory.eINSTANCE.createParameterizedTypeRefStructural();
        ref.setDeclaredType(declaredType);
        ref.setDefinedTypingStrategy(typingStrategy);
        ref.setStructuralType(structuralType);
        return ref;
    }

    public static ParameterizedTypeRefStructural createParameterizedTypeRefStructural(Type declaredType, TypingStrategy typingStrategy, TStructMember ... members) {
        ParameterizedTypeRefStructural ref = TypeRefsFactory.eINSTANCE.createParameterizedTypeRefStructural();
        ref.setDeclaredType(declaredType);
        ref.setDefinedTypingStrategy(typingStrategy);
        ref.getGenStructuralMembers().addAll(java.util.Arrays.asList(members));
        return ref;
    }

    public static TypeTypeRef createTypeTypeRef(Type type, boolean isConstructorRef) {
        TypeTypeRef typeTypeRef = TypeRefsFactory.eINSTANCE.createTypeTypeRef();
        typeTypeRef.setTypeArg((TypeArgument)TypeUtils.createTypeRef(type, new TypeArgument[0]));
        typeTypeRef.setConstructorRef(isConstructorRef);
        return typeTypeRef;
    }

    public static TypeTypeRef createTypeTypeRef(TypeArgument typeArg, boolean isConstructorRef) {
        TypeTypeRef typeTypeRef = TypeRefsFactory.eINSTANCE.createTypeTypeRef();
        typeTypeRef.setTypeArg(typeArg);
        typeTypeRef.setConstructorRef(isConstructorRef);
        return typeTypeRef;
    }

    public static TypeRef createConstructorTypeRef(Type declaredType, TypeArgument ... typeArgs) {
        TypeTypeRef typeRef = null;
        if (declaredType instanceof TFunction) {
            FunctionTypeRef ref = TypeRefsFactory.eINSTANCE.createFunctionTypeRef();
            ref.setDeclaredType(declaredType);
            TypeArgument[] typeArgumentArray = typeArgs;
            int n = typeArgs.length;
            int n2 = 0;
            while (n2 < n) {
                TypeArgument typeArg = typeArgumentArray[n2];
                ref.getTypeArgs().add((Object)TypeUtils.copyIfContained(typeArg));
                ++n2;
            }
            typeRef = ref;
        } else if (declaredType instanceof TClassifier) {
            TClassifier tClassifier = (TClassifier)declaredType;
            typeRef = TypeUtils.createTypeTypeRef((TypeArgument)TypeUtils.createTypeRef((Type)tClassifier, typeArgs), true);
        } else if (declaredType instanceof TypeVariable) {
            TypeVariable tTypeVar = (TypeVariable)declaredType;
            typeRef = TypeUtils.createTypeTypeRef((TypeArgument)TypeUtils.createTypeRef((Type)tTypeVar, new TypeArgument[0]), true);
        }
        return typeRef;
    }

    public static UnionTypeExpression createNonSimplifiedUnionType(Iterable<? extends TypeRef> elements) {
        UnionTypeExpression unionType = TypeRefsFactory.eINSTANCE.createUnionTypeExpression();
        EList unionElements = unionType.getTypeRefs();
        for (TypeRef typeRef : elements) {
            unionElements.add((Object)TypeUtils.copyIfContained(typeRef));
        }
        return unionType;
    }

    public static UnionTypeExpression createNonSimplifiedUnionType(TypeRef ... elements) {
        return TypeUtils.createNonSimplifiedUnionType(java.util.Arrays.asList(elements));
    }

    public static IntersectionTypeExpression createNonSimplifiedIntersectionType(Iterable<? extends TypeRef> elements) {
        IntersectionTypeExpression intersectionType = TypeRefsFactory.eINSTANCE.createIntersectionTypeExpression();
        EList intersectionElements = intersectionType.getTypeRefs();
        for (TypeRef typeRef : elements) {
            intersectionElements.add((Object)TypeUtils.copyIfContained(typeRef));
        }
        return intersectionType;
    }

    public static IntersectionTypeExpression createNonSimplifiedIntersectionType(TypeRef ... elements) {
        return TypeUtils.createNonSimplifiedIntersectionType(java.util.Arrays.asList(elements));
    }

    public static ExistentialTypeRef createExistentialTypeRef(TypeVariable typeVar, Wildcard wildcard) {
        ExistentialTypeRef etr = TypeRefsFactory.eINSTANCE.createExistentialTypeRef();
        etr.setWildcard(wildcard);
        etr.setBoundTypeVariable(typeVar);
        return etr;
    }

    public static Wildcard createWildcard() {
        return TypeRefsFactory.eINSTANCE.createWildcard();
    }

    public static Wildcard createWildcardExtends(TypeRef upperBound) {
        Wildcard wc = TypeUtils.createWildcard();
        wc.setDeclaredUpperBound(upperBound);
        return wc;
    }

    public static Wildcard createWildcardSuper(TypeRef lowerBound) {
        Wildcard wc = TypeUtils.createWildcard();
        wc.setDeclaredLowerBound(lowerBound);
        return wc;
    }

    public static TypeRef captureWildcard(TypeVariable typeVar, TypeArgument typeArg) {
        if (typeArg instanceof Wildcard) {
            return TypeUtils.createExistentialTypeRef(typeVar, (Wildcard)typeArg);
        }
        return (TypeRef)typeArg;
    }

    public static BoundThisTypeRef createBoundThisTypeRef(ParameterizedTypeRef actualThisTypeRef) {
        if (actualThisTypeRef == null) {
            throw new NullPointerException("Actual this type must not be null!");
        }
        BoundThisTypeRef boundThisTypeRef = TypeRefsFactory.eINSTANCE.createBoundThisTypeRef();
        ParameterizedTypeRef clonedActualThisType = TypeUtils.copy(actualThisTypeRef);
        boundThisTypeRef.setActualThisTypeRef(clonedActualThisType);
        boundThisTypeRef.setDefinedTypingStrategy(TypingStrategy.NOMINAL);
        if (actualThisTypeRef instanceof ParameterizedTypeRefStructural) {
            TypeUtils.copyStructuralTypingInfo((StructuralTypeRef)boundThisTypeRef, (StructuralTypeRef)((ParameterizedTypeRefStructural)actualThisTypeRef));
            ((ParameterizedTypeRefStructural)clonedActualThisType).getAstStructuralMembers().clear();
            ((ParameterizedTypeRefStructural)clonedActualThisType).getGenStructuralMembers().clear();
            ((ParameterizedTypeRefStructural)clonedActualThisType).setStructuralType(null);
            ((ParameterizedTypeRefStructural)clonedActualThisType).setDefinedTypingStrategy(TypingStrategy.NOMINAL);
        }
        return boundThisTypeRef;
    }

    public static BoundThisTypeRef createBoundThisTypeRefStructural(ParameterizedTypeRef actualThisTypeRef, ThisTypeRefStructural thisTypeStructural) {
        if (actualThisTypeRef == null) {
            throw new NullPointerException("Actual this type must not be null!");
        }
        BoundThisTypeRef boundThisTypeRef = TypeRefsFactory.eINSTANCE.createBoundThisTypeRef();
        boundThisTypeRef.setActualThisTypeRef(TypeUtils.copyIfContained(actualThisTypeRef));
        TypeUtils.copyStructuralTypingInfo((StructuralTypeRef)boundThisTypeRef, (StructuralTypeRef)thisTypeStructural);
        return boundThisTypeRef;
    }

    public static TypeTypeRef createClassifierBoundThisTypeRef(TypeTypeRef actualThisTypeRef) {
        BoundThisTypeRef boundThisTypeRef;
        if (actualThisTypeRef == null) {
            throw new NullPointerException("Actual this type must not be null!");
        }
        TypeArgument typeArg = actualThisTypeRef.getTypeArg();
        if (typeArg instanceof ParameterizedTypeRef) {
            boundThisTypeRef = TypeUtils.createBoundThisTypeRef((ParameterizedTypeRef)typeArg);
        } else if (typeArg instanceof BoundThisTypeRef) {
            boundThisTypeRef = (BoundThisTypeRef)typeArg;
        } else {
            throw new IllegalArgumentException("Cannot turn unbound type{this} into type{this[X]}, must be called with type{X}!");
        }
        TypeTypeRef classifierBoundThisTypeRef = TypeUtils.createTypeTypeRef((TypeArgument)boundThisTypeRef, false);
        return classifierBoundThisTypeRef;
    }

    public static ParameterizedTypeRef createResolvedThisTypeRef(BoundThisTypeRef boundThisTypeRef) {
        if (boundThisTypeRef == null) {
            throw new NullPointerException("Bound this type must not be null!");
        }
        if (boundThisTypeRef.getActualThisTypeRef() == null) {
            throw new NullPointerException("Actual this type of the provided bound this type must not be null!");
        }
        EList targsAsList = boundThisTypeRef.getActualThisTypeRef().getTypeArgs();
        TypeArgument[] targs = targsAsList.toArray(new TypeArgument[targsAsList.size()]);
        ParameterizedTypeRef resolvedTypeRef = TypeUtils.createTypeRef(boundThisTypeRef.getActualThisTypeRef().getDeclaredType(), boundThisTypeRef.getTypingStrategy(), targs);
        if (resolvedTypeRef instanceof ParameterizedTypeRefStructural) {
            TypeUtils.copyStructuralTypingInfo((StructuralTypeRef)((ParameterizedTypeRefStructural)resolvedTypeRef), (StructuralTypeRef)boundThisTypeRef);
        }
        TypeUtils.copyTypeModifiers((TypeRef)resolvedTypeRef, (TypeRef)boundThisTypeRef);
        return resolvedTypeRef;
    }

    public static TypeRef enforceNominalTyping(TypeRef rawT) {
        if (rawT.getTypingStrategy() == TypingStrategy.NOMINAL || rawT.isUseSiteStructuralTyping()) {
            return rawT;
        }
        TypeRef T = TypeUtils.copy(rawT);
        if (T instanceof StructuralTypeRef) {
            ((StructuralTypeRef)T).setTypingStrategy(TypingStrategy.NOMINAL);
        } else if (T instanceof ParameterizedTypeRef) {
            ((ParameterizedTypeRef)T).setDefinedTypingStrategy(TypingStrategy.NOMINAL);
        }
        return T;
    }

    public static TypeArgument mergeTypeModifiers(TypeArgument target, TypeRef source) {
        if (target instanceof Wildcard) {
            return TypeUtils.mergeTypeModifiers((Wildcard)target, source);
        }
        return TypeUtils.mergeTypeModifiers((TypeRef)target, source);
    }

    public static Wildcard mergeTypeModifiers(Wildcard target, TypeRef source) {
        TypeRef ubMerged;
        TypeRef ub = target.getDeclaredOrImplicitUpperBound();
        if (ub != null && (ubMerged = TypeUtils.mergeTypeModifiers(ub, source)) != ub) {
            target = TypeUtils.copyPartial(target, TypeRefsPackage.eINSTANCE.getWildcard_DeclaredUpperBound());
            target.setDeclaredUpperBound(ubMerged);
        }
        return target;
    }

    public static TypeRef mergeTypeModifiers(TypeRef target, TypeRef source) {
        if (target instanceof ExistentialTypeRef) {
            Wildcard wcMerged;
            Wildcard wc = ((ExistentialTypeRef)target).getWildcard();
            if (wc != null && (wcMerged = TypeUtils.mergeTypeModifiers(wc, source)) != wc) {
                target = TypeUtils.copyPartial(target, TypeRefsPackage.eINSTANCE.getWildcard_DeclaredUpperBound());
                ((ExistentialTypeRef)target).setWildcard(wcMerged);
            }
            return target;
        }
        TypeRef result = target;
        result = TypeUtils.mergeTypingStrategies(result, source.getTypingStrategy());
        result = TypeUtils.mergeDynamicModifiers(result, source.isDynamic(), result != target);
        return result;
    }

    private static TypeRef mergeTypingStrategies(TypeRef target, TypingStrategy source) {
        TypingStrategy combined = TypeUtils.concatTypingStrategies(target.getTypingStrategy(), source);
        if (combined != target.getTypingStrategy() && target instanceof ParameterizedTypeRef && !(target instanceof FunctionTypeRef)) {
            ParameterizedTypeRefStructural ptrs = TypeUtils.copyToParameterizedTypeRefStructural((ParameterizedTypeRef)target);
            ptrs.setTypingStrategy(combined);
            target = ptrs;
        }
        return target;
    }

    private static TypeRef mergeDynamicModifiers(TypeRef target, boolean source, boolean targetAlreadyCopied) {
        boolean combined;
        boolean bl = combined = target.isDynamic() || source;
        if (combined != target.isDynamic() && target instanceof BaseTypeRef) {
            if (!targetAlreadyCopied) {
                target = TypeUtils.copy(target);
            }
            ((BaseTypeRef)target).setDynamic(combined);
        }
        return target;
    }

    public static TypingStrategy concatTypingStrategies(TypingStrategy first, TypingStrategy second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        switch (first) {
            case DEFAULT: 
            case NOMINAL: {
                return second;
            }
            case EMPTY: {
                return TypingStrategy.EMPTY;
            }
            case STRUCTURAL: {
                switch (second) {
                    case DEFAULT: {
                        return first;
                    }
                    case NOMINAL: {
                        return first;
                    }
                    case EMPTY: {
                        return TypingStrategy.EMPTY;
                    }
                    case STRUCTURAL: 
                    case STRUCTURAL_FIELDS: 
                    case STRUCTURAL_READ_ONLY_FIELDS: 
                    case STRUCTURAL_WRITE_ONLY_FIELDS: 
                    case STRUCTURAL_FIELD_INITIALIZER: {
                        return second;
                    }
                }
                break;
            }
            case STRUCTURAL_FIELDS: {
                switch (second) {
                    case DEFAULT: {
                        return first;
                    }
                    case NOMINAL: {
                        return first;
                    }
                    case EMPTY: {
                        return TypingStrategy.EMPTY;
                    }
                    case STRUCTURAL: {
                        return TypingStrategy.STRUCTURAL_FIELDS;
                    }
                    case STRUCTURAL_FIELDS: 
                    case STRUCTURAL_READ_ONLY_FIELDS: 
                    case STRUCTURAL_WRITE_ONLY_FIELDS: 
                    case STRUCTURAL_FIELD_INITIALIZER: {
                        return second;
                    }
                }
                break;
            }
            case STRUCTURAL_WRITE_ONLY_FIELDS: {
                switch (second) {
                    case DEFAULT: {
                        return first;
                    }
                    case NOMINAL: {
                        return first;
                    }
                    case EMPTY: {
                        return TypingStrategy.EMPTY;
                    }
                    case STRUCTURAL: 
                    case STRUCTURAL_FIELDS: 
                    case STRUCTURAL_WRITE_ONLY_FIELDS: {
                        return TypingStrategy.STRUCTURAL_WRITE_ONLY_FIELDS;
                    }
                    case STRUCTURAL_READ_ONLY_FIELDS: {
                        return TypingStrategy.EMPTY;
                    }
                    case STRUCTURAL_FIELD_INITIALIZER: {
                        return TypingStrategy.STRUCTURAL_FIELD_INITIALIZER;
                    }
                }
                break;
            }
            case STRUCTURAL_READ_ONLY_FIELDS: 
            case STRUCTURAL_FIELD_INITIALIZER: {
                switch (second) {
                    case DEFAULT: {
                        return first;
                    }
                    case NOMINAL: {
                        return first;
                    }
                    case EMPTY: {
                        return TypingStrategy.EMPTY;
                    }
                    case STRUCTURAL: 
                    case STRUCTURAL_FIELDS: 
                    case STRUCTURAL_READ_ONLY_FIELDS: {
                        return first;
                    }
                    case STRUCTURAL_WRITE_ONLY_FIELDS: 
                    case STRUCTURAL_FIELD_INITIALIZER: {
                        return TypingStrategy.EMPTY;
                    }
                }
            }
        }
        throw new UnsupportedOperationException("unsupported combination of typing strategies: first==" + first + ", second==" + second);
    }

    public static void copyStructuralTypingInfo(StructuralTypeRef dest, StructuralTypeRef src) {
        dest.setTypingStrategy(src.getTypingStrategy());
        dest.getAstStructuralMembers().clear();
        dest.setStructuralType(src.getStructuralType());
        dest.getGenStructuralMembers().clear();
        dest.getGenStructuralMembers().addAll(TypeUtils.copyAll(src.getGenStructuralMembers()));
    }

    public static void copyTypeModifiers(TypeRef target, TypeRef source) {
        if (target instanceof BaseTypeRef) {
            ((BaseTypeRef)target).setDynamic(target.isDynamic() || source.isDynamic());
        }
    }

    public static DeferredTypeRef createDeferredTypeRef() {
        return TypeRefsFactory.eINSTANCE.createDeferredTypeRef();
    }

    public static boolean containsDeferredTypeRefs(EObject object) {
        TreeIterator i = object.eAllContents();
        while (i.hasNext()) {
            Object local = i.next();
            if (!(local instanceof DeferredTypeRef)) continue;
            return true;
        }
        return false;
    }

    public static void assertNoDeferredTypeRefs(EObject object) {
        if (TypeUtils.containsDeferredTypeRefs(object)) {
            throw new IllegalStateException("found a DeferredTypeRef in " + object.eResource().getURI());
        }
    }

    public static FunctionTypeExpression createFunctionTypeExpression(TypeRef declaredThisType, List<TypeVariable> ownedTypeVars, List<TFormalParameter> fpars, TypeRef returnTypeRef) {
        FunctionTypeExpression f = TypeRefsFactory.eINSTANCE.createFunctionTypeExpression();
        if (declaredThisType != null) {
            f.setDeclaredThisType(TypeUtils.copyIfContained(declaredThisType));
        }
        ownedTypeVars.stream().forEachOrdered(tv -> {
            boolean bl = f.getOwnedTypeVars().add((Object)TypeUtils.copyIfContained(tv));
        });
        fpars.stream().forEachOrdered(tp -> {
            boolean bl = f.getFpars().add((Object)TypeUtils.copyIfContained(tp));
        });
        f.setReturnTypeRef(TypeUtils.copyIfContained(returnTypeRef));
        return f;
    }

    public static TypeVariableMapping createTypeVariableMapping(TypeVariable typeVar, TypeArgument typeArg) {
        TypeVariableMapping result = TypeRefsFactory.eINSTANCE.createTypeVariableMapping();
        result.setTypeVar(typeVar);
        result.setTypeArg(TypeUtils.copyIfContained(typeArg));
        return result;
    }

    public static TypeRef getRootTypeRef(TypeRef typeRef) {
        if (typeRef != null) {
            TypeRef nextOuter;
            while ((nextOuter = (TypeRef)EcoreUtil2.getContainerOfType((EObject)typeRef.eContainer(), TypeRef.class)) != null) {
                typeRef = nextOuter;
            }
        }
        return typeRef;
    }

    public static Iterable<? extends ParameterizedTypeRef> declaredSuperTypes(Type type) {
        TObjectPrototype tObjectPrototype;
        PrimitiveType assignmentCompatible;
        if (type instanceof TClass) {
            TClass c = (TClass)type;
            if (c.getSuperClassRef() != null) {
                return Iterables.concat(Collections.singletonList(c.getSuperClassRef()), (Iterable)c.getImplementedInterfaceRefs());
            }
            return c.getImplementedInterfaceRefs();
        }
        if (type instanceof TInterface) {
            TInterface r = (TInterface)type;
            return r.getSuperInterfaceRefs();
        }
        if (type instanceof PrimitiveType && (assignmentCompatible = ((PrimitiveType)type).getAssignmentCompatible()) != null) {
            ParameterizedTypeRef typeRef = TypeRefsFactory.eINSTANCE.createParameterizedTypeRef();
            typeRef.setDeclaredType((Type)assignmentCompatible);
            return Collections.singletonList(typeRef);
        }
        if (type instanceof TObjectPrototype && (tObjectPrototype = (TObjectPrototype)type).getSuperType() != null) {
            return Collections.singletonList(tObjectPrototype.getSuperType());
        }
        return Collections.emptyList();
    }

    public static boolean isRawSuperType(Type type, Type superTypeCandidate) {
        return TypeUtils.isRawSuperType(type, superTypeCandidate, (RecursionGuard<Type>)new RecursionGuard());
    }

    private static boolean isRawSuperType(Type type, Type superTypeCandidate, RecursionGuard<Type> guard) {
        if (type == superTypeCandidate) {
            return true;
        }
        if (type == null) {
            return false;
        }
        if (guard.tryNext((Object)type)) {
            PrimitiveType assignmentCompatible;
            if (type instanceof TClass) {
                TClass c = (TClass)type;
                if (TypeUtils.isRawSuperType((TypeRef)c.getSuperClassRef(), superTypeCandidate, guard)) {
                    return true;
                }
                return TypeUtils.isRawSuperType((Iterable<? extends TypeRef>)c.getImplementedInterfaceRefs(), superTypeCandidate, guard);
            }
            if (type instanceof TInterface) {
                TInterface r = (TInterface)type;
                return TypeUtils.isRawSuperType((Iterable<? extends TypeRef>)r.getSuperInterfaceRefs(), superTypeCandidate, guard);
            }
            if (type instanceof TypeVariable) {
                TypeVariable v = (TypeVariable)type;
                TypeRef ub = v.getDeclaredUpperBound();
                return ub != null && TypeUtils.isRawSuperType(ub, superTypeCandidate, guard);
            }
            if (type instanceof PrimitiveType && TypeUtils.isRawSuperType((Type)(assignmentCompatible = ((PrimitiveType)type).getAssignmentCompatible()), superTypeCandidate, guard)) {
                return true;
            }
        }
        return false;
    }

    private static boolean isRawSuperType(Iterable<? extends TypeRef> types, Type superTypeCandidate, RecursionGuard<Type> guard) {
        for (TypeRef typeRef : types) {
            if (!TypeUtils.isRawSuperType(typeRef, superTypeCandidate, guard)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRawSuperType(TypeRef type, Type superTypeCandidate, RecursionGuard<Type> guard) {
        if (type == null) {
            return false;
        }
        return TypeUtils.isRawSuperType(type.getDeclaredType(), superTypeCandidate, guard);
    }

    public static TypeRef resolveTypeVariable(TypeRef typeRef) {
        TypeRef ub;
        Type declType;
        Type type = declType = typeRef != null ? typeRef.getDeclaredType() : null;
        if (declType instanceof TypeVariable && (ub = ((TypeVariable)declType).getDeclaredUpperBound()) != null) {
            return ub;
        }
        return typeRef;
    }

    public static TypeRef getMemberTypeRef(TMember m) {
        if (m == null) {
            return null;
        }
        if (m instanceof TField) {
            return ((TField)m).getTypeRef();
        }
        if (m instanceof TGetter) {
            return ((TGetter)m).getDeclaredTypeRef();
        }
        if (m instanceof TSetter) {
            return ((TSetter)m).getDeclaredTypeRef();
        }
        if (m instanceof TMethod) {
            return ((TMethod)m).getReturnTypeRef();
        }
        throw new IllegalArgumentException("unknown sub-class of TMember: " + m.getClass().getName());
    }

    public static void setMemberTypeRef(TMember m, TypeRef typeRef) {
        typeRef = TypeUtils.copyIfContained(typeRef);
        if (m instanceof TField) {
            ((TField)m).setTypeRef(typeRef);
        } else if (m instanceof TGetter) {
            ((TGetter)m).setDeclaredTypeRef(typeRef);
        } else if (m instanceof TSetter) {
            TSetter s = (TSetter)m;
            if (s.getFpar() == null) {
                s.setFpar(TypesFactory.eINSTANCE.createTFormalParameter());
            }
            s.getFpar().setTypeRef(typeRef);
        } else if (m instanceof TMethod) {
            ((TMethod)m).setReturnTypeRef(typeRef);
        } else if (m != null) {
            throw new IllegalArgumentException("unknown sub-class of TMember: " + m.getClass().getName());
        }
    }

    public static boolean isInferenceVariable(TypeRef typeRef) {
        return typeRef != null && typeRef.getDeclaredType() instanceof InferenceVariable;
    }

    public static boolean isProper(TypeArgument typeRef) {
        return !TypeUtils.isOrContainsRefToInfVar((EObject)typeRef, new InferenceVariable[0]);
    }

    public static boolean isOrContainsType(TypeRef typeRef, Type declaredType) {
        if (typeRef == null) {
            return false;
        }
        if (typeRef instanceof ComposedTypeRef) {
            return ((ComposedTypeRef)typeRef).getTypeRefs().stream().anyMatch(element -> TypeUtils.isOrContainsType(element, declaredType));
        }
        if (typeRef.getDeclaredType() == null) {
            return false;
        }
        return typeRef.getDeclaredType() == declaredType;
    }

    public static boolean isOrContainsTypeRefOfType(TypeRef typeRef, Class<? extends TypeRef> typeOfTypeRef) {
        if (typeRef == null) {
            return false;
        }
        if (typeOfTypeRef.isInstance(typeRef)) {
            return true;
        }
        if (typeRef instanceof ComposedTypeRef) {
            return ((ComposedTypeRef)typeRef).getTypeRefs().stream().anyMatch(element -> TypeUtils.isOrContainsTypeRefOfType(element, typeOfTypeRef));
        }
        return false;
    }

    public static boolean isOrContainsRefToTypeVar(EObject obj, TypeVariable ... typeVars) {
        return TypeUtils.isOrContainsRefToTypeVar(obj, false, typeVars);
    }

    public static boolean isOrContainsRefToInfVar(EObject obj, InferenceVariable ... infVars) {
        return TypeUtils.isOrContainsRefToTypeVar(obj, true, (TypeVariable[])infVars);
    }

    private static boolean isOrContainsRefToTypeVar(EObject obj, boolean checkForInfVars, TypeVariable ... typeVars) {
        if (obj == null) {
            return false;
        }
        if (TypeUtils.isRefToTypeVar(obj, checkForInfVars, typeVars)) {
            return true;
        }
        TreeIterator iter = obj.eAllContents();
        while (iter.hasNext()) {
            if (!TypeUtils.isRefToTypeVar((EObject)iter.next(), checkForInfVars, typeVars)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRefToTypeVar(EObject obj, boolean checkForInfVars, TypeVariable ... typeVars) {
        Class expectedType;
        if (obj instanceof StructuralTypeRef && TypeUtils.isOrContainsRefToTypeVar((EObject)((StructuralTypeRef)obj).getStructuralType(), checkForInfVars, typeVars)) {
            return true;
        }
        Class clazz = expectedType = checkForInfVars ? InferenceVariable.class : TypeVariable.class;
        return obj instanceof TypeRef && expectedType.isInstance(((TypeRef)obj).getDeclaredType()) && (typeVars.length == 0 || Arrays.contains((Object[])typeVars, (Object)((TypeRef)obj).getDeclaredType()));
    }

    public static Set<TypeVariable> getReferencedTypeVars(EObject obj) {
        return TypeUtils.collectReferencedTypeVars(obj, true, new LinkedHashSet<TypeVariable>());
    }

    private static Set<TypeVariable> collectReferencedTypeVars(EObject obj, boolean includeChildren, Set<TypeVariable> addHere) {
        Type declType;
        Type type = declType = obj instanceof TypeRef ? ((TypeRef)obj).getDeclaredType() : null;
        if (declType instanceof TypeVariable) {
            addHere.add((TypeVariable)declType);
        }
        if (obj instanceof StructuralTypeRef) {
            for (TStructMember m : ((StructuralTypeRef)obj).getStructuralMembers()) {
                TypeUtils.collectReferencedTypeVars((EObject)m, true, addHere);
            }
        }
        if (includeChildren) {
            TreeIterator iter = obj.eAllContents();
            while (iter.hasNext()) {
                TypeUtils.collectReferencedTypeVars((EObject)iter.next(), false, addHere);
            }
        }
        return addHere;
    }

    public static boolean isAccessorPair(TMember member, TMember member2) {
        return member instanceof TGetter && member2 instanceof TSetter || member instanceof TSetter && member2 instanceof TGetter;
    }

    public static boolean mayOverrideOrImplementByMetaType(MemberType overrideCandidate, MemberType overriddenCandidate) {
        if (overriddenCandidate == overrideCandidate) {
            return true;
        }
        switch (overrideCandidate) {
            case FIELD: {
                return overriddenCandidate != MemberType.METHOD;
            }
            case GETTER: 
            case SETTER: {
                return overriddenCandidate == MemberType.FIELD;
            }
        }
        return false;
    }

    public static boolean isRawTypeRef(TypeRef typeRef) {
        if (typeRef instanceof ParameterizedTypeRef) {
            Type declType = typeRef.getDeclaredType();
            return declType != null && declType.getTypeVars().size() > typeRef.getTypeArgs().size();
        }
        return false;
    }

    public static void sanitizeRawTypeRef(TypeRef typeRef) {
        int n;
        Type type;
        if (typeRef instanceof ParameterizedTypeRef && (type = typeRef.getDeclaredType()) != null && (n = type.getTypeVars().size()) > 0) {
            EList l = typeRef.getTypeArgs();
            while (l.size() < n) {
                l.add(TypeRefsFactory.eINSTANCE.createWildcard());
            }
        }
    }

    public static Set<TypeVariable> getTypeVarsInStructMembers(StructuralTypeRef typeRef) {
        HashSet<TypeVariable> result = new HashSet<TypeVariable>();
        TypeUtils.primCollectTypeVarsInStructMembers(typeRef, result);
        return result;
    }

    private static void primCollectTypeVarsInStructMembers(StructuralTypeRef typeRef, Set<TypeVariable> addHere) {
        typeRef.getStructuralMembers().forEach(currM -> currM.eAllContents().forEachRemaining(currObj -> {
            if (currObj instanceof ParameterizedTypeRef && ((ParameterizedTypeRef)currObj).getDeclaredType() instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)((ParameterizedTypeRef)currObj).getDeclaredType();
                addHere.add(tv);
            }
            if (currObj instanceof StructuralTypeRef) {
                TypeUtils.primCollectTypeVarsInStructMembers((StructuralTypeRef)currObj, addHere);
            }
        }));
    }

    public static final <T extends EObject> T copy(T source) {
        return TypeUtils.copy(source, true, false, null, new EReference[0]);
    }

    public static final <T extends EObject> T copy(T source, EClass eclass) {
        return TypeUtils.copy(source, true, false, eclass, new EReference[0]);
    }

    public static final <T extends EObject> T copyIfContained(T source) {
        return TypeUtils.copy(source, true, true, null, new EReference[0]);
    }

    public static final <T extends EObject> T copyWithProxies(T source) {
        return TypeUtils.copy(source, false, false, null, new EReference[0]);
    }

    public static final ParameterizedTypeRefStructural copyToParameterizedTypeRefStructural(ParameterizedTypeRef source) {
        if (source instanceof FunctionTypeRef) {
            throw new IllegalArgumentException("FunctionTypeRefs do not have a corresponding structural variant");
        }
        EClass ptrsEClass = source instanceof VersionedParameterizedTypeRef ? TypeRefsPackage.eINSTANCE.getVersionedParameterizedTypeRefStructural() : TypeRefsPackage.eINSTANCE.getParameterizedTypeRefStructural();
        return (ParameterizedTypeRefStructural)TypeUtils.copy(source, false, false, ptrsEClass, new EReference[0]);
    }

    public static final <T extends EObject> T copyPartial(T source, EReference ... eRefsToIgnore) {
        return TypeUtils.copy(source, true, false, null, eRefsToIgnore);
    }

    private static final <T extends EObject> T copy(T source, boolean resolveProxies, boolean onlyIfContained, EClass eclass, EReference ... eRefsToIgnore) {
        if (source == null) {
            return null;
        }
        if (eclass != null && !source.eClass().isSuperTypeOf(eclass)) {
            return null;
        }
        if (onlyIfContained && source.eContainer() == null && source.eResource() == null) {
            return source;
        }
        TypeCopier copier = new TypeCopier(resolveProxies, eRefsToIgnore);
        copier.changeType(source, eclass);
        EObject result = copier.copy(source);
        copier.copyReferences();
        return (T)result;
    }

    public static <T> Collection<T> copyAll(Collection<? extends T> sources) {
        TypeCopier copier = new TypeCopier(true, new EReference[0]);
        Collection result = copier.copyAll(sources);
        copier.copyReferences();
        return result;
    }

    public static boolean isAny(TypeArgument typeArg) {
        return typeArg != null && typeArg.getDeclaredType() instanceof AnyType;
    }

    public static boolean isNull(TypeArgument typeArg) {
        return typeArg != null && typeArg.getDeclaredType() instanceof NullType;
    }

    public static boolean isUndefined(TypeArgument typeArg) {
        return typeArg != null && typeArg.getDeclaredType() instanceof UndefinedType;
    }

    public static boolean isVoid(TypeArgument typeArg) {
        return typeArg != null && typeArg.getDeclaredType() instanceof VoidType;
    }

    public static boolean isVoidReturnType(FunctionTypeExprOrRef funTypeRef) {
        if (funTypeRef instanceof FunctionTypeExpression && funTypeRef.getReturnTypeRef() == null) {
            return true;
        }
        return funTypeRef != null ? TypeUtils.isVoid((TypeArgument)funTypeRef.getReturnTypeRef()) : false;
    }

    public static boolean isPromise(TypeRef ref, BuiltInTypeScope scope) {
        if (ref instanceof ParameterizedTypeRef) {
            return ref.getDeclaredType() == scope.getPromiseType();
        }
        return false;
    }

    public static boolean isGenerator(TypeRef ref, BuiltInTypeScope scope) {
        if (ref instanceof ParameterizedTypeRef) {
            return ref.getDeclaredType() == scope.getGeneratorType();
        }
        return false;
    }

    public static ParameterizedTypeRef createPromiseTypeRef(BuiltInTypeScope scope, TypeArgument successType, TypeArgument failureTypeOrNull) {
        Objects.requireNonNull(successType);
        ParameterizedTypeRef successTypeArg = TypeUtils.isVoid(successType) ? scope.getUndefinedTypeRef() : TypeUtils.copyWithProxies(successType);
        Wildcard failureTypeArg = failureTypeOrNull != null ? TypeUtils.copyWithProxies(failureTypeOrNull) : TypeRefsFactory.eINSTANCE.createWildcard();
        return TypeUtils.createTypeRef((Type)scope.getPromiseType(), new TypeArgument[]{successTypeArg, failureTypeArg});
    }

    public static ParameterizedTypeRef createGeneratorTypeRef(BuiltInTypeScope scope, FunctionDefinition funDef) {
        TypeRef tYield;
        Objects.requireNonNull(scope);
        Objects.requireNonNull(funDef);
        TypeRef definedReturn = funDef.getReturnTypeRef();
        TypeRef tReturn = TypeUtils.inferReturnTypeFromReturns(funDef, scope);
        if (definedReturn == null) {
            tYield = TypeUtils.inferYieldExprTypeFromYields(funDef, scope);
        } else {
            tYield = definedReturn;
            if (TypeUtils.isVoid((TypeArgument)definedReturn)) {
                tReturn = scope.getUndefinedTypeRef();
            }
        }
        ParameterizedTypeRef generatorTypeRef = TypeUtils.createGeneratorTypeRef(scope, (TypeArgument)tYield, (TypeArgument)tReturn, null);
        return generatorTypeRef;
    }

    public static ParameterizedTypeRef createGeneratorTypeRef(BuiltInTypeScope scope, TypeArgument tYield, TypeArgument tReturn, TypeArgument tNext) {
        tYield = TypeUtils.isVoid(tYield) ? scope.getUndefinedTypeRef() : TypeUtils.copyWithProxies(tYield);
        tReturn = TypeUtils.isVoid(tReturn) ? scope.getUndefinedTypeRef() : TypeUtils.copyWithProxies(tReturn);
        tNext = tNext == null ? scope.getAnyTypeRef() : TypeUtils.copyWithProxies(tNext);
        ParameterizedTypeRef generatorTypeRef = TypeUtils.createTypeRef((Type)scope.getGeneratorType(), tYield, tReturn, tNext);
        return generatorTypeRef;
    }

    private static TypeRef inferYieldExprTypeFromYields(FunctionDefinition funDef, BuiltInTypeScope scope) {
        boolean hasNonVoidReturn;
        boolean bl = hasNonVoidReturn = funDef.getBody() != null && funDef.getBody().hasNonVoidYield();
        if (hasNonVoidReturn) {
            return scope.getAnyTypeRef();
        }
        return scope.getVoidTypeRef();
    }

    private static TypeRef inferReturnTypeFromReturns(FunctionDefinition funDef, BuiltInTypeScope scope) {
        boolean hasNonVoidReturn;
        boolean bl = hasNonVoidReturn = funDef.getBody() != null && funDef.getBody().hasNonVoidReturn();
        if (hasNonVoidReturn) {
            return scope.getAnyTypeRef();
        }
        return scope.getVoidTypeRef();
    }

    public static boolean isOrContainsThisType(TypeRef typeRef) {
        return TypeUtils.isOrContainsTypeRefOfType(typeRef, ThisTypeRef.class);
    }

    public static boolean isBuiltIn(Type type) {
        return N4Scheme.isFromResourceWithN4Scheme((EObject)type);
    }

    public static TypingStrategy retrieveTypingStrategy(TypeRef typeRef) {
        if (typeRef != null && !typeRef.eIsProxy()) {
            return typeRef.getTypingStrategy();
        }
        return TypingStrategy.DEFAULT;
    }

    public static TypeRef wrapIfVariadic(BuiltInTypeScope scope, TypeRef typeRef, FormalParameter fpar) {
        if (typeRef != null && fpar.isVariadic()) {
            return TypeUtils.createTypeRef((Type)scope.getArrayType(), new TypeArgument[]{typeRef});
        }
        return typeRef;
    }

    private static final class TypeCopier
    extends EcoreUtil.Copier {
        private static final EReference eRef_StructuralTypeRef_astStructuralMembers = TypeRefsPackage.eINSTANCE.getStructuralTypeRef_AstStructuralMembers();
        private static final EReference eRef_Wildcard_declaredUpperBound = TypeRefsPackage.eINSTANCE.getWildcard_DeclaredUpperBound();
        private final EReference[] eRefsToIgnore;
        private final Map<EObject, EClass> changeTypeMap = new HashMap<EObject, EClass>();

        public TypeCopier(boolean resolveProxies, EReference ... eRefsToIgnore) {
            super(resolveProxies);
            this.eRefsToIgnore = eRefsToIgnore;
        }

        void changeType(EObject eObject, EClass eClass) {
            if (eObject == null || eClass == null) {
                return;
            }
            this.changeTypeMap.put(eObject, eClass);
        }

        protected void copyContainment(EReference eReference, EObject eObject, EObject copyEObject) {
            if (Arrays.contains((Object[])this.eRefsToIgnore, (Object)eReference)) {
                return;
            }
            if (eReference == eRef_StructuralTypeRef_astStructuralMembers) {
                return;
            }
            if (eReference == eRef_Wildcard_declaredUpperBound) {
                Wildcard wOrig = (Wildcard)eObject;
                Wildcard wCopy = (Wildcard)copyEObject;
                if (wOrig.isImplicitUpperBoundInEffect()) {
                    boolean needToMakeImplicitUpperBoundExplicit;
                    EObject parent = wOrig.eContainer();
                    boolean parentIsBeingCopiedAsWell = parent != null && this.containsKey(parent);
                    boolean bl = needToMakeImplicitUpperBoundExplicit = !parentIsBeingCopiedAsWell;
                    if (needToMakeImplicitUpperBoundExplicit) {
                        wCopy.setDeclaredUpperBound(TypeUtils.copyWithProxies(wOrig.getDeclaredOrImplicitUpperBound()));
                        return;
                    }
                }
            }
            super.copyContainment(eReference, eObject, copyEObject);
        }

        protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
            if (Arrays.contains((Object[])this.eRefsToIgnore, (Object)eReference)) {
                return;
            }
            super.copyReference(eReference, eObject, copyEObject);
        }

        protected EClass getTarget(EObject eObject) {
            if (this.changeTypeMap.containsKey(eObject)) {
                return this.changeTypeMap.get(eObject);
            }
            return super.getTarget(eObject);
        }
    }
}

