/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.smith.ui.graph;

import org.eclipse.n4js.smith.ui.graph.Point;

public class Rectangle {
    public static final Rectangle EMPTY = new Rectangle(0.0f, 0.0f, 0.0f, 0.0f);
    public final float x;
    public final float y;
    public final float width;
    public final float height;

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Point getCenter() {
        return new Point(this.x + this.width / 2.0f, this.y + this.height / 2.0f);
    }

    public boolean isEmpty() {
        return this.width <= 0.0f || this.height <= 0.0f;
    }

    public boolean contains(float x, float y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public Point getIntersectionLocation(Point reference) {
        Rectangle r = new Rectangle(this.x, this.y, this.width, this.height);
        float centerX = r.x + 0.5f * r.width;
        float centerY = r.y + 0.5f * r.height;
        if (r.isEmpty() || reference.x == (float)((int)centerX) && reference.y == (float)((int)centerY)) {
            return new Point(centerX, centerY);
        }
        float dx = reference.x - centerX;
        float dy = reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / r.width, Math.abs(dy) / r.height);
        return new Point(centerX += (dx *= scale), centerY += (dy *= scale));
    }
}

