/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner;

import com.google.common.base.Preconditions;

public enum SystemLoaderInfo {
    SYSTEM_JS("systemjs", "System.js"),
    COMMON_JS("cjs", "Common JS");

    private final String id;
    private final String label;

    private SystemLoaderInfo(String id, String label) {
        this.id = (String)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.label = (String)Preconditions.checkNotNull((Object)label, (Object)"label");
    }

    public static SystemLoaderInfo fromString(String loader) {
        String trimmed;
        if (loader == null) {
            return null;
        }
        switch (trimmed = loader.trim().toLowerCase()) {
            case "commonjs": 
            case "cjs": {
                return COMMON_JS;
            }
            case "systemjs": {
                return SYSTEM_JS;
            }
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.label;
    }
}

