/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec;

import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.jsdoc2spec.IJSDoc2SpecIssueAcceptor;
import org.eclipse.n4js.jsdoc2spec.JSDoc2SpecAcceptor;
import org.eclipse.n4js.jsdoc2spec.N4JSDReader;
import org.eclipse.n4js.jsdoc2spec.SpecFile;
import org.eclipse.n4js.jsdoc2spec.SpecInfo;
import org.eclipse.n4js.jsdoc2spec.SubMonitorMsg;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.utils.ContainerTypesHelper;

public abstract class JSDoc2SpecProcessor {
    @Inject
    N4JSDReader n4jsdReader;
    @Inject
    protected ContainerTypesHelper containerTypesHelper;
    protected final IJSDoc2SpecIssueAcceptor issueAcceptor = new JSDoc2SpecAcceptor();

    public abstract void setRootDir(File var1);

    public abstract Collection<SpecFile> computeUpdates(Collection<SpecInfo> var1, SubMonitorMsg var2) throws IOException, InterruptedException;

    public Collection<SpecFile> convert(File docRoot, Collection<IN4JSProject> projects, Function<IN4JSProject, ResourceSet> resSetProvider, SubMonitorMsg monitor) throws IOException, InterruptedException {
        this.setRootDir(docRoot);
        SubMonitorMsg sub = monitor.convert(400);
        Collection<SpecInfo> specInfos = this.readN4JSDs(projects, resSetProvider, sub.newChild(200));
        Collection<SpecFile> specChangeSet = this.computeUpdates(specInfos, sub.newChild(100));
        return specChangeSet;
    }

    public String getWarnings() {
        return this.issueAcceptor.warnings();
    }

    public void resetIssues() {
        this.issueAcceptor.reset();
    }

    public Collection<SpecInfo> readN4JSDs(Collection<IN4JSProject> projects, Function<IN4JSProject, ResourceSet> resSetProvider, SubMonitorMsg monitor) throws InterruptedException {
        SubMonitorMsg sub = monitor.convert(100 * (projects.size() + 2));
        this.n4jsdReader.issueAcceptor = this.issueAcceptor;
        return this.n4jsdReader.readN4JSDs(projects, resSetProvider, sub);
    }
}

