/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.text;

import org.eclipse.xpect.text.IRegion;
import org.eclipse.xpect.text.RegionToString;

public class Region
implements IRegion {
    private final CharSequence document;
    private final int length;
    private final int offset;

    public Region(CharSequence document, int offset, int length) {
        this.offset = offset;
        this.length = length;
        this.document = document;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Region other = (Region)obj;
        return this.length == other.length && this.offset == other.offset;
    }

    @Override
    public CharSequence getDocument() {
        return this.document;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getRegionText() {
        if (this.offset >= 0 && this.length >= 0) {
            int endIndex = this.offset + this.length;
            String result = this.document.subSequence(this.offset, endIndex).toString();
            return result;
        }
        return null;
    }

    public int hashCode() {
        return this.length + this.offset * 13;
    }

    public String toString() {
        return new RegionToString().with(this).toString();
    }
}

