/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class RequiredPluginsContainerPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IClasspathEntry entry;
    private TableViewer viewer;
    private Image projectImage;
    private Image libraryImage;
    private Image slibraryImage;
    private IClasspathEntry[] realEntries;
    private IJavaProject javaProject;

    public RequiredPluginsContainerPage() {
        super("requiredPluginsContainerPage");
        this.setTitle(PDEUIMessages.RequiredPluginsContainerPage_title);
        this.setDescription(PDEUIMessages.RequiredPluginsContainerPage_desc);
        this.projectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.libraryImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_l_obj.gif");
        this.slibraryImage = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jar_lsrc_obj.gif");
        this.setImageDescriptor(PDEPluginImages.DESC_CONVJPPRJ_WIZ);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        Label label = new Label(container, 0);
        label.setText(PDEUIMessages.RequiredPluginsContainerPage_label);
        this.viewer = new TableViewer(container, 2816);
        this.viewer.setContentProvider((IContentProvider)new EntryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EntryLabelProvider());
        this.viewer.setComparator(new ViewerComparator());
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        this.viewer.getTable().setLayoutData((Object)gd);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.plugins_container_page");
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        if (this.realEntries != null) {
            this.initializeView();
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.required_plugins_container_page");
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.entry;
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.javaProject = project;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.entry = containerEntry;
        this.createRealEntries();
        if (this.viewer != null) {
            this.initializeView();
        }
    }

    private void createRealEntries() {
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject == null) {
            this.realEntries = new IClasspathEntry[0];
            return;
        }
        if (this.entry == null) {
            this.entry = ClasspathComputer.createContainerEntry();
            IPluginModelBase model = PluginRegistry.findModel((IProject)javaProject.getProject());
            if (model != null) {
                RequiredPluginsClasspathContainer container = new RequiredPluginsClasspathContainer(model);
                this.realEntries = container.getClasspathEntries();
            }
        } else {
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)this.entry.getPath(), (IJavaProject)javaProject);
                if (container != null) {
                    this.realEntries = container.getClasspathEntries();
                }
            }
            catch (JavaModelException javaModelException) {}
        }
        if (this.realEntries == null) {
            this.realEntries = new IClasspathEntry[0];
        }
    }

    private IJavaProject getJavaProject() {
        return this.javaProject;
    }

    private void initializeView() {
        this.viewer.setInput((Object)this.entry);
    }

    class EntryContentProvider
    implements IStructuredContentProvider {
        EntryContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (RequiredPluginsContainerPage.this.realEntries != null) {
                return RequiredPluginsContainerPage.this.realEntries;
            }
            return new Object[0];
        }
    }

    class EntryLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        EntryLabelProvider() {
        }

        public String getText(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            int kind = entry.getEntryKind();
            if (kind == 2) {
                return entry.getPath().segment(0);
            }
            IPath path = entry.getPath();
            String name = path.lastSegment();
            return String.valueOf(name) + " - " + path.uptoSegment(path.segmentCount() - 1).toOSString();
        }

        public Image getImage(Object obj) {
            IClasspathEntry entry = (IClasspathEntry)obj;
            int kind = entry.getEntryKind();
            if (kind == 2) {
                return RequiredPluginsContainerPage.this.projectImage;
            }
            if (kind == 1) {
                IPath sourceAtt = entry.getSourceAttachmentPath();
                return sourceAtt != null ? RequiredPluginsContainerPage.this.slibraryImage : RequiredPluginsContainerPage.this.libraryImage;
            }
            return null;
        }

        public String getColumnText(Object obj, int col) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int col) {
            return this.getImage(obj);
        }
    }
}

