/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.swt.graphics.Image;

public class CommitLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider {
    private GitDateFormatter dateFormatter;
    private boolean showEmail;
    private RevCommit lastCommit;
    private PersonIdent lastAuthor;
    private PersonIdent lastCommitter;
    private IPropertyChangeListener uiPrefsListener;
    private final IPreferenceStore store = Activator.getDefault().getPreferenceStore();

    public CommitLabelProvider() {
        this(true);
    }

    public CommitLabelProvider(final boolean canShowEmailAddresses) {
        this.uiPrefsListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (("date_format".equals(property) || "date_format_choice".equals(property)) && CommitLabelProvider.this.dateFormatter instanceof PreferenceBasedDateFormatter) {
                    CommitLabelProvider.this.setDateFormatter(PreferenceBasedDateFormatter.create());
                } else if ("resourcehistory_show_relative_date".equals(property)) {
                    CommitLabelProvider.this.setRelativeDate(CommitLabelProvider.this.store.getBoolean("resourcehistory_show_relative_date"));
                } else if (canShowEmailAddresses && "resourcehistory_show_email_addresses".equals(property)) {
                    CommitLabelProvider.this.setShowEmailAddresses(CommitLabelProvider.this.store.getBoolean("resourcehistory_show_email_addresses"));
                }
            }
        };
        if (this.store.getBoolean("resourcehistory_show_relative_date")) {
            this.dateFormatter = new GitDateFormatter(GitDateFormatter.Format.RELATIVE);
        }
        this.showEmail = canShowEmailAddresses && this.store.getBoolean("resourcehistory_show_email_addresses");
        this.store.addPropertyChangeListener(this.uiPrefsListener);
    }

    public void dispose() {
        this.store.removePropertyChangeListener(this.uiPrefsListener);
        super.dispose();
    }

    public String getColumnText(Object element, int columnIndex) {
        PersonIdent committer;
        PersonIdent author;
        RevCommit c = (RevCommit)element;
        if (columnIndex == 0) {
            return c.getId().abbreviate(7).name();
        }
        if (columnIndex == 1) {
            return c.getShortMessage();
        }
        if ((columnIndex == 2 || columnIndex == 3) && (author = this.authorOf(c)) != null) {
            switch (columnIndex) {
                case 2: {
                    if (this.showEmail) {
                        return String.valueOf(author.getName()) + " <" + author.getEmailAddress() + '>';
                    }
                    return author.getName();
                }
                case 3: {
                    return this.getDateFormatter().formatDate(author);
                }
            }
        }
        if ((columnIndex == 4 || columnIndex == 5) && (committer = this.committerOf(c)) != null) {
            switch (columnIndex) {
                case 4: {
                    if (this.showEmail) {
                        return String.valueOf(committer.getName()) + " <" + committer.getEmailAddress() + '>';
                    }
                    return committer.getName();
                }
                case 5: {
                    return this.getDateFormatter().formatDate(committer);
                }
            }
        }
        return "";
    }

    private GitDateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = PreferenceBasedDateFormatter.create();
        }
        return this.dateFormatter;
    }

    private PersonIdent authorOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastAuthor;
    }

    private PersonIdent committerOf(RevCommit c) {
        if (this.lastCommit != c) {
            this.lastCommit = c;
            this.lastAuthor = c.getAuthorIdent();
            this.lastCommitter = c.getCommitterIdent();
        }
        return this.lastCommitter;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    private void setRelativeDate(boolean relative) {
        if (this.dateFormatter instanceof PreferenceBasedDateFormatter) {
            if (relative) {
                this.setDateFormatter(new GitDateFormatter(GitDateFormatter.Format.RELATIVE));
            }
        } else if (!relative) {
            this.setDateFormatter(PreferenceBasedDateFormatter.create());
        }
    }

    private void setShowEmailAddresses(boolean showEmail) {
        if (showEmail != this.showEmail) {
            this.showEmail = showEmail;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }

    private void setDateFormatter(GitDateFormatter formatter) {
        this.dateFormatter = formatter;
        this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
    }
}

