/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesystem.constraints;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.ts.typeRefs.ExistentialTypeRef;
import org.eclipse.n4js.ts.typeRefs.FunctionTypeExprOrRef;
import org.eclipse.n4js.ts.typeRefs.IntersectionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeArgument;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.typeRefs.TypeTypeRef;
import org.eclipse.n4js.ts.typeRefs.UnionTypeExpression;
import org.eclipse.n4js.ts.typeRefs.UnknownTypeRef;
import org.eclipse.n4js.ts.typeRefs.Wildcard;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.InferenceVariable;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.TypeVariable;
import org.eclipse.n4js.ts.types.util.AllSuperTypesCollector;
import org.eclipse.n4js.ts.types.util.Variance;
import org.eclipse.n4js.ts.utils.TypeUtils;
import org.eclipse.n4js.typesystem.N4JSTypeSystem;
import org.eclipse.n4js.typesystem.constraints.InferenceContext;
import org.eclipse.n4js.typesystem.constraints.TypeBound;
import org.eclipse.n4js.typesystem.constraints.TypeConstraint;
import org.eclipse.n4js.typesystem.utils.RuleEnvironment;
import org.eclipse.n4js.typesystem.utils.RuleEnvironmentExtensions;
import org.eclipse.n4js.typesystem.utils.StructuralTypingComputer;
import org.eclipse.n4js.typesystem.utils.TypeSystemHelper;
import org.eclipse.n4js.utils.StructuralMembersTriple;
import org.eclipse.n4js.utils.StructuralMembersTripleIterator;
import org.eclipse.n4js.utils.StructuralTypesHelper;
import org.eclipse.xtext.xbase.lib.Pair;

final class Reducer {
    private static final boolean DEBUG = false;
    private final InferenceContext ic;
    private final RuleEnvironment G;
    private final N4JSTypeSystem ts;
    private final TypeSystemHelper tsh;

    public Reducer(InferenceContext ic, RuleEnvironment G, N4JSTypeSystem ts, TypeSystemHelper tsh) {
        this.ic = ic;
        this.G = G;
        this.ts = ts;
        this.tsh = tsh;
    }

    private boolean addBound(boolean b) {
        return this.ic.currentBounds.addBound(b);
    }

    private boolean addBound(InferenceVariable infVar, TypeRef bound, Variance variance) {
        return this.ic.currentBounds.addBound(new TypeBound(infVar, bound, variance));
    }

    private boolean giveUp(EObject left, EObject right, Variance variance) {
        return this.addBound(false);
    }

    public boolean reduce(TypeConstraint constraint) {
        if (constraint == TypeConstraint.TRUE) {
            return this.addBound(true);
        }
        if (constraint == TypeConstraint.FALSE) {
            return this.addBound(false);
        }
        return this.reduce(constraint.left, constraint.right, constraint.variance);
    }

    public boolean reduce(TypeArgument left, TypeArgument right, Variance variance) {
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof TypeRef && right instanceof TypeRef) {
            return this.reduceTypeRef((TypeRef)left, (TypeRef)right, variance);
        }
        if (left instanceof Wildcard && right instanceof Wildcard) {
            return this.reduceWildcard((Wildcard)left, (Wildcard)right, variance);
        }
        return this.giveUp((EObject)left, (EObject)right, variance);
    }

    private boolean reduce(TypeRef left, List<TypeRef> rights, Variance variance, BooleanOp operator) {
        if (operator == BooleanOp.CONJUNCTION) {
            boolean wasAdded = false;
            for (TypeRef currRight : rights) {
                wasAdded |= this.reduce((TypeArgument)left, (TypeArgument)currRight, variance);
            }
            return wasAdded;
        }
        int rightsSize = rights.size();
        if (rightsSize == 0) {
            return false;
        }
        if (rightsSize == 1) {
            return this.reduce((TypeArgument)left, (TypeArgument)rights.get(0), variance);
        }
        int idx = -1;
        if (idx == -1 && left instanceof FunctionTypeExprOrRef) {
            int i = 0;
            while (i < rightsSize) {
                TypeRef currElem = rights.get(i);
                if (currElem instanceof FunctionTypeExprOrRef) {
                    boolean mightMatch;
                    FunctionTypeExprOrRef leftCasted = (FunctionTypeExprOrRef)left;
                    FunctionTypeExprOrRef currElemCasted = (FunctionTypeExprOrRef)currElem;
                    boolean bl = mightMatch = variance == Variance.CO && this.mightBeSubtypeOf(leftCasted, currElemCasted) || variance == Variance.CONTRA && this.mightBeSubtypeOf(currElemCasted, leftCasted) || variance == Variance.INV && this.mightBeSubtypeOf(leftCasted, currElemCasted) && this.mightBeSubtypeOf(currElemCasted, leftCasted);
                    if (mightMatch) {
                        idx = i;
                        break;
                    }
                }
                ++i;
            }
        }
        if (idx == -1 && left instanceof ParameterizedTypeRef && !TypeUtils.isInferenceVariable((TypeRef)left)) {
            Type leftDecl = left.getDeclaredType();
            if (idx == -1 && leftDecl != null) {
                int i = 0;
                while (i < rightsSize) {
                    TypeRef currElem = rights.get(i);
                    if (leftDecl == currElem.getDeclaredType()) {
                        idx = i;
                        break;
                    }
                    ++i;
                }
            }
            if (idx == -1 && leftDecl instanceof PrimitiveType) {
                idx = this.chooseFirstInferenceVariable(rights);
            }
            if (idx == -1 && variance == Variance.CO && leftDecl instanceof ContainerType) {
                List superTypesOfLeft = AllSuperTypesCollector.collect((ContainerType)((ContainerType)leftDecl));
                int i = 0;
                while (i < rightsSize) {
                    TypeRef currElem = rights.get(i);
                    Type currElemDecl = currElem.getDeclaredType();
                    if (currElemDecl != null && superTypesOfLeft.contains(currElemDecl)) {
                        idx = i;
                        break;
                    }
                    ++i;
                }
            }
            if (idx == -1 && variance == Variance.CONTRA && leftDecl != null) {
                int i = 0;
                while (i < rightsSize) {
                    List superTypesOfCurrElem;
                    TypeRef currElem = rights.get(i);
                    Type currElemDecl = currElem.getDeclaredType();
                    if (currElemDecl instanceof ContainerType && (superTypesOfCurrElem = AllSuperTypesCollector.collect((ContainerType)((ContainerType)currElemDecl))).contains(leftDecl)) {
                        idx = i;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (idx == -1) {
            idx = this.chooseFirstInferenceVariable(rights);
        }
        if (idx == -1 && variance == Variance.CO) {
            if (idx == -1) {
                idx = this.chooseFirstWithDeclTypeOf(rights, (Type)RuleEnvironmentExtensions.topType(this.G));
            }
            if (idx == -1) {
                idx = this.chooseFirstWithDeclTypeOf(rights, (Type)RuleEnvironmentExtensions.objectType(this.G));
            }
            if (idx == -1) {
                idx = this.chooseFirstWithDeclTypeOf(rights, (Type)RuleEnvironmentExtensions.n4ObjectType(this.G));
            }
        }
        if (idx == -1 && variance == Variance.CONTRA) {
            if (idx == -1) {
                idx = this.chooseFirstWithDeclTypeOf(rights, (Type)RuleEnvironmentExtensions.bottomType(this.G));
            }
            if (idx == -1) {
                idx = this.chooseFirstWithDeclTypeOf(rights, (Type)RuleEnvironmentExtensions.nullType(this.G));
            }
        }
        if (idx == -1) {
            idx = 0;
        }
        return this.reduce((TypeArgument)left, (TypeArgument)rights.get(idx), variance);
    }

    private final int chooseFirstInferenceVariable(List<TypeRef> typeRefs) {
        int typeRefsSize = typeRefs.size();
        int i = 0;
        while (i < typeRefsSize) {
            TypeRef currTypeRef = typeRefs.get(i);
            if (TypeUtils.isInferenceVariable((TypeRef)currTypeRef)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private final int chooseFirstWithDeclTypeOf(List<TypeRef> typeRefs, Type declType) {
        int typeRefsSize = typeRefs.size();
        int i = 0;
        while (i < typeRefsSize) {
            TypeRef currElem = typeRefs.get(i);
            if (currElem != null && currElem.getDeclaredType() == declType) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean reduceTypeRef(TypeRef left, TypeRef right, Variance variance) {
        boolean isRightStructural;
        boolean isLeftProper = TypeUtils.isProper((TypeArgument)left);
        boolean isRightProper = TypeUtils.isProper((TypeArgument)right);
        if (isLeftProper && isRightProper) {
            return this.reduceProper(left, right, variance);
        }
        boolean isLeftInfVar = TypeUtils.isInferenceVariable((TypeRef)left);
        boolean isRightInfVar = TypeUtils.isInferenceVariable((TypeRef)right);
        if (isLeftInfVar || isRightInfVar) {
            if (isLeftInfVar) {
                return this.addBound((InferenceVariable)left.getDeclaredType(), right, variance);
            }
            return this.addBound((InferenceVariable)right.getDeclaredType(), left, variance.inverse());
        }
        boolean isLeftStructural = left.isUseSiteStructuralTyping() || left.isDefSiteStructuralTyping();
        boolean bl = isRightStructural = right.isUseSiteStructuralTyping() || right.isDefSiteStructuralTyping();
        if (isLeftStructural && (variance == Variance.CONTRA || variance == Variance.INV) || isRightStructural && (variance == Variance.CO || variance == Variance.INV)) {
            return this.reduceStructuralTypeRef(left, right, variance);
        }
        if (left instanceof ComposedTypeRef) {
            return this.reduceComposedTypeRef(right, (ComposedTypeRef)left, variance.inverse());
        }
        if (right instanceof ComposedTypeRef) {
            return this.reduceComposedTypeRef(left, (ComposedTypeRef)right, variance);
        }
        if (left instanceof TypeTypeRef && right instanceof TypeTypeRef) {
            return this.reduceTypeTypeRef((TypeTypeRef)left, (TypeTypeRef)right, variance);
        }
        if (left instanceof FunctionTypeExprOrRef && right instanceof FunctionTypeExprOrRef) {
            return this.reduceFunctionTypeExprOrRef((FunctionTypeExprOrRef)left, (FunctionTypeExprOrRef)right, variance);
        }
        if (left instanceof ParameterizedTypeRef && right instanceof ParameterizedTypeRef) {
            return this.reduceParameterizedTypeRefNominal((ParameterizedTypeRef)left, (ParameterizedTypeRef)right, variance);
        }
        if (this.isSubtypeOf(left, right, variance)) {
            return this.addBound(true);
        }
        return this.giveUp((EObject)left, (EObject)right, variance);
    }

    private boolean reduceWildcard(Wildcard left, Wildcard right, Variance variance) {
        if (left == right) {
            return false;
        }
        boolean wasAdded = false;
        TypeRef lbLeft = left.getDeclaredLowerBound();
        TypeRef lbRight = right.getDeclaredLowerBound();
        if (lbLeft != null || lbRight != null) {
            TypeRef lbLeftOrBottom = lbLeft != null ? lbLeft : this.bottom();
            TypeRef lbRightOrBottom = lbRight != null ? lbRight : this.bottom();
            wasAdded |= this.reduce((TypeArgument)lbLeftOrBottom, (TypeArgument)lbRightOrBottom, Variance.INV);
        }
        TypeRef ubLeft = left.getDeclaredUpperBound();
        TypeRef ubRight = right.getDeclaredUpperBound();
        if (ubLeft != null || ubRight != null) {
            TypeRef ubLeftOrTop = ubLeft != null ? ubLeft : this.top();
            TypeRef ubRightOrTop = ubRight != null ? ubRight : this.top();
            wasAdded |= this.reduce((TypeArgument)ubLeftOrTop, (TypeArgument)ubRightOrTop, Variance.INV);
        }
        return wasAdded;
    }

    private boolean reduceProper(TypeRef left, TypeRef right, Variance variance) {
        return this.addBound(this.isSubtypeOf(left, right, variance));
    }

    private boolean reduceComposedTypeRef(TypeRef left, ComposedTypeRef right, Variance variance) {
        if (variance == Variance.INV) {
            boolean wasAdded = false;
            wasAdded |= this.reduceComposedTypeRef(left, right, Variance.CO);
            return wasAdded |= this.reduceComposedTypeRef(left, right, Variance.CONTRA);
        }
        if (right instanceof UnionTypeExpression) {
            return this.reduceUnion(left, (UnionTypeExpression)right, variance);
        }
        if (right instanceof IntersectionTypeExpression) {
            return this.reduceIntersection(left, (IntersectionTypeExpression)right, variance);
        }
        throw new IllegalStateException("shouldn't get here");
    }

    private boolean reduceUnion(TypeRef left, UnionTypeExpression right, Variance variance) {
        switch (variance) {
            case CO: {
                return this.reduce(left, (List<TypeRef>)right.getTypeRefs(), Variance.CO, BooleanOp.DISJUNCTION);
            }
            case CONTRA: {
                return this.reduce(left, (List<TypeRef>)right.getTypeRefs(), Variance.CONTRA, BooleanOp.CONJUNCTION);
            }
            case INV: {
                throw new IllegalStateException("shouldn't get here");
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private boolean reduceIntersection(TypeRef left, IntersectionTypeExpression right, Variance variance) {
        switch (variance) {
            case CO: {
                return this.reduce(left, (List<TypeRef>)right.getTypeRefs(), Variance.CO, BooleanOp.CONJUNCTION);
            }
            case CONTRA: {
                return this.reduce(left, (List<TypeRef>)right.getTypeRefs(), Variance.CONTRA, BooleanOp.DISJUNCTION);
            }
            case INV: {
                throw new IllegalStateException("shouldn't get here");
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private boolean reduceTypeTypeRef(TypeTypeRef left, TypeTypeRef right, Variance variance) {
        TypeArgument leftStatic = (TypeArgument)TypeUtils.copy((EObject)left.getTypeArg());
        TypeArgument rightStatic = (TypeArgument)TypeUtils.copy((EObject)right.getTypeArg());
        if (!left.isConstructorRef() && !right.isConstructorRef()) {
            return this.reduce(leftStatic, rightStatic, variance);
        }
        return this.reduce(leftStatic, rightStatic, Variance.INV);
    }

    private boolean reduceFunctionTypeExprOrRef(FunctionTypeExprOrRef left, FunctionTypeExprOrRef right, Variance variance) {
        if (left.isGeneric() || right.isGeneric()) {
            FunctionTypeExprOrRef leftNonGen = this.ic.newInferenceVariablesFor(left);
            FunctionTypeExprOrRef rightNonGen = this.ic.newInferenceVariablesFor(right);
            return this.reduceFunctionTypeExprOrRef(leftNonGen, rightNonGen, variance);
        }
        boolean wasAdded = false;
        Iterator valueParsIt = right.getFpars().iterator();
        for (TFormalParameter keyPar : left.getFpars()) {
            if (!valueParsIt.hasNext()) continue;
            wasAdded |= this.reduce((TypeArgument)keyPar.getTypeRef(), (TypeArgument)((TFormalParameter)valueParsIt.next()).getTypeRef(), variance.mult(Variance.CONTRA));
        }
        boolean isVoidLeft = TypeUtils.isVoidReturnType((FunctionTypeExprOrRef)left);
        boolean isVoidRight = TypeUtils.isVoidReturnType((FunctionTypeExprOrRef)right);
        if (isVoidLeft && isVoidRight) {
            wasAdded |= this.addBound(true);
        } else if (variance == Variance.CO && isVoidRight || variance == Variance.CONTRA && isVoidLeft) {
            wasAdded |= this.addBound(true);
        } else if (isVoidLeft || isVoidRight) {
            boolean isRetValOpt = isVoidLeft ? right.isReturnValueOptional() : left.isReturnValueOptional();
            wasAdded |= this.addBound(isRetValOpt);
        } else {
            wasAdded |= this.reduce((TypeArgument)left.getReturnTypeRef(), (TypeArgument)right.getReturnTypeRef(), variance.mult(Variance.CO));
        }
        TypeRef leftThis = left.getDeclaredThisType();
        TypeRef rightThis = right.getDeclaredThisType();
        if (leftThis != null || rightThis != null) {
            if (leftThis == null && rightThis != null) {
                wasAdded = variance == Variance.CO ? (wasAdded |= this.addBound(true)) : (wasAdded |= this.giveUp((EObject)left, (EObject)right, variance));
            } else if (leftThis != null && rightThis == null) {
                wasAdded = variance == Variance.CONTRA ? (wasAdded |= this.addBound(true)) : (wasAdded |= this.giveUp((EObject)left, (EObject)right, variance));
            } else if (leftThis != null && rightThis != null) {
                wasAdded |= this.reduce((TypeArgument)leftThis, (TypeArgument)rightThis, variance.mult(Variance.CONTRA));
            }
        }
        return wasAdded;
    }

    private boolean reduceParameterizedTypeRefNominal(ParameterizedTypeRef left, ParameterizedTypeRef right, Variance variance) {
        if (variance == Variance.CO && this.isSpecialCaseOfArraySubtypeIterableN(left, right) || variance == Variance.CONTRA && this.isSpecialCaseOfArraySubtypeIterableN(right, left)) {
            EList typeArgsOfArray = variance == Variance.CO ? left.getTypeArgs() : right.getTypeArgs();
            EList typeArgsOfIterableN = variance == Variance.CO ? right.getTypeArgs() : left.getTypeArgs();
            EList typeParamsOfIterableN = variance == Variance.CO ? right.getDeclaredType().getTypeVars() : left.getDeclaredType().getTypeVars();
            TypeArgument singleTypeArgOfArray = !typeArgsOfArray.isEmpty() ? (TypeArgument)typeArgsOfArray.get(0) : null;
            boolean wasAdded = false;
            int len = Math.min(typeArgsOfIterableN.size(), typeParamsOfIterableN.size());
            int idx = 0;
            while (idx < len) {
                TypeArgument currTypeArgOfIterableN = (TypeArgument)typeArgsOfIterableN.get(idx);
                TypeVariable curTypeParamOfIterableN = (TypeVariable)typeParamsOfIterableN.get(idx);
                wasAdded |= this.reduceConstraintForTypeArgumentPair(currTypeArgOfIterableN, curTypeParamOfIterableN, singleTypeArgOfArray);
                ++idx;
            }
            return wasAdded;
        }
        ParameterizedTypeRef leftRaw = TypeUtils.createTypeRef((Type)left.getDeclaredType(), (TypeArgument[])new TypeArgument[0]);
        ParameterizedTypeRef rightRaw = TypeUtils.createTypeRef((Type)right.getDeclaredType(), (TypeArgument[])new TypeArgument[0]);
        if (variance == Variance.CO && !this.ts.subtypeSucceeded(this.G, (TypeArgument)leftRaw, (TypeArgument)rightRaw) || variance == Variance.CONTRA && !this.ts.subtypeSucceeded(this.G, (TypeArgument)rightRaw, (TypeArgument)leftRaw) || variance == Variance.INV && !this.ts.equaltypeSucceeded(this.G, (TypeArgument)leftRaw, (TypeArgument)rightRaw)) {
            return this.giveUp((EObject)left, (EObject)right, variance);
        }
        if (variance == Variance.CO) {
            ParameterizedTypeRef tmp = left;
            left = right;
            right = tmp;
            variance = Variance.CONTRA;
        }
        boolean wasAdded = false;
        RuleEnvironment Gx = RuleEnvironmentExtensions.newRuleEnvironment(this.G);
        this.tsh.addSubstitutions(Gx, (TypeRef)right);
        Type leftType = left.getDeclaredType();
        EList leftArgs = left.getTypeArgs();
        EList leftParams = leftType.getTypeVars();
        int len = Math.min(leftArgs.size(), leftParams.size());
        int idx = 0;
        while (idx < len) {
            TypeArgument leftArg = (TypeArgument)leftArgs.get(idx);
            TypeVariable leftParam = (TypeVariable)leftParams.get(idx);
            if (RuleEnvironmentExtensions.hasSubstitutionFor(Gx, leftParam)) {
                TypeRef leftParamSubst = this.ts.substTypeVariables(Gx, (TypeRef)TypeUtils.createTypeRef((Type)leftParam, (TypeArgument[])new TypeArgument[0]));
                wasAdded |= this.reduceConstraintForTypeArgumentPair(leftArg, leftParam, (TypeArgument)leftParamSubst);
            }
            ++idx;
        }
        return wasAdded;
    }

    private boolean reduceConstraintForTypeArgumentPair(TypeArgument leftArg, TypeVariable leftParam, TypeArgument rightArg) {
        boolean wasAdded = false;
        if (leftArg instanceof Wildcard) {
            TypeRef lb;
            TypeRef ub = ((Wildcard)leftArg).getDeclaredUpperBound();
            if (ub != null) {
                wasAdded |= this.reduce((TypeArgument)ub, (TypeArgument)this.ts.upperBound(this.G, rightArg), Variance.CONTRA);
            }
            if ((lb = ((Wildcard)leftArg).getDeclaredLowerBound()) != null) {
                wasAdded |= this.reduce((TypeArgument)lb, (TypeArgument)this.ts.lowerBound(this.G, rightArg), Variance.CO);
            }
        } else if (rightArg instanceof ExistentialTypeRef) {
            TypeRef lb;
            Wildcard w = ((ExistentialTypeRef)rightArg).getWildcard();
            TypeRef ub = w.getDeclaredUpperBound();
            if (ub != null) {
                wasAdded |= this.reduce((TypeArgument)ub, (TypeArgument)this.ts.upperBound(this.G, leftArg), Variance.CONTRA);
            }
            if ((lb = w.getDeclaredLowerBound()) != null) {
                wasAdded |= this.reduce((TypeArgument)lb, (TypeArgument)this.ts.lowerBound(this.G, leftArg), Variance.CO);
            }
        } else {
            if (!(leftArg instanceof TypeRef)) {
                throw new UnsupportedOperationException("unsupported subtype of TypeArgument: " + leftArg.getClass().getName());
            }
            Variance leftDefSiteVarianceRaw = leftParam.getVariance();
            Variance leftDefSiteVariance = leftDefSiteVarianceRaw != null ? leftDefSiteVarianceRaw : Variance.INV;
            wasAdded |= this.reduce(leftArg, rightArg, Variance.CONTRA.mult(leftDefSiteVariance));
        }
        return wasAdded;
    }

    private boolean isSpecialCaseOfArraySubtypeIterableN(ParameterizedTypeRef left, ParameterizedTypeRef right) {
        boolean leftIsArray = left.getDeclaredType() == RuleEnvironmentExtensions.arrayType(this.G);
        boolean rightIsIterableN = RuleEnvironmentExtensions.isIterableN(this.G, (EObject)right);
        return leftIsArray && rightIsIterableN;
    }

    private boolean reduceStructuralTypeRef(TypeRef left, TypeRef right, Variance variance) {
        if (variance == Variance.CONTRA) {
            return this.reduceStructuralTypeRef(right, left, Variance.CO);
        }
        StructuralTypingComputer stc = this.tsh.getStructuralTypingComputer();
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
        StructuralTypingComputer.StructTypingInfo infoFaked = new StructuralTypingComputer.StructTypingInfo(G2, left, right, left.getTypingStrategy(), right.getTypingStrategy());
        boolean wasAdded = false;
        StructuralTypesHelper structTypesHelper = this.tsh.getStructuralTypesHelper();
        StructuralMembersTripleIterator iter = structTypesHelper.getMembersTripleIterator(G2, left, right, false);
        while (iter.hasNext()) {
            TypeConstraint constraint;
            StructuralMembersTriple next = iter.next();
            TMember l = next.getLeft();
            TMember r = next.getRight();
            if (l == null || r == null || Reducer.containsReopenedExistentialType(G2, constraint = stc.reduceMembers(left, l, r, variance, infoFaked))) continue;
            wasAdded |= this.reduce(constraint);
        }
        return wasAdded;
    }

    private boolean isSubtypeOf(TypeRef left, TypeRef right, Variance variance) {
        Pair key = Pair.of((Object)"Reducer#isSubtypeOf", (Object)Pair.of((Object)left, (Object)right));
        if (this.G.get(key) != null) {
            return true;
        }
        RuleEnvironment G2 = RuleEnvironmentExtensions.wrap(this.G);
        G2.put(key, Boolean.TRUE);
        switch (variance) {
            case CO: {
                return this.ts.subtypeSucceeded(G2, (TypeArgument)left, (TypeArgument)right);
            }
            case CONTRA: {
                return this.ts.subtypeSucceeded(G2, (TypeArgument)right, (TypeArgument)left);
            }
            case INV: {
                return this.ts.equaltypeSucceeded(G2, (TypeArgument)left, (TypeArgument)right);
            }
        }
        throw new IllegalStateException("unreachable");
    }

    private boolean mightBeSubtypeOf(FunctionTypeExprOrRef left, FunctionTypeExprOrRef right) {
        UnknownTypeRef unknown = TypeRefsFactory.eINSTANCE.createUnknownTypeRef();
        RuleEnvironment G_temp = RuleEnvironmentExtensions.newRuleEnvironment(this.G);
        for (InferenceVariable iv : this.ic.getInferenceVariables()) {
            RuleEnvironmentExtensions.addTypeMapping(G_temp, (TypeVariable)iv, (TypeArgument)unknown);
        }
        TypeRef leftSubst = this.ts.substTypeVariables(G_temp, (TypeRef)left);
        TypeRef rightSubst = this.ts.substTypeVariables(G_temp, (TypeRef)right);
        return this.ts.subtypeSucceeded(this.G, (TypeArgument)leftSubst, (TypeArgument)rightSubst);
    }

    private static final boolean containsReopenedExistentialType(RuleEnvironment someG, TypeConstraint constraint) {
        return constraint != null && (RuleEnvironmentExtensions.isExistentialTypeToBeReopened(someG, (EObject)constraint.left, true) || RuleEnvironmentExtensions.isExistentialTypeToBeReopened(someG, (EObject)constraint.right, true));
    }

    private TypeRef bottom() {
        return RuleEnvironmentExtensions.bottomTypeRef(this.G);
    }

    private TypeRef top() {
        return RuleEnvironmentExtensions.topTypeRef(this.G);
    }

    private void log(String message) {
        this.ic.log(message);
    }

    static enum BooleanOp {
        CONJUNCTION,
        DISJUNCTION;

    }
}

