/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.types.util;

import java.util.Collections;
import java.util.List;
import org.eclipse.n4js.ts.typeRefs.ParameterizedTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRefsFactory;
import org.eclipse.n4js.ts.types.ContainerType;
import org.eclipse.n4js.ts.types.PrimitiveType;
import org.eclipse.n4js.ts.types.TClass;
import org.eclipse.n4js.ts.types.TInterface;
import org.eclipse.n4js.ts.types.TObjectPrototype;
import org.eclipse.n4js.ts.types.TStructuralType;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ts.types.VirtualBaseType;
import org.eclipse.n4js.ts.types.util.TypesSwitch;
import org.eclipse.n4js.utils.RecursionGuard;

public abstract class AbstractHierachyTraverser<Result>
extends TypesSwitch<Boolean> {
    protected final RecursionGuard<Type> guard;
    protected final ContainerType<?> bottomType;

    public AbstractHierachyTraverser(ContainerType<?> type) {
        this.bottomType = type;
        this.guard = new RecursionGuard();
    }

    public Result getResult() {
        this.traverse();
        return this.doGetResult();
    }

    protected abstract Result doGetResult();

    protected abstract boolean process(ContainerType<?> var1);

    private void traverse() {
        Boolean result = (Boolean)this.doSwitch(this.bottomType);
        if (Boolean.TRUE.equals(result)) {
            return;
        }
    }

    @Override
    public Boolean casePrimitiveType(PrimitiveType object) {
        if (this.guard.tryNext((Object)object)) {
            if (this.process(object)) {
                return true;
            }
            PrimitiveType assignmentCompatible = object.getAssignmentCompatible();
            if (assignmentCompatible != null) {
                ParameterizedTypeRef typeRef = TypeRefsFactory.eINSTANCE.createParameterizedTypeRef();
                typeRef.setDeclaredType(assignmentCompatible);
                Boolean result = this.doProcess(typeRef);
                if (Boolean.TRUE.equals(result)) {
                    return result;
                }
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseTObjectPrototype(TObjectPrototype object) {
        if (this.guard.tryNext((Object)object)) {
            if (!object.isPolyfill() && this.doProcess(this.getPolyfills(object))) {
                return true;
            }
            if (this.process(object)) {
                return Boolean.TRUE;
            }
            if (!object.isPolyfill()) {
                return this.doProcess(this.getSuperTypes(object));
            }
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseTClass(TClass object) {
        if (this.guard.tryNext((Object)object)) {
            if (!object.isPolyfill() && this.doProcess(this.getPolyfills(object))) {
                return true;
            }
            if (this.process(object)) {
                return Boolean.TRUE;
            }
            if (!object.isPolyfill() || object.isStaticPolyfill()) {
                if (this.doProcessSuperTypes(object)) {
                    return true;
                }
                if (this.doProcessConsumedRoles(object)) {
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.FALSE;
    }

    protected boolean doProcessSuperTypes(TClass object) {
        return this.doProcess(this.getSuperTypes(object));
    }

    protected boolean doProcessConsumedRoles(TClass object) {
        return this.doProcess((List<ParameterizedTypeRef>)object.getImplementedInterfaceRefs());
    }

    @Override
    public Boolean caseTInterface(TInterface object) {
        if (this.guard.tryNext((Object)object)) {
            if (this.process(object)) {
                return Boolean.TRUE;
            }
            return this.doProcessSuperInterfaces(object);
        }
        return Boolean.FALSE;
    }

    protected boolean doProcessSuperInterfaces(TInterface object) {
        return this.doProcess(this.getSuperTypes(object));
    }

    @Override
    public Boolean caseTStructuralType(TStructuralType object) {
        if (this.guard.tryNext((Object)object)) {
            return this.process(object);
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean caseVirtualBaseType(VirtualBaseType object) {
        if (this.guard.tryNext((Object)object)) {
            return this.process(object);
        }
        return Boolean.FALSE;
    }

    protected boolean doProcess(List<ParameterizedTypeRef> typeRefs) {
        if (typeRefs == null) {
            return false;
        }
        for (ParameterizedTypeRef typeRef : typeRefs) {
            if (!this.doProcess(typeRef)) continue;
            return true;
        }
        return false;
    }

    protected boolean doProcess(ParameterizedTypeRef typeRef) {
        if (typeRef == null) {
            return false;
        }
        Type type = typeRef.getDeclaredType();
        if (type == null || type.eIsProxy()) {
            return false;
        }
        Boolean result = (Boolean)this.doSwitch(type);
        return result == null ? false : result;
    }

    protected List<ParameterizedTypeRef> getSuperTypes(Type t) {
        if (t instanceof TClass && ((TClass)t).getSuperClassRef() != null) {
            return Collections.singletonList(((TClass)t).getSuperClassRef());
        }
        if (t instanceof TInterface && !((TInterface)t).getSuperInterfaceRefs().isEmpty()) {
            return ((TInterface)t).getSuperInterfaceRefs();
        }
        if (t instanceof TObjectPrototype && ((TObjectPrototype)t).getSuperType() != null) {
            return Collections.singletonList(((TObjectPrototype)t).getSuperType());
        }
        return this.getImplicitSuperTypes(t);
    }

    protected List<ParameterizedTypeRef> getImplicitSuperTypes(Type t) {
        return Collections.emptyList();
    }

    protected List<ParameterizedTypeRef> getPolyfills(Type filledType) {
        return Collections.emptyList();
    }
}

