/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.n4idl.transpiler.utils;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.VersionedElement;
import org.eclipse.n4js.n4idl.versioning.VersionUtils;
import org.eclipse.n4js.transpiler.im.SymbolTableEntryOriginal;
import org.eclipse.n4js.ts.typeRefs.Versionable;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TVersionable;
import org.eclipse.n4js.ts.versions.VersionableUtils;

public class N4IDLTranspilerUtils {
    public static String getVersionedInternalName(NamedElement element) {
        if (VersionableUtils.isTVersionable((EObject)element)) {
            return String.valueOf(element.getName()) + "$" + ((Versionable)element).getVersion();
        }
        if (VersionUtils.isVersioned((EObject)element)) {
            return String.valueOf(element.getName()) + "$" + ((VersionedElement)element).getDeclaredVersion();
        }
        return element.getName();
    }

    public static String getVersionedInternalName(IdentifiableElement element) {
        if (VersionableUtils.isTVersionable((EObject)element)) {
            return String.valueOf(element.getName()) + "$" + ((Versionable)element).getVersion();
        }
        return element.getName();
    }

    public static String getVersionedInternalName(NamedImportSpecifier specifier) {
        String importedName;
        TExportableElement importedElement = specifier.getImportedElement();
        String alias = specifier.getAlias();
        String string = importedName = alias != null ? alias : importedElement.getExportedName();
        if (!VersionableUtils.isTVersionable((EObject)importedElement)) {
            return importedName;
        }
        int version = ((TVersionable)importedElement).getVersion();
        return N4IDLTranspilerUtils.getVersionedInternalName(importedName, version);
    }

    public static String getVersionedInternalAlias(String alias, TVersionable aliasedVersionable) {
        if (!VersionableUtils.isTVersionable((EObject)aliasedVersionable)) {
            return alias;
        }
        return N4IDLTranspilerUtils.getVersionedInternalName(alias, aliasedVersionable.getVersion());
    }

    private static String getVersionedInternalName(String name, int version) {
        if (version < 1) {
            throw new IllegalArgumentException("Version must be greater than zero.");
        }
        return String.valueOf(name) + "$" + version;
    }

    private N4IDLTranspilerUtils() {
    }

    public static boolean isVersionedImportSpecifier(NamedImportSpecifier specifier) {
        return VersionableUtils.isTVersionable((EObject)specifier.getImportedElement());
    }

    public static boolean refersToVersionedType(SymbolTableEntryOriginal entry) {
        return VersionableUtils.isTVersionable((EObject)entry.getOriginalTarget());
    }
}

