/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryWorkspace;
import org.eclipse.n4js.external.HlcExternalLibraryWorkspace;
import org.eclipse.n4js.internal.FileBasedExternalPackageManager;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.MultiCleartriggerCache;
import org.eclipse.n4js.internal.N4JSProject;
import org.eclipse.n4js.internal.N4JSProjectSourceContainer;
import org.eclipse.n4js.internal.TypeDefinitionsAwareDependenciesSupplier;
import org.eclipse.n4js.projectDescription.ProjectDescription;
import org.eclipse.n4js.projectDescription.ProjectReference;
import org.eclipse.n4js.projectDescription.ProjectType;
import org.eclipse.n4js.projectDescription.SourceContainerDescription;
import org.eclipse.n4js.projectDescription.SourceContainerType;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.utils.ProjectDescriptionUtils;
import org.eclipse.xtext.naming.QualifiedName;

@Singleton
public class N4JSModel {
    private final InternalN4JSWorkspace workspace;
    @Inject
    protected ExternalLibraryWorkspace externalLibraryWorkspace;
    @Inject
    protected FileBasedExternalPackageManager packageManager;
    @Inject
    private MultiCleartriggerCache cache;

    @Inject
    public N4JSModel(InternalN4JSWorkspace workspace) {
        this.workspace = workspace;
    }

    public N4JSProject getN4JSProject(URI location) {
        Preconditions.checkArgument((boolean)location.isFile(), (Object)("Expecting file URI. Was: " + location));
        boolean external = this.externalLibraryWorkspace != null && this.externalLibraryWorkspace.getProject(location) != null;
        return new N4JSProject(location, external, this);
    }

    public N4JSProject findProjectWith(URI nestedLocation) {
        URI location = this.workspace.findProjectWith(nestedLocation);
        if (location != null) {
            return this.getN4JSProject(location);
        }
        location = this.externalLibraryWorkspace.findProjectWith(nestedLocation);
        if (location != null) {
            return this.getN4JSProject(location);
        }
        return null;
    }

    public Optional<? extends IN4JSSourceContainer> findN4JSSourceContainer(URI nestedLocation) {
        Optional<? extends IN4JSSourceContainer> foundN4JSSourceContainer = Optional.absent();
        N4JSProject project = this.findProjectWith(nestedLocation);
        foundN4JSSourceContainer = this.findN4JSSourceContainerInProject(project, nestedLocation);
        return foundN4JSSourceContainer;
    }

    public Optional<? extends IN4JSSourceContainer> findN4JSExternalSourceContainer(IN4JSProject extPackage, URI nestedLocation) {
        return this.findN4JSSourceContainerInProject(extPackage, nestedLocation);
    }

    protected Optional<? extends IN4JSSourceContainer> findN4JSSourceContainerInProject(IN4JSProject project, URI nestedLocation) {
        IN4JSSourceContainer matchingContainer = null;
        int matchingSegmentCount = -1;
        if (project != null) {
            for (IN4JSSourceContainer n4jsSourceContainer : project.getSourceContainers()) {
                int segmentCount;
                if (!this.isLocationInNestedInContainer(nestedLocation, n4jsSourceContainer) || (segmentCount = n4jsSourceContainer.getLocation().segmentCount()) <= matchingSegmentCount) continue;
                matchingContainer = n4jsSourceContainer;
                matchingSegmentCount = segmentCount;
            }
        }
        return Optional.fromNullable(matchingContainer);
    }

    private boolean isLocationInNestedInContainer(URI nestedLocation, IN4JSSourceContainer container) {
        URI containerLocation = container.getLocation();
        if (containerLocation == null || nestedLocation == null) {
            return false;
        }
        int maxSegments = containerLocation.segmentCount();
        if (nestedLocation.segmentCount() >= maxSegments) {
            int i = 0;
            while (i < maxSegments) {
                if (!nestedLocation.segment(i).equals(containerLocation.segment(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected InternalN4JSWorkspace getInternalWorkspace() {
        return this.workspace;
    }

    public ProjectDescription getProjectDescription(URI location) {
        ProjectDescription description = this.workspace.getProjectDescription(location);
        if (description == null) {
            description = this.externalLibraryWorkspace.getProjectDescription(location);
        }
        return description;
    }

    public ImmutableList<? extends IN4JSSourceContainer> getN4JSSourceContainers(N4JSProject project) {
        ImmutableList.Builder result = ImmutableList.builder();
        URI location = project.getLocation();
        ProjectDescription description = this.getProjectDescription(location);
        if (description != null) {
            ArrayList sourceFragments = Lists.newArrayList((Iterable)FluentIterable.from((Iterable)description.getSourceContainers()));
            sourceFragments.sort((f1, fDIRECT_RESOURCE_IN_PROJECT_SEGMENTCOUNT) -> ProjectDescriptionUtils.compareBySourceContainerType(f1, fDIRECT_RESOURCE_IN_PROJECT_SEGMENTCOUNT));
            for (SourceContainerDescription sourceFragment : sourceFragments) {
                List<String> paths = ProjectDescriptionUtils.getPathsNormalized(sourceFragment);
                for (String path : paths) {
                    String relativeLocation = ".".equals(path) ? "" : path;
                    IN4JSSourceContainer sourceContainer = this.createProjectN4JSSourceContainer(project, sourceFragment.getSourceContainerType(), relativeLocation);
                    result.add((Object)sourceContainer);
                }
            }
        }
        return result.build();
    }

    protected String getLocationPath(URI location) {
        return location.toFileString();
    }

    protected IN4JSSourceContainer createProjectN4JSSourceContainer(N4JSProject project, SourceContainerType type, String relativeLocation) {
        return new N4JSProjectSourceContainer(project, type, relativeLocation);
    }

    public ImmutableList<? extends IN4JSProject> getDependencies(N4JSProject project, boolean includeAbsentProjects) {
        return this.getDependencies(project, false, includeAbsentProjects);
    }

    public ImmutableList<? extends IN4JSProject> getDependenciesAndImplementedApis(N4JSProject project, boolean includeAbsentProjects) {
        return this.getDependencies(project, true, includeAbsentProjects);
    }

    private ImmutableList<? extends IN4JSProject> getDependencies(N4JSProject project, boolean includeApis, boolean includeAbsentProjects) {
        ImmutableList.Builder result = ImmutableList.builder();
        URI location = project.getLocation();
        ProjectDescription description = this.getProjectDescription(location);
        if (description != null) {
            result.addAll(this.resolveProjectReferences(project, (Iterable<? extends ProjectReference>)description.getProjectDependencies(), includeAbsentProjects));
            if (includeApis) {
                result.addAll(this.resolveProjectReferences(project, (Iterable<? extends ProjectReference>)description.getImplementedProjects(), includeAbsentProjects));
            }
        }
        return result.build();
    }

    public Optional<IN4JSProject> getExtendedRuntimeEnvironment(N4JSProject project) {
        URI location = project.getLocation();
        ProjectDescription description = this.getProjectDescription(location);
        if (description == null) {
            return Optional.absent();
        }
        ProjectReference ref = description.getExtendedRuntimeEnvironment();
        return this.resolveProjectReference(project, ref, false);
    }

    public ImmutableList<? extends IN4JSProject> getImplementedProjects(N4JSProject project) {
        ImmutableList.Builder result = ImmutableList.builder();
        URI location = project.getLocation();
        ProjectDescription description = this.getProjectDescription(location);
        if (description != null) {
            result.addAll(this.resolveProjectReferences(project, (Iterable<? extends ProjectReference>)description.getImplementedProjects(), false));
        }
        return result.build();
    }

    public ImmutableList<? extends IN4JSProject> getProvidedRuntimeLibraries(N4JSProject project) {
        ImmutableList.Builder providedRuntimes = ImmutableList.builder();
        EList<ProjectReference> runtimeLibraries = this.getAllProvidedRuntimeLibraries(project);
        URI projectLocation = project.getLocation();
        for (ProjectReference runtimeLibrary : runtimeLibraries) {
            URI location = this.workspace.getLocation(projectLocation, runtimeLibrary);
            if (location == null) {
                location = this.externalLibraryWorkspace.getLocation(projectLocation, runtimeLibrary);
            }
            if (location == null) continue;
            providedRuntimes.add((Object)this.getN4JSProject(location));
        }
        return providedRuntimes.build();
    }

    private EList<ProjectReference> getAllProvidedRuntimeLibraries(N4JSProject project) {
        URI projectLocation = project.getLocation();
        if (projectLocation == null) {
            return ECollections.emptyEList();
        }
        ProjectDescription description = this.getProjectDescription(projectLocation);
        if (description == null) {
            return ECollections.emptyEList();
        }
        EList runtimeLibraries = description.getProvidedRuntimeLibraries();
        if (runtimeLibraries == null) {
            return ECollections.emptyEList();
        }
        return runtimeLibraries;
    }

    public Iterator<URI> iterator(IN4JSSourceContainer sourceContainer) {
        if (sourceContainer.getProject().isExternal() && Platform.isRunning()) {
            if (this.externalLibraryWorkspace instanceof HlcExternalLibraryWorkspace && this.workspace instanceof FileBasedWorkspace && this.workspace.findProjectWith(sourceContainer.getLocation()) != null) {
                return this.workspace.getFolderIterator(sourceContainer.getLocation());
            }
            return this.externalLibraryWorkspace.getFolderIterator(sourceContainer.getLocation());
        }
        return this.workspace.getFolderIterator(sourceContainer.getLocation());
    }

    public URI findArtifact(IN4JSSourceContainer sourceContainer, QualifiedName name, Optional<String> fileExtension) {
        String ext = ((String)fileExtension.or((Object)"")).trim();
        String extWithDot = !ext.isEmpty() && !ext.startsWith(".") ? "." + ext : ext;
        String pathStr = String.valueOf(name.toString("/")) + extWithDot;
        URI artifactLocation = this.workspace.findArtifactInFolder(sourceContainer.getLocation(), pathStr);
        if (artifactLocation == null) {
            artifactLocation = this.externalLibraryWorkspace.findArtifactInFolder(sourceContainer.getLocation(), pathStr);
        }
        return artifactLocation;
    }

    public Optional<String> getExtendedRuntimeEnvironmentName(URI location) {
        if (location == null) {
            return Optional.absent();
        }
        ProjectDescription description = this.getProjectDescription(location);
        if (description == null) {
            return Optional.absent();
        }
        ProjectReference reRef = description.getExtendedRuntimeEnvironment();
        if (reRef == null) {
            return Optional.absent();
        }
        return Optional.fromNullable((Object)reRef.getProjectName());
    }

    public Collection<IN4JSProject> getTestedProjects(N4JSProject project) {
        if (project == null || !project.exists()) {
            return Collections.emptyList();
        }
        if (!ProjectType.TEST.equals((Object)project.getProjectType())) {
            return Collections.emptyList();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        URI location = project.getLocation();
        ProjectDescription description = this.getProjectDescription(location);
        if (description != null) {
            for (ProjectReference testedProject : description.getTestedProjects()) {
                N4JSProject tested;
                URI hostLocation = this.workspace.getLocation(location, testedProject);
                if (hostLocation == null) {
                    hostLocation = this.externalLibraryWorkspace.getLocation(location, testedProject);
                }
                if (hostLocation == null || (tested = this.getN4JSProject(hostLocation)) == null || !tested.exists()) continue;
                builder.add((Object)tested);
            }
        }
        return builder.build();
    }

    public Optional<IN4JSProject> resolveProjectReference(IN4JSProject project, ProjectReference reference, boolean includeAbsentProjects) {
        if (project == null || reference == null) {
            return Optional.absent();
        }
        URI location = project.getLocation();
        if (location == null) {
            return Optional.absent();
        }
        URI dependencyLocation = this.workspace.getLocation(location, reference);
        if (dependencyLocation != null) {
            return Optional.fromNullable((Object)this.getN4JSProject(dependencyLocation));
        }
        dependencyLocation = this.externalLibraryWorkspace.getLocation(location, reference);
        if (dependencyLocation != null) {
            return Optional.fromNullable((Object)this.getN4JSProject(dependencyLocation));
        }
        if (includeAbsentProjects) {
            return Optional.fromNullable((Object)this.newAbsentProject(reference.getProjectName()));
        }
        return Optional.absent();
    }

    protected IN4JSProject newAbsentProject(String projectName) {
        URI absent = URI.createFileURI((String)projectName);
        return new N4JSProject(absent, false, this);
    }

    public Collection<IN4JSProject> resolveProjectReferences(IN4JSProject project, Iterable<? extends ProjectReference> references, boolean includeAbsentProjects) {
        if (project == null || references == null || Iterables.isEmpty(references)) {
            return Collections.emptyList();
        }
        LinkedList<IN4JSProject> resolvedReferences = new LinkedList<IN4JSProject>();
        for (ProjectReference projectReference : references) {
            IN4JSProject projectReference2 = (IN4JSProject)this.resolveProjectReference(project, projectReference, includeAbsentProjects).orNull();
            if (projectReference2 == null) continue;
            resolvedReferences.add(projectReference2);
        }
        return resolvedReferences;
    }

    public String getDefinesPackage(IN4JSProject project) {
        if (project == null) {
            return null;
        }
        ProjectDescription projectDescription = this.getProjectDescription(project.getLocation());
        if (projectDescription != null) {
            return projectDescription.getDefinesPackage();
        }
        return null;
    }

    public boolean isUseES6Imports(IN4JSProject project) {
        if (project == null) {
            return false;
        }
        ProjectDescription projectDescription = this.getProjectDescription(project.getLocation());
        if (projectDescription != null) {
            return projectDescription.isUseES6Imports();
        }
        return false;
    }

    public Iterable<IN4JSProject> getSortedDependencies(IN4JSProject project) {
        SortedDependenciesProvider sdProvider = new SortedDependenciesProvider(project);
        Iterable<IN4JSProject> existing = this.cache.get(sdProvider, "SORTED_DEPENDENCIES", project.getLocation());
        return existing;
    }

    private class SortedDependenciesProvider
    implements MultiCleartriggerCache.CleartriggerSupplier<Iterable<IN4JSProject>> {
        final IN4JSProject project;
        private Iterable<IN4JSProject> sortedDeps;

        SortedDependenciesProvider(IN4JSProject project) {
            this.project = project;
        }

        @Override
        public Iterable<IN4JSProject> get() {
            this.computeIfNull();
            return this.sortedDeps;
        }

        private void computeIfNull() {
            if (this.sortedDeps != null) {
                return;
            }
            this.sortedDeps = TypeDefinitionsAwareDependenciesSupplier.get(this.project);
        }

        @Override
        public Collection<URI> getCleartriggers() {
            this.computeIfNull();
            HashSet<URI> triggerURIs = new HashSet<URI>();
            for (IN4JSProject dep : this.sortedDeps) {
                if (dep.getDefinesPackageName() == null) continue;
                URI uri = dep.getLocation();
                triggerURIs.add(uri);
            }
            return triggerURIs;
        }
    }
}

