/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.typesbuilder;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.AnnotationDefinition;
import org.eclipse.n4js.n4JS.FunctionDeclaration;
import org.eclipse.n4js.ts.typeRefs.StructuralTypeRef;
import org.eclipse.n4js.ts.typeRefs.TypeRef;
import org.eclipse.n4js.ts.types.TAnnotableElement;
import org.eclipse.n4js.ts.types.TAnnotation;
import org.eclipse.n4js.ts.types.TAnnotationArgument;
import org.eclipse.n4js.ts.types.TFormalParameter;
import org.eclipse.n4js.ts.types.TMigration;
import org.eclipse.n4js.ts.types.TStructField;
import org.eclipse.n4js.ts.types.TypesFactory;
import org.eclipse.n4js.ts.versions.VersionableUtils;
import org.eclipse.n4js.utils.Log;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Log
public class N4IDLMigrationTypesBuilder {
    private static final Logger logger = Logger.getLogger(N4IDLMigrationTypesBuilder.class);

    public void initialiseTMigration(FunctionDeclaration functionDecl, TMigration tMigration, boolean preLinkingPhase) {
        int _length;
        boolean _equals;
        TAnnotation migrationAnno = AnnotationDefinition.MIGRATION.getAnnotation((TAnnotableElement)tMigration);
        if (!preLinkingPhase) {
            tMigration.getSourceTypeRefs().addAll(N4IDLMigrationTypesBuilder.computeSourceTypeRefs(tMigration));
            tMigration.getTargetTypeRefs().addAll(N4IDLMigrationTypesBuilder.computeTargetTypeRefs(tMigration));
        }
        boolean bl = _equals = (_length = ((Object[])Conversions.unwrapArray((Object)migrationAnno.getArgs(), Object.class)).length) == 2;
        if (_equals) {
            try {
                Integer sourceVersion = Integer.parseInt(((TAnnotationArgument)migrationAnno.getArgs().get(0)).getArgAsString());
                Integer targetVersion = Integer.parseInt(((TAnnotationArgument)migrationAnno.getArgs().get(1)).getArgAsString());
                tMigration.setSourceVersion(sourceVersion.intValue());
                tMigration.setTargetVersion(targetVersion.intValue());
                tMigration.setHasDeclaredSourceAndTargetVersion(true);
            }
            catch (Throwable _t) {
                if (_t instanceof NumberFormatException) {
                    NumberFormatException e = (NumberFormatException)_t;
                    String _name = tMigration.getName();
                    String _plus = "Failed to infer source/target version for migration " + _name;
                    String _plus_1 = String.valueOf(_plus) + " in file ";
                    URI _uRI = tMigration.eResource().getURI();
                    String _plus_2 = String.valueOf(_plus_1) + _uRI;
                    logger.error((Object)_plus_2, (Throwable)e);
                    tMigration.setSourceVersion(0);
                    tMigration.setSourceVersion(0);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        } else {
            tMigration.setSourceVersion(N4IDLMigrationTypesBuilder.computeVersion((List<TypeRef>)tMigration.getSourceTypeRefs()));
            tMigration.setTargetVersion(N4IDLMigrationTypesBuilder.computeVersion((List<TypeRef>)tMigration.getTargetTypeRefs()));
            tMigration.setHasDeclaredSourceAndTargetVersion(false);
        }
    }

    public TMigration createTMigration() {
        return TypesFactory.eINSTANCE.createTMigration();
    }

    private static List<TypeRef> computeSourceTypeRefs(TMigration migration) {
        boolean _tripleEquals;
        EList _fpars = migration.getFpars();
        boolean bl = _tripleEquals = _fpars == null;
        if (_tripleEquals) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        if (!migration.getFpars().isEmpty() && ((TFormalParameter)IterableExtensions.head((Iterable)migration.getFpars())).getName() == null) {
            return Collections.unmodifiableList(CollectionLiterals.newArrayList());
        }
        Functions.Function1 _function = fpar -> fpar.getTypeRef();
        return IterableExtensions.toList((Iterable)ListExtensions.map((List)migration.getFpars(), (Functions.Function1)_function));
    }

    private static List<TypeRef> computeTargetTypeRefs(TMigration migration) {
        boolean _tripleEquals;
        TypeRef returnTypeRef = migration.getReturnTypeRef();
        if (returnTypeRef == null) {
            return CollectionLiterals.emptyList();
        }
        if (returnTypeRef instanceof StructuralTypeRef) {
            Functions.Function1 _function = f -> f.getTypeRef();
            return IterableExtensions.toList((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)Iterables.filter((Iterable)migration.getReturnTypeRef().getStructuralMembers(), TStructField.class), (Functions.Function1)_function)));
        }
        TypeRef _returnTypeRef = migration.getReturnTypeRef();
        boolean bl = _tripleEquals = _returnTypeRef == null;
        if (_tripleEquals) {
            return CollectionLiterals.emptyList();
        }
        TypeRef _returnTypeRef_1 = migration.getReturnTypeRef();
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TypeRef[]{_returnTypeRef_1}));
    }

    private static int computeVersion(List<TypeRef> typeRefs) {
        return VersionableUtils.getVersion(typeRefs);
    }
}

