/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.text.BreakIterator;
import java.util.Iterator;
import java.util.Locale;
import org.apache.lucene.analysis.cn.smart.WordSegmenter;
import org.apache.lucene.analysis.cn.smart.hhmm.SegToken;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.analysis.util.SegmentingTokenizerBase;
import org.apache.lucene.util.AttributeFactory;

public class HMMChineseTokenizer
extends SegmentingTokenizerBase {
    private static final BreakIterator sentenceProto = BreakIterator.getSentenceInstance(Locale.ROOT);
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final WordSegmenter wordSegmenter = new WordSegmenter();
    private Iterator<SegToken> tokens;

    public HMMChineseTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
    }

    public HMMChineseTokenizer(AttributeFactory factory) {
        super(factory, (BreakIterator)sentenceProto.clone());
    }

    protected void setNextSentence(int sentenceStart, int sentenceEnd) {
        String sentence = new String(this.buffer, sentenceStart, sentenceEnd - sentenceStart);
        this.tokens = this.wordSegmenter.segmentSentence(sentence, this.offset + sentenceStart).iterator();
    }

    protected boolean incrementWord() {
        if (this.tokens == null || !this.tokens.hasNext()) {
            return false;
        }
        SegToken token = this.tokens.next();
        this.clearAttributes();
        this.termAtt.copyBuffer(token.charArray, 0, token.charArray.length);
        this.offsetAtt.setOffset(this.correctOffset(token.startOffset), this.correctOffset(token.endOffset));
        this.typeAtt.setType("word");
        return true;
    }

    public void reset() throws IOException {
        super.reset();
        this.tokens = null;
    }
}

