/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.editor;

import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ui.editor.StyledTextDescriptor;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextPresentationReconciler;
import org.eclipse.xtext.ui.editor.model.ITokenTypeToPartitionTypeMapper;
import org.eclipse.xtext.ui.editor.model.XtextDocumentProvider;
import org.eclipse.xtext.util.ITextRegion;

public class EditorContentExtractor {
    private static final Logger LOGGER = Logger.getLogger(EditorContentExtractor.class);
    private static final String TEXT_FONT_ID = "org.eclipse.jface.textfont";
    @Inject
    private IN4JSCore core;
    @Inject
    private XtextDocumentProvider docProvider;
    @Inject
    private XtextPresentationReconciler reconciler;
    @Inject
    private ITokenTypeToPartitionTypeMapper partitionTypeMapper;
    @Inject
    private Provider<IPresentationDamager> damagerProvider;
    @Inject
    private Provider<IPresentationRepairer> repairerProvider;
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    public Optional<StyledTextDescriptor> getDescriptorForSemanticElement(URI uri) {
        Optional<TModule> optModule = this.loadTModuleFromURI(uri);
        if (!optModule.isPresent()) {
            return Optional.absent();
        }
        TModule module = (TModule)optModule.get();
        URI moduleUri = module.eResource().getURI();
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(moduleUri.toPlatformString(true)));
        if (file == null || !file.exists()) {
            return Optional.absent();
        }
        FileEditorInput editorInput = new FileEditorInput(file);
        try {
            this.docProvider.connect((Object)editorInput);
        }
        catch (CoreException e) {
            LOGGER.error((Object)("Error while connecting editor input with document provider: " + (Object)((Object)e)));
            return Optional.absent();
        }
        IDocument doc = this.docProvider.getDocument((Object)editorInput);
        if (doc == null) {
            return Optional.absent();
        }
        XtextResource xtextResource = (XtextResource)module.eResource();
        ResourceSet resourceSet = xtextResource.getResourceSet();
        EObject object = resourceSet.getEObject(uri, true);
        if (object == null) {
            return Optional.absent();
        }
        ITextRegion textRegion = this.locationInFileProvider.getFullTextRegion(object);
        if (textRegion == null) {
            return Optional.absent();
        }
        try {
            int lineOffset;
            int lineOfOffset = doc.getLineOfOffset(textRegion.getOffset());
            int offset = lineOffset = doc.getLineOffset(lineOfOffset);
            int length = textRegion.getLength() + (textRegion.getOffset() - lineOffset);
            String text = doc.get(offset, length);
            IPresentationRepairer repairer = (IPresentationRepairer)this.repairerProvider.get();
            IPresentationDamager damager = (IPresentationDamager)this.damagerProvider.get();
            String[] stringArray = this.partitionTypeMapper.getSupportedPartitionTypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                this.reconciler.setRepairer(repairer, contentType);
                repairer.setDocument(doc);
                this.reconciler.setDamager(damager, contentType);
                damager.setDocument(doc);
                ++n2;
            }
            Region region = new Region(offset, length);
            TextPresentation textPresentation = this.reconciler.createRepairDescription((IRegion)region, doc);
            Iterator rangeItr = textPresentation.getAllStyleRangeIterator();
            LinkedList ranges = Lists.newLinkedList();
            while (rangeItr.hasNext()) {
                Object next = rangeItr.next();
                if (!(next instanceof StyleRange)) continue;
                ranges.add((StyleRange)next);
            }
            Range textRange = Range.closed((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + length));
            Iterator itr = ranges.iterator();
            while (itr.hasNext()) {
                StyleRange range = (StyleRange)itr.next();
                if (!textRange.contains((Comparable)Integer.valueOf(range.start)) || !textRange.contains((Comparable)Integer.valueOf(range.start + range.length))) {
                    itr.remove();
                    continue;
                }
                range.start -= offset;
            }
            return Optional.fromNullable((Object)new StyledTextDescriptorImpl(text, ranges));
        }
        catch (BadLocationException e) {
            LOGGER.error((Object)"Error while trying to extract text from document.", (Throwable)e);
            return Optional.absent();
        }
    }

    private Optional<TModule> loadTModuleFromURI(URI uri) {
        if (uri == null) {
            return Optional.absent();
        }
        URI trimmedUri = uri.hasFragment() ? uri.trimFragment() : uri;
        IN4JSProject project = (IN4JSProject)this.core.findProject(trimmedUri).orNull();
        if (project == null) {
            return Optional.absent();
        }
        ResourceSet resSet = this.core.createResourceSet(Optional.of((Object)project));
        IResourceDescriptions index = this.core.getXtextIndex(resSet);
        IResourceDescription resDesc = index.getResourceDescription(trimmedUri);
        if (resDesc == null) {
            return Optional.absent();
        }
        TModule module = this.core.loadModuleFromIndex(resSet, resDesc, false);
        if (module == null || module.eResource() == null || module.eResource().getResourceSet() == null) {
            return Optional.absent();
        }
        return Optional.of((Object)module);
    }

    private static final class StyledTextDescriptorImpl
    implements StyledTextDescriptor {
        private final String text;
        private final StyleRange[] ranges;
        private final Font font;

        private StyledTextDescriptorImpl(String text, Iterable<StyleRange> ranges) {
            this.text = text;
            this.ranges = (StyleRange[])Iterables.toArray(ranges, StyleRange.class);
            this.font = this.getTextFont();
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public StyleRange[] getRanges() {
            if (this.ranges == null) {
                return null;
            }
            StyleRange[] copy = new StyleRange[this.ranges.length];
            System.arraycopy(this.ranges, 0, copy, 0, this.ranges.length);
            return copy;
        }

        @Override
        public Font getFont() {
            return this.font;
        }

        private Font getTextFont() {
            ITheme theme = PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
            return theme.getFontRegistry().get(EditorContentExtractor.TEXT_FONT_ID);
        }
    }
}

