/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.wizard.workspace;

import java.beans.PropertyChangeListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.utils.beans.PropertyChangeSupport;
import org.eclipse.xtext.xbase.lib.Pure;

@PropertyChangeSupport
public class WorkspaceWizardModel {
    private IPath project = new Path("");
    private IPath sourceFolder = new Path("");
    private String moduleSpecifier = "";
    private final java.beans.PropertyChangeSupport _propertyChangeSupport = new java.beans.PropertyChangeSupport(this);
    public static final String PROJECT_PROPERTY = "project";
    public static final String SOURCE_FOLDER_PROPERTY = "sourceFolder";
    public static final String MODULE_SPECIFIER_PROPERTY = "moduleSpecifier";

    public static String populateModelFromInitialSelection(WorkspaceWizardModel model, IStructuredSelection selection, boolean extractModuleFile, IN4JSCore n4jsCore) {
        String _xblockexpression = null;
        Object firstElement = selection.getFirstElement();
        String _xifexpression = null;
        if (firstElement instanceof IResource) {
            String _xblockexpression_1 = null;
            IPath path = ((IResource)firstElement).getFullPath();
            if (firstElement instanceof IFile) {
                path = path.removeLastSegments(1);
            }
            URI rootURI = URI.createURI((String)"platform:/resource/");
            URI pathURI = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
            IN4JSProject n4jsProject = (IN4JSProject)n4jsCore.findProject(pathURI).orNull();
            String _xifexpression_1 = null;
            if (n4jsProject != null && n4jsProject.exists()) {
                boolean _not;
                String _xblockexpression_2 = null;
                URI projectUri = n4jsProject.getLocation();
                String _string = projectUri.deresolve(rootURI).toString();
                Path projectPath = new Path(_string);
                model.setProject((IPath)projectPath);
                String _xifexpression_2 = null;
                boolean _equals = pathURI.equals(projectUri);
                boolean bl = _not = !_equals;
                if (_not) {
                    String _xblockexpression_3 = null;
                    IN4JSSourceContainer sourceFolder = (IN4JSSourceContainer)n4jsCore.findN4JSSourceContainer(pathURI).orNull();
                    String _xifexpression_3 = null;
                    if (sourceFolder != null) {
                        boolean _not_1;
                        String _xblockexpression_4 = null;
                        String sourceFolderPath = sourceFolder.getRelativeLocation();
                        Path _path = new Path(sourceFolderPath);
                        model.setSourceFolder((IPath)_path);
                        String _string_1 = sourceFolder.getLocation().deresolve(rootURI).toString();
                        Path sourceFolderURI = new Path(_string_1);
                        String _string_2 = pathURI.deresolve(rootURI).toString();
                        Path moduleSpecifierPath = new Path(_string_2);
                        String moduleSpecifier = moduleSpecifierPath.makeRelativeTo((IPath)sourceFolderURI).toString();
                        boolean _isEmpty = moduleSpecifier.isEmpty();
                        boolean bl2 = _not_1 = !_isEmpty;
                        if (_not_1) {
                            model.setModuleSpecifier(String.valueOf(moduleSpecifier) + "/");
                        }
                        String _xifexpression_4 = null;
                        if (extractModuleFile && firstElement instanceof IFile) {
                            String _plus;
                            String _lastSegment = ((IResource)firstElement).getFullPath().removeFileExtension().lastSegment();
                            _xifexpression_4 = model.moduleSpecifier = (_plus = String.valueOf(model.moduleSpecifier) + _lastSegment);
                        }
                        _xifexpression_3 = _xblockexpression_4 = _xifexpression_4;
                    }
                    _xifexpression_2 = _xblockexpression_3 = _xifexpression_3;
                }
                _xifexpression_1 = _xblockexpression_2 = _xifexpression_2;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    protected final java.beans.PropertyChangeSupport internalGetPropertyChangeSupport() {
        return this._propertyChangeSupport;
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        this.internalGetPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.internalGetPropertyChangeSupport().removePropertyChangeListener(listener);
    }

    @Pure
    public IPath getProject() {
        return this.project;
    }

    public void setProject(IPath project) {
        this.project = project;
        this.internalGetPropertyChangeSupport().firePropertyChange(PROJECT_PROPERTY, this.project, this.project);
    }

    @Pure
    public IPath getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(IPath sourceFolder) {
        this.sourceFolder = sourceFolder;
        this.internalGetPropertyChangeSupport().firePropertyChange(SOURCE_FOLDER_PROPERTY, this.sourceFolder, this.sourceFolder);
    }

    @Pure
    public String getModuleSpecifier() {
        return this.moduleSpecifier;
    }

    public void setModuleSpecifier(String moduleSpecifier) {
        this.moduleSpecifier = moduleSpecifier;
        this.internalGetPropertyChangeSupport().firePropertyChange(MODULE_SPECIFIER_PROPERTY, this.moduleSpecifier, this.moduleSpecifier);
    }
}

