/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.registry;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.xpect.registry.IEmfFileExtensionInfo;
import org.eclipse.xpect.registry.ILanguageInfo;

public abstract class AbstractLanguageInfo
implements ILanguageInfo {
    private final IEmfFileExtensionInfo.IXtextFileExtensionInfo info;
    protected Injector injector;
    protected Map<List<Class<? extends Module>>, Injector> injectors = Maps.newHashMap();
    protected Module runtimeModule = null;
    protected Module sharedModule = null;
    protected Module uiModule = null;

    public AbstractLanguageInfo(IEmfFileExtensionInfo.IXtextFileExtensionInfo info) {
        this.info = info;
    }

    protected abstract Injector createInjector(Module ... var1);

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return this.info.getLanguageID().equals(((AbstractLanguageInfo)obj).info.getLanguageID());
    }

    @Override
    public Set<String> getFileExtensions() {
        return this.info.getFileExtensions();
    }

    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            this.injector = this.createInjector(new Module[0]);
        }
        return this.injector;
    }

    @Override
    public Injector getInjector(List<Class<? extends Module>> moduleClasses) {
        if (moduleClasses.isEmpty()) {
            return this.getInjector();
        }
        ImmutableList key = ImmutableList.copyOf(moduleClasses);
        Injector result = this.injectors.get(key);
        if (result != null) {
            return result;
        }
        Injector defaultInjector = this.getInjector();
        Module[] modules = new Module[moduleClasses.size()];
        int i = 0;
        while (i < moduleClasses.size()) {
            modules[i] = (Module)defaultInjector.getInstance(moduleClasses.get(i));
            ++i;
        }
        result = this.createInjector(modules);
        this.injectors.put((List<Class<? extends Module>>)key, result);
        return result;
    }

    @Override
    public String getLanguageName() {
        return this.info.getLanguageID();
    }

    protected Module getRuntimeModule() {
        if (this.runtimeModule == null) {
            try {
                Class<? extends Module> clazz = this.getRuntimeModuleClass();
                this.runtimeModule = clazz.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.runtimeModule;
    }

    @Override
    public Class<? extends Module> getRuntimeModuleClass() {
        return this.info.getRuntimeModule().load();
    }

    protected Module getSharedStateModule() {
        if (this.sharedModule == null) {
            Class<Module> module = this.info.getSharedModule().load();
            try {
                this.sharedModule = module.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return this.sharedModule;
    }

    public String getUiLangName() {
        return this.info.getUIModule().getName();
    }

    @Override
    public Class<? extends Module> getUIModuleClass() {
        return this.info.getUIModule().load();
    }

    public int hashCode() {
        return this.info.getLanguageID().hashCode();
    }
}

