/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.semver;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.n4js.semver.Semver.NPMVersionRequirement;
import org.eclipse.n4js.semver.Semver.Qualifier;
import org.eclipse.n4js.semver.Semver.QualifierTag;
import org.eclipse.n4js.semver.Semver.SemverFactory;
import org.eclipse.n4js.semver.Semver.SimpleVersion;
import org.eclipse.n4js.semver.Semver.VersionComparator;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.n4js.semver.Semver.VersionPart;
import org.eclipse.n4js.semver.Semver.VersionRange;
import org.eclipse.n4js.semver.Semver.VersionRangeConstraint;
import org.eclipse.n4js.semver.Semver.VersionRangeSetRequirement;
import org.eclipse.n4js.semver.SemverMatcher;

public class SemverUtils {
    static VersionNumberDescriptor getVersionNumberDescriptor(VersionNumber vn) {
        String[] preReleaseParts = null;
        String[] buildMetadataParts = null;
        Qualifier svQualifier = vn.getQualifier();
        if (svQualifier != null && svQualifier.getPreRelease() != null) {
            EList prParts = svQualifier.getPreRelease().getParts();
            preReleaseParts = (String[])prParts.toArray((Object[])new String[prParts.size()]);
        }
        if (svQualifier != null && svQualifier.getBuildMetadata() != null) {
            EList bmParts = svQualifier.getBuildMetadata().getParts();
            buildMetadataParts = (String[])bmParts.toArray((Object[])new String[bmParts.size()]);
        }
        VersionPart major = vn.getMajor();
        VersionPart minor = vn.getMinor();
        VersionPart patch = vn.getPatch();
        return new VersionNumberDescriptor(major, minor, patch, preReleaseParts, buildMetadataParts);
    }

    static VersionNumber createVersionNumber(VersionNumberDescriptor descriptor) {
        VersionNumber versNumber = SemverFactory.eINSTANCE.createVersionNumber();
        VersionPart fromMajor = SemverFactory.eINSTANCE.createVersionPart();
        fromMajor.setNumberRaw(descriptor.major);
        versNumber.setMajor(fromMajor);
        if (descriptor.minor != null) {
            VersionPart fromMinor = SemverFactory.eINSTANCE.createVersionPart();
            fromMinor.setNumberRaw(descriptor.minor);
            versNumber.setMinor(fromMinor);
        }
        if (descriptor.patch != null) {
            VersionPart fromPatch = SemverFactory.eINSTANCE.createVersionPart();
            fromPatch.setNumberRaw(descriptor.patch);
            versNumber.setPatch(fromPatch);
        }
        if (descriptor.preReleaseParts != null || descriptor.buildMetadataParts != null) {
            Qualifier qualifier = SemverFactory.eINSTANCE.createQualifier();
            versNumber.setQualifier(qualifier);
            if (descriptor.preReleaseParts != null) {
                QualifierTag prQualifierTag = SemverFactory.eINSTANCE.createQualifierTag();
                prQualifierTag.getParts().addAll(Arrays.asList(descriptor.preReleaseParts));
                qualifier.setPreRelease(prQualifierTag);
            }
            if (descriptor.buildMetadataParts != null) {
                QualifierTag bmQualifierTag = SemverFactory.eINSTANCE.createQualifierTag();
                bmQualifierTag.getParts().addAll(Arrays.asList(descriptor.buildMetadataParts));
                qualifier.setBuildMetadata(bmQualifierTag);
            }
        }
        return versNumber;
    }

    public static VersionNumber createVersionNumber(Integer major, Integer minor, Integer patch, String preRelease, String buildMetadata) {
        String[] preReleaseParts = Strings.isNullOrEmpty((String)preRelease) ? null : preRelease.split("\\.");
        String[] buildMetadataParts = Strings.isNullOrEmpty((String)buildMetadata) ? null : buildMetadata.split("\\.");
        return SemverUtils.createVersionNumber(major, minor, patch, preReleaseParts, buildMetadataParts);
    }

    public static VersionNumber createVersionNumber(Integer major, Integer minor, Integer patch, String[] preReleaseParts, String[] buildMetadataParts) {
        VersionNumberDescriptor vnd = new VersionNumberDescriptor(major, minor, patch, preReleaseParts, buildMetadataParts);
        return SemverUtils.createVersionNumber(vnd);
    }

    public static VersionNumber createVersionNumber(Integer major, Integer minor, Integer patch) {
        VersionNumberDescriptor vnd = new VersionNumberDescriptor(major, minor, patch);
        return SemverUtils.createVersionNumber(vnd);
    }

    public static VersionRangeSetRequirement createVersionRangeSet(VersionComparator comparator, Integer major, Integer minor, Integer patch) {
        VersionNumberDescriptor vnd = new VersionNumberDescriptor(major, minor, patch);
        VersionNumber versionNumber = SemverUtils.createVersionNumber(vnd);
        return SemverUtils.createVersionRangeSet(comparator, versionNumber);
    }

    public static VersionRangeSetRequirement createVersionRangeSet(VersionComparator comparator, VersionNumber version) {
        VersionNumber versionNumber = SemverUtils.copyVersionNumber(version);
        SimpleVersion simpleVersion = SemverFactory.eINSTANCE.createSimpleVersion();
        simpleVersion.setNumber(versionNumber);
        simpleVersion.getComparators().add((Object)comparator);
        VersionRangeConstraint versionRangeConstraint = SemverFactory.eINSTANCE.createVersionRangeConstraint();
        versionRangeConstraint.getVersionConstraints().add((Object)simpleVersion);
        VersionRangeSetRequirement versionRangeSet = SemverFactory.eINSTANCE.createVersionRangeSetRequirement();
        versionRangeSet.getRanges().add((Object)versionRangeConstraint);
        return versionRangeSet;
    }

    public static NPMVersionRequirement createEmptyVersionRequirement() {
        return SemverFactory.eINSTANCE.createVersionRangeSetRequirement();
    }

    public static boolean isEmptyVersionRequirement(NPMVersionRequirement versionRequirement) {
        return versionRequirement instanceof VersionRangeSetRequirement && ((VersionRangeSetRequirement)versionRequirement).getRanges().isEmpty();
    }

    public static boolean isWildcardVersionRequirement(NPMVersionRequirement versionRequirement) {
        if (versionRequirement instanceof VersionRangeSetRequirement) {
            SimpleVersion simple;
            EList ranges = ((VersionRangeSetRequirement)versionRequirement).getRanges();
            VersionRange range = ranges.size() == 1 ? (VersionRange)ranges.get(0) : null;
            EList constraints = range instanceof VersionRangeConstraint ? ((VersionRangeConstraint)range).getVersionConstraints() : Collections.emptyList();
            SimpleVersion simpleVersion = simple = constraints.size() == 1 ? (SimpleVersion)constraints.get(0) : null;
            if (simple != null) {
                return simple.isWildcard();
            }
        }
        return false;
    }

    public static VersionNumber copyVersionNumber(VersionNumber version) {
        VersionNumberDescriptor vnd = SemverUtils.getVersionNumberDescriptor(version);
        VersionNumber versionNumber = SemverUtils.createVersionNumber(vnd);
        return versionNumber;
    }

    public static VersionNumber findClosestMatching(Collection<VersionNumber> versions, VersionNumber toFind) {
        if (versions == null || versions.isEmpty()) {
            return null;
        }
        if (toFind == null) {
            return null;
        }
        ArrayList<VersionNumber> sortedVersions = new ArrayList<VersionNumber>(versions);
        Collections.sort(sortedVersions, SemverMatcher::compareLoose);
        int index = Collections.binarySearch(sortedVersions, toFind, SemverMatcher::compareLoose);
        if (index > 0) {
            return (VersionNumber)sortedVersions.get(index);
        }
        VersionNumber current = null;
        for (VersionNumber v : sortedVersions) {
            SemverMatcher.VersionNumberRelation relation = SemverMatcher.relation(toFind, v);
            if (!relation.isGreaterOrEqual()) continue;
            current = v;
        }
        return current;
    }

    static class VersionNumberDescriptor {
        final Integer major;
        final Integer minor;
        final Integer patch;
        final boolean majorIsWildcard;
        final boolean minorIsWildcard;
        final boolean patchIsWildcard;
        final String[] preReleaseParts;
        final String[] buildMetadataParts;

        VersionNumberDescriptor(Integer major, Integer minor, Integer patch) {
            this(major, minor, patch, null, null);
        }

        VersionNumberDescriptor(Integer major, Integer minor, Integer patch, String[] preReleaseParts, String[] buildMetadataParts) {
            this.major = major;
            this.minor = minor;
            this.patch = patch;
            this.majorIsWildcard = false;
            this.minorIsWildcard = false;
            this.patchIsWildcard = false;
            this.preReleaseParts = preReleaseParts;
            this.buildMetadataParts = buildMetadataParts;
        }

        VersionNumberDescriptor(VersionPart major, VersionPart minor, VersionPart patch, String[] preReleaseParts, String[] buildMetadataParts) {
            this.major = major != null && !major.isWildcard() ? major.getNumber() : null;
            this.minor = minor != null && !minor.isWildcard() ? minor.getNumber() : null;
            this.patch = patch != null && !patch.isWildcard() ? patch.getNumber() : null;
            this.majorIsWildcard = major == null ? false : major.isWildcard();
            this.minorIsWildcard = minor == null ? false : minor.isWildcard();
            this.patchIsWildcard = patch == null ? false : patch.isWildcard();
            this.preReleaseParts = this.hasWildcard() ? null : preReleaseParts;
            this.buildMetadataParts = this.hasWildcard() ? null : buildMetadataParts;
        }

        boolean hasWildcard() {
            return this.majorIsWildcard || this.minorIsWildcard || this.patchIsWildcard;
        }

        VersionNumberDescriptor getTildeUpperBound() {
            if (this.minor != null) {
                return new VersionNumberDescriptor(this.major, this.minor + 1, null, null, null);
            }
            return new VersionNumberDescriptor(this.major + 1, null, null, null, null);
        }

        VersionNumberDescriptor getCaretUpperBound() {
            if (this.major != 0 || this.minorIsWildcard || this.minor == null) {
                return new VersionNumberDescriptor(this.major + 1, null, null, null, null);
            }
            if (this.minor != 0 || this.patchIsWildcard || this.patch == null) {
                return new VersionNumberDescriptor(this.major, this.minor + 1, null, null, null);
            }
            return new VersionNumberDescriptor(this.major, this.minor, this.patch + 1, null, null);
        }
    }
}

