/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.viewer;

import com.google.common.base.Preconditions;
import java.util.List;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class ColumnViewerBuilder<CV extends ColumnViewer, CP extends IContentProvider> {
    private static final int DEFAULT_COLUMN_WIDTH_IN_PIXEL = 100;
    final List<String> columnLabels;
    private final CP contentProvider;
    boolean moveable;
    boolean headerVisible;
    boolean linesVisible;
    boolean useHashlookup;
    private boolean resizable;
    private boolean hasBorder;
    private boolean multipleSelection;
    private boolean fullSelection;
    private List<Integer> columnWeights;
    private List<Integer> columnWidthsInPixels;
    private IBaseLabelProvider labelProvider;

    public final CV build(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(4, 4).create());
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).align(4, 4).create());
        AbstractColumnLayout layout = this.createColumnLayout();
        composite.setLayout((Layout)layout);
        CV viewer = this.createViewer(composite, layout, 0x300 | this.getStyle());
        viewer.setContentProvider(this.contentProvider);
        viewer.setLabelProvider(this.labelProvider);
        viewer.setUseHashlookup(this.useHashlookup);
        return viewer;
    }

    protected abstract CV createViewer(Composite var1, AbstractColumnLayout var2, int var3);

    protected abstract AbstractColumnLayout createColumnLayout();

    protected ColumnViewerBuilder(List<String> columnLabels, CP contentProvider) {
        this.columnLabels = (List)Preconditions.checkNotNull(columnLabels, (Object)"columnLabels");
        this.contentProvider = (IContentProvider)Preconditions.checkNotNull(contentProvider, (Object)"contentProvider");
        Preconditions.checkArgument((!this.columnLabels.isEmpty() ? 1 : 0) != 0, (Object)"Empty column labels are not allowed. At least one column should be specified.");
        this.headerVisible = true;
        this.linesVisible = true;
        this.useHashlookup = false;
        this.labelProvider = new LabelProvider();
        this.multipleSelection = false;
        this.fullSelection = true;
        this.resizable = true;
        this.hasBorder = false;
        this.moveable = true;
    }

    public ColumnViewerBuilder<CV, CP> setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setMovable(boolean movable) {
        this.moveable = movable;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setResizable(boolean resizable) {
        this.resizable = resizable;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setHeaderVisible(boolean headerVisible) {
        this.headerVisible = headerVisible;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setLinesVisible(boolean linesVisible) {
        this.linesVisible = linesVisible;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setUseHashlookup(boolean useHashlookup) {
        this.useHashlookup = useHashlookup;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setMultipleSelection(boolean multipleSelection) {
        this.multipleSelection = multipleSelection;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setFullSelection(boolean fullSelection) {
        this.fullSelection = fullSelection;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setColumnWeights(List<Integer> columnWeights) {
        this.columnWeights = columnWeights;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setColumnWidthsInPixel(List<Integer> columnWidthsInPixel) {
        this.columnWidthsInPixels = columnWidthsInPixel;
        return this;
    }

    public ColumnViewerBuilder<CV, CP> setLabelProvider(IBaseLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
        return this;
    }

    protected ColumnLayoutData createColumnLayoutData(int columnIndex) {
        if (this.columnWeights == null) {
            return new ColumnPixelData(this.getColumnWidthInPixel(columnIndex), this.resizable);
        }
        return new ColumnWeightData(this.columnWeights.get(columnIndex).intValue(), 20, this.resizable);
    }

    private int getColumnWidthInPixel(int columnIndex) {
        return this.columnWidthsInPixels == null ? 100 : this.columnWidthsInPixels.get(columnIndex);
    }

    private int getStyle() {
        int style = 0;
        if (this.multipleSelection) {
            style |= 2;
        }
        if (this.fullSelection) {
            style |= 0x10000;
        }
        if (this.hasBorder) {
            style |= 0x800;
        }
        return style;
    }
}

