/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.runner.internal;

import com.google.inject.Inject;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.external.ExternalLibraryHelper;
import org.eclipse.n4js.external.libraries.ShippedCodeAccess;
import org.eclipse.n4js.internal.FileBasedWorkspace;
import org.eclipse.n4js.internal.InternalN4JSWorkspace;
import org.eclipse.n4js.internal.N4JSModel;
import org.eclipse.n4js.projectModel.IN4JSProject;
import org.eclipse.n4js.utils.ProjectDescriptionLoader;
import org.eclipse.n4js.utils.URIUtils;

public class RunnerN4JSCore {
    private static final Logger LOGGER = Logger.getLogger(RunnerN4JSCore.class);
    @Inject
    private ProjectDescriptionLoader projectDescriptionLoader;
    @Inject
    private ExternalLibraryHelper externalLibraryHelper;

    public Iterable<IN4JSProject> getAllShippedProjects() {
        FileBasedWorkspace workspace = new FileBasedWorkspace(this.projectDescriptionLoader);
        N4JSModel model = new N4JSModel((InternalN4JSWorkspace)workspace);
        ShippedCodeAccess.getAllShippedPaths().forEach(path -> this.discoverProjects((String)path, workspace));
        ArrayList<IN4JSProject> projects = new ArrayList<IN4JSProject>();
        workspace.getAllProjectLocationsIterator().forEachRemaining(location -> {
            boolean bl = projects.add((IN4JSProject)model.getN4JSProject(location));
        });
        return projects;
    }

    private void discoverProjects(String rootLocation, FileBasedWorkspace workspace) {
        File root = new File(rootLocation);
        Arrays.asList(root.listFiles()).stream().filter(File::isDirectory).forEach(projectDir -> {
            if (this.externalLibraryHelper.isExternalProjectDirectory(projectDir)) {
                URI createURI = URIUtils.deriveProjectURIFromFileLocation((File)projectDir);
                workspace.registerProject(createURI);
            } else {
                LOGGER.warn((Object)("Cannot locate project description file (i.e. package.json) file at " + projectDir.getAbsolutePath()));
            }
        });
    }
}

