/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.organize.imports;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Predicate;
import org.eclipse.core.resources.IFile;
import org.eclipse.n4js.fileextensions.FileExtensionType;
import org.eclipse.n4js.fileextensions.FileExtensionsRegistry;
import org.eclipse.n4js.utils.Lazy;

public class FileExtensionFilter
implements Predicate<IFile> {
    private final Lazy<Collection<String>> n4FileExtensions = Lazy.create(() -> FileExtensionFilter.getN4FileExtensions(fileExtensionsRegistry));

    @Inject
    public FileExtensionFilter(FileExtensionsRegistry fileExtensionsRegistry) {
    }

    @Override
    public boolean test(IFile iFile) {
        String fileExtension = iFile.getFileExtension();
        return fileExtension != null && ((Collection)this.n4FileExtensions.get()).contains(fileExtension);
    }

    private static Collection<String> getN4FileExtensions(FileExtensionsRegistry fileExtensionsRegistry) {
        HashSet<String> n4FileExtensions = new HashSet<String>(fileExtensionsRegistry.getFileExtensions(FileExtensionType.TYPABLE_FILE_EXTENSION));
        n4FileExtensions.removeAll(fileExtensionsRegistry.getFileExtensions(FileExtensionType.RAW_FILE_EXTENSION));
        return n4FileExtensions;
    }
}

