/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.binaries.nodejs;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.n4js.binaries.BinariesConstants;
import org.eclipse.n4js.binaries.BinariesPreferenceStore;
import org.eclipse.n4js.binaries.BinariesValidator;
import org.eclipse.n4js.binaries.Binary;
import org.eclipse.n4js.binaries.nodejs.NodeJsBinary;
import org.eclipse.n4js.binaries.nodejs.NpmrcBinary;
import org.eclipse.n4js.semver.Semver.VersionNumber;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class NpmBinary
implements Binary {
    @Inject
    private BinariesValidator validator;
    @Inject
    private Provider<NodeJsBinary> nodeJsBinaryProvider;
    @Inject
    private Provider<NpmrcBinary> npmrcBinaryProvider;
    @Inject
    private BinariesPreferenceStore preferenceStore;

    @Override
    public String getId() {
        return NpmBinary.class.getName();
    }

    @Override
    public String getLabel() {
        return "npm";
    }

    @Override
    public String getDescription() {
        return "Configuration of the folder location of the npm library can be provided here. If not given, then the location will be resolved by used Node.js\u00ae. The required minimum version npm is '" + BinariesConstants.NPM_MIN_VERSION + "'.";
    }

    @Override
    public VersionNumber getMinimumVersion() {
        return BinariesConstants.NPM_MIN_VERSION;
    }

    @Override
    public String getBinaryAbsolutePath() {
        NodeJsBinary nodeJsBinary = (NodeJsBinary)this.nodeJsBinaryProvider.get();
        return String.valueOf(nodeJsBinary.getUserNodePathOrDefault()) + File.separator + "npm";
    }

    @Override
    public String getVersionArgument() {
        return "-v";
    }

    @Override
    public Binary getParent() {
        return (Binary)this.nodeJsBinaryProvider.get();
    }

    @Override
    public Iterable<Binary> getChildren() {
        return Collections.singletonList((Binary)this.npmrcBinaryProvider.get());
    }

    @Override
    public Map<String, String> updateEnvironment(Map<String, String> environment) {
        Binary parent = this.getParent();
        if (parent != null) {
            parent.updateEnvironment(environment);
        }
        return environment;
    }

    @Override
    public URI getUserConfiguredLocation() {
        return this.preferenceStore.getPath(this);
    }

    @Override
    public IStatus validate() {
        IStatus parentStatus;
        Binary parent = this.getParent();
        if (parent != null && !(parentStatus = parent.validate()).isOK()) {
            return parentStatus;
        }
        return this.validator.validate(this);
    }

    @Override
    public Optional<String[]> getCacheCleanCommand() {
        return Optional.of((Object)new String[]{"cache", "clean", "--force"});
    }

    @Override
    public boolean canInstallNpmPackages() {
        return true;
    }

    @Override
    public String getNpmInstallCommand(boolean readPackagesFromPackageJson) {
        return "install";
    }

    @Override
    public String getNpmUninstallCommand() {
        return "uninstall";
    }

    @Override
    public Optional<Pair<String, String>> getNpmSaveOptions() {
        return Optional.of((Object)new Pair((Object)"--save", (Object)"--no-save"));
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NpmBinary)) {
            return false;
        }
        NpmBinary other = (NpmBinary)obj;
        return Objects.equals(this.getId(), other.getId());
    }
}

