/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;

public class OSGiLaunchConfigurationInitializer {
    protected static final String DEFAULT = "default";

    public void initialize(ILaunchConfigurationWorkingCopy configuration) {
        this.initializeFrameworkDefaults(configuration);
        this.initializeBundleState(configuration);
        this.initializeSourcePathProvider(configuration);
    }

    protected void initializeSourcePathProvider(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
    }

    protected void initializeFrameworkDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("default_auto_start", true);
        configuration.setAttribute("default_start_level", 4);
    }

    protected void initializeBundleState(ILaunchConfigurationWorkingCopy configuration) {
        IPluginModelBase[] models;
        StringBuilder explugins = new StringBuilder();
        StringBuilder wsplugins = new StringBuilder();
        IPluginModelBase[] iPluginModelBaseArray = models = PluginRegistry.getActiveModels();
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase model = iPluginModelBaseArray[n2];
            boolean inWorkspace = model.getUnderlyingResource() != null;
            this.appendBundle(inWorkspace ? wsplugins : explugins, model);
            ++n2;
        }
        configuration.setAttribute("workspace_bundles", wsplugins.toString());
        configuration.setAttribute("target_bundles", explugins.toString());
        configuration.setAttribute("automaticAdd", true);
    }

    private void appendBundle(StringBuilder buffer, IPluginModelBase model) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        String id = model.getPluginBase().getId();
        String value = BundleLauncherHelper.writeBundleEntry(model, this.getStartLevel(id), this.getAutoStart(id));
        buffer.append(value);
    }

    protected String getStartLevel(String bundleID) {
        return DEFAULT;
    }

    protected String getAutoStart(String bundleID) {
        return DEFAULT;
    }
}

