/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.workingsets;

import com.google.common.base.Preconditions;
import com.google.inject.Singleton;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.lib.Repository;

@Singleton
public class WorkspaceRepositoriesProvider {
    private static final Logger LOGGER = Logger.getLogger(WorkspaceRepositoriesProvider.class);
    private Set<Repository> knownRepositories;
    private final IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private final Collection<WorkspaceRepositoriesChangedListener> changeListeners = new HashSet<WorkspaceRepositoriesChangedListener>();

    public WorkspaceRepositoriesProvider() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this::resourceChanged, 1);
        GitProjectData.addRepositoryChangeListener(this::repositoryChanged);
    }

    public Set<Repository> getWorkspaceRepositories() {
        this.knownRepositories = this.getWorkspaceProjects().stream().filter(p -> p.isOpen()).map(GitProjectData::get).filter(Objects::nonNull).map(WorkspaceRepositoriesProvider::getOfProjectData).map(RepositoryMapping::getRepository).collect(Collectors.toSet());
        return this.knownRepositories;
    }

    private void fireWorkspaceRepositoriesChanged() {
        Set<Repository> newValue = this.getWorkspaceRepositories();
        this.changeListeners.forEach(listener -> listener.workspaceRepositoriesChanged(newValue));
    }

    public void addWorkspaceRepositoriesChangedListener(WorkspaceRepositoriesChangedListener listener) {
        this.changeListeners.add((WorkspaceRepositoriesChangedListener)Preconditions.checkNotNull((Object)listener, (Object)"listener must not be null"));
    }

    public void removeWorkspaceRepositoriesChangedListener(WorkspaceRepositoriesChangedListener listener) {
        this.changeListeners.remove(Preconditions.checkNotNull((Object)listener, (Object)"listener must not be null"));
    }

    private static RepositoryMapping getOfProjectData(GitProjectData projectData) {
        return projectData.getRepositoryMapping((IResource)projectData.getProject());
    }

    private List<IProject> getWorkspaceProjects() {
        return Arrays.asList(this.workspaceRoot.getProjects());
    }

    private void repositoryChanged(RepositoryMapping which) {
        if (this.knownRepositories != null && !this.knownRepositories.contains(which.getRepository())) {
            this.fireWorkspaceRepositoriesChanged();
        }
    }

    private void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept(this::handleResourceDelta);
        }
        catch (CoreException e) {
            LOGGER.error((Object)"Error occurred while handling resource change event.", (Throwable)e);
        }
    }

    private boolean handleResourceDelta(IResourceDelta delta) {
        IResource affectedResource = delta.getResource();
        if (affectedResource instanceof IProject) {
            if ((delta.getKind() & 4) == 4) {
                if ((delta.getFlags() & 0x4000) == 16384) {
                    this.fireWorkspaceRepositoriesChanged();
                    return false;
                }
            } else if ((delta.getKind() & 1 | 2) != 0) {
                this.fireWorkspaceRepositoriesChanged();
                return false;
            }
        }
        return true;
    }

    public static interface WorkspaceRepositoriesChangedListener {
        public void workspaceRepositoriesChanged(Set<Repository> var1);
    }
}

