/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.git;

import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.io.Files;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.util.FS;

class SshSessionFactory
extends JschConfigSessionFactory {
    SshSessionFactory() {
    }

    protected void configure(OpenSshConfig.Host host, Session session) {
    }

    protected JSch getJSch(OpenSshConfig.Host host, FS fs) throws JSchException {
        return this.configureIdentity(super.getJSch(host, fs));
    }

    protected JSch createDefaultJSch(FS fs) throws JSchException {
        return this.configureIdentity(super.createDefaultJSch(fs));
    }

    private JSch configureIdentity(JSch jsch) throws JSchException {
        File sshDirectory = new File(String.valueOf(StandardSystemProperty.USER_HOME.value()) + "/.ssh");
        Preconditions.checkState((boolean)sshDirectory.exists(), (Object)".ssh directory does not exist under home folder.");
        Preconditions.checkState((boolean)sshDirectory.canRead(), (Object)".ssh directory content cannot be read.");
        Preconditions.checkState((boolean)sshDirectory.isDirectory(), (Object)(sshDirectory.getAbsoluteFile() + " is not a directory."));
        File[] keyFiles = sshDirectory.listFiles();
        Preconditions.checkState((keyFiles != null && keyFiles.length > 0 ? 1 : 0) != 0, (Object)"No SSH key files exist.");
        jsch.removeAllIdentity();
        File[] fileArray = keyFiles;
        int n = keyFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String keyFileName;
            String keyUri;
            int lastIndexOf;
            File keyFile = fileArray[n2];
            if (keyFile.isFile() && (lastIndexOf = (keyUri = keyFile.toURI().toString()).lastIndexOf("/")) > 0 && ("id_rsa".equals(keyFileName = keyUri.substring(lastIndexOf + 1)) || "id_dsa".equals(keyFileName))) {
                if (this.isEncrypted(keyFile)) {
                    String pw = this.getPassphrase(keyFile);
                    jsch.addIdentity(keyFile.getAbsolutePath(), pw);
                    break;
                }
                jsch.addIdentity(keyFile.getAbsolutePath());
                break;
            }
            ++n2;
        }
        return jsch;
    }

    private String getPassphrase(File keyFile) {
        String name = keyFile.getName();
        String pw = System.getProperty("org.eclipse.n4js.ssh.pw." + name);
        if (pw == null) {
            if (System.console() == null) {
                String msg = "Need passphrase to decrypt ssh key \nAdd this following line to VM arguments in debug config:\n-Dorg.eclipse.n4js.ssh.pw." + name + "=${password_prompt}";
                System.err.println(msg);
                throw new IllegalStateException(msg);
            }
            pw = new String(System.console().readPassword("Enter passphrase for ssh key " + name, new Object[0]));
        }
        return pw;
    }

    private boolean isEncrypted(File keyFile) {
        try {
            String s = Files.toString((File)keyFile, (Charset)Charset.defaultCharset());
            return s.indexOf("ENCRYPTED") >= 0;
        }
        catch (IOException e) {
            return false;
        }
    }
}

