/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import org.apache.log4j.Logger;

public class FileDeleter
implements FileVisitor<Path> {
    private static final Logger LOGGER = Logger.getLogger(FileDeleter.class);
    private final boolean logToStdErr;

    public static void delete(File resourceToDelete) throws IOException {
        if (resourceToDelete.exists()) {
            FileDeleter.delete(resourceToDelete.toPath());
        }
    }

    public static void delete(Path resourceToDelete) throws IOException {
        FileDeleter.delete(resourceToDelete, false);
    }

    public static void delete(Path resourceToDelete, boolean logToStdErr) throws IOException {
        if (resourceToDelete.toFile().exists()) {
            Files.walkFileTree(resourceToDelete, new FileDeleter(logToStdErr));
        }
    }

    public static void delete(File resourceToDelete, Consumer<IOException> errorHandler) {
        if (resourceToDelete.exists()) {
            try {
                Files.walkFileTree(resourceToDelete.toPath(), new FileDeleter(false));
            }
            catch (IOException ioe) {
                errorHandler.accept(ioe);
            }
        }
    }

    public static void delete(Path resourceToDelete, Consumer<IOException> errorHandler) {
        if (resourceToDelete.toFile().exists()) {
            try {
                Files.walkFileTree(resourceToDelete, new FileDeleter(false));
            }
            catch (IOException ioe) {
                errorHandler.accept(ioe);
            }
        }
    }

    public FileDeleter(boolean logToStdErr) {
        this.logToStdErr = logToStdErr;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        Files.delete(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        this.logError(file, exc);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        Files.delete(dir);
        return FileVisitResult.CONTINUE;
    }

    private void logError(Path path, IOException e) {
        if (this.logToStdErr) {
            System.err.println("Unexpected file visiting failure" + path);
            e.printStackTrace();
        } else {
            LOGGER.error((Object)("Unexpected file visiting failure" + path), (Throwable)e);
        }
    }
}

