/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources.sessions;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.n4js.tester.events.SessionPingedEvent;
import org.eclipse.n4js.tester.events.TestEvent;
import org.eclipse.n4js.tester.server.HttpConstants;
import org.eclipse.n4js.tester.server.resources.ClientResourceException;
import org.eclipse.n4js.tester.server.resources.ContentType;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.Resource;
import org.eclipse.n4js.tester.server.resources.sessions.SessionResource;

@Resource(path="/{sessionId}/ping/", method={HttpMethod.POST}, requestContentType={ContentType.PING_SESSION})
public class PingSessionResource
extends SessionResource {
    private static final String TIMEOUT_KEY = "timeout";
    private static final String COMMENT_KEY = "comment";
    @Inject
    private ObjectMapper mapper;

    @Override
    protected TestEvent createEvent(String sessionId, String body) throws ClientResourceException {
        if (Strings.isNullOrEmpty((String)body)) {
            throw new ClientResourceException(400);
        }
        HashMap values = Maps.newHashMap();
        try {
            values.putAll((Map)this.mapper.readValue(body, Map.class));
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
        }
        catch (IOException e) {
            throw new ClientResourceException(400);
        }
        Object value = values.get(TIMEOUT_KEY);
        if (value == null) {
            throw new ClientResourceException(HttpConstants.SC_UNPROCESSABLE_ENTITY);
        }
        Object comment = values.get(COMMENT_KEY);
        try {
            long timeout = Long.parseLong(Objects.toString(value));
            return new SessionPingedEvent(sessionId, timeout, comment == null ? null : String.valueOf(comment));
        }
        catch (NumberFormatException e) {
            throw new ClientResourceException(400);
        }
    }
}

