/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix;

import com.google.common.base.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.n4JS.N4Modifier;
import org.eclipse.xtext.validation.Issue;

public class QuickfixUtil {
    public static EObject getEObjectForUri(ResourceSet set, String uri) {
        boolean _lessThan;
        String[] fileFragments = uri.split("#");
        int _length = fileFragments.length;
        boolean bl = _lessThan = _length < 2;
        if (_lessThan) {
            return null;
        }
        String fileURI = fileFragments[0];
        String objectURI = fileFragments[1];
        Resource resource = set.getResource(URI.createURI((String)fileURI), true);
        if (resource != null) {
            EObject object = resource.getEObject(objectURI);
            return object;
        }
        return null;
    }

    public static boolean isContainingResourceModifiable(String objectUri) {
        URI uri = URI.createURI((String)objectUri, (boolean)true);
        if (uri == null) {
            return false;
        }
        WorkspaceFileHandle fileHandle = WorkspaceFileHandle.fileContainingObjectURI(uri);
        if (fileHandle == null) {
            return false;
        }
        boolean _isDerived = fileHandle.getIsDerived();
        if (_isDerived) {
            return false;
        }
        boolean _readOnly = fileHandle.getReadOnly();
        return !_readOnly;
    }

    public static N4Modifier modifierForSuggestion(String suggestion) {
        block19: {
            String _upperCase = suggestion.toUpperCase();
            if (_upperCase == null) break block19;
            switch (_upperCase) {
                case "PUBLIC": {
                    return N4Modifier.PUBLIC;
                }
                case "PROTECTED": {
                    return N4Modifier.PROTECTED;
                }
                case "PUBLICINTERNAL": {
                    return N4Modifier.PUBLIC;
                }
                case "PROTECTEDINTERNAL": {
                    return N4Modifier.PROTECTED;
                }
                case "PROJECT": {
                    return N4Modifier.PROJECT;
                }
            }
            return N4Modifier.UNDEFINED;
        }
        return N4Modifier.UNDEFINED;
    }

    public static boolean modifierSuggestionIsInternal(String suggestion) {
        boolean _xblockexpression = false;
        if (Objects.equal((Object)suggestion.toUpperCase(), (Object)"PUBLICINTERNAL") || Objects.equal((Object)suggestion.toUpperCase(), (Object)"PROTECTEDINTERNAL")) {
            return true;
        }
        _xblockexpression = false;
        return _xblockexpression;
    }

    public static String readableStringForSuggestion(String suggestion) {
        N4Modifier modifier = QuickfixUtil.modifierForSuggestion(suggestion);
        boolean isInternal = QuickfixUtil.modifierSuggestionIsInternal(suggestion);
        String output = "";
        if (modifier != null) {
            switch (modifier) {
                case PRIVATE: {
                    String _output = output;
                    output = String.valueOf(_output) + "private";
                    break;
                }
                case PROJECT: {
                    String _output_1 = output;
                    output = String.valueOf(_output_1) + "project";
                    break;
                }
                case PROTECTED: {
                    String _output_2 = output;
                    output = String.valueOf(_output_2) + "protected";
                    break;
                }
                case PUBLIC: {
                    String _output_3 = output;
                    output = String.valueOf(_output_3) + "public";
                    break;
                }
                default: {
                    String _output_4 = output;
                    output = String.valueOf(_output_4) + "undefined";
                    break;
                }
            }
        } else {
            String _output_4 = output;
            output = String.valueOf(_output_4) + "undefined";
        }
        if (isInternal) {
            String _output_5 = output;
            output = String.valueOf(_output_5) + ", @Internal";
        }
        return output;
    }

    public static class IssueUserDataKeysExtension {
        public String getUserData(Issue issue, String key) {
            String[] userData = issue.getData();
            if (userData == null) {
                return null;
            }
            int i = 0;
            int userDataLength = userData.length;
            boolean _while = i < userDataLength;
            while (_while) {
                if (userData[i].equals(key) && i + 1 < userDataLength) {
                    return userData[i + 1];
                }
                int _i = i;
                boolean bl = _while = (i = _i + 2) < userDataLength;
            }
            return null;
        }
    }

    public static class WorkspaceFileHandle {
        private IPath path;
        private IFile file;

        public static WorkspaceFileHandle fileContainingObjectURI(URI uri) {
            boolean _lessThan;
            if (uri == null) {
                return null;
            }
            int _length = uri.toString().length();
            boolean bl = _lessThan = _length < 1;
            if (_lessThan) {
                return null;
            }
            URI fileURI = uri.deresolve(URI.createURI((String)"platform:/resource/"));
            String[] fileFragments = fileURI.toString().split("#");
            String _get = fileFragments[0];
            Path _path = new Path(_get);
            return new WorkspaceFileHandle((IPath)_path);
        }

        public WorkspaceFileHandle(IPath path) {
            this.path = path;
            this.file = ResourcesPlugin.getWorkspace().getRoot().getFile(this.path);
        }

        public boolean getReadOnly() {
            return this.file.isReadOnly();
        }

        public boolean getIsDerived() {
            return this.file.isDerived();
        }
    }
}

