/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.xtext.lib.setup.workspace;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.xpect.setup.XpectSetupComponent;
import org.eclipse.xpect.xtext.lib.setup.FileSetupContext;
import org.eclipse.xpect.xtext.lib.setup.workspace.Project;
import org.eclipse.xpect.xtext.lib.setup.workspace.SrcFolder;
import org.eclipse.xpect.xtext.lib.setup.workspace.Workspace;

@XpectSetupComponent
public class JavaProject
extends Project {
    private static final String JRE_CONTAINER_1_5 = "org.eclipse.jdt.launching.JRE_CONTAINER/org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType/J2SE-1.5";
    private List<IClasspathEntry> classpathEntries = Lists.newArrayList();

    public JavaProject() {
        this("java_project");
    }

    public JavaProject(String name) {
        super(name);
        this.addNature("org.eclipse.jdt.core.javanature");
        this.addBuilder("org.eclipse.jdt.core.javabuilder");
        this.classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(JRE_CONTAINER_1_5)));
    }

    public void addClasspathEntry(IClasspathEntry path) {
        this.classpathEntries.add(path);
    }

    public void addClassPathOfClass(Class<?> clazz) {
        String resolvedRawPath;
        String classNameAsPath = "/" + clazz.getName().replace('.', '/');
        String resourceName = String.valueOf(classNameAsPath) + ".class";
        URL url = clazz.getResource(resourceName);
        if (url == null) {
            throw new IllegalArgumentException(String.valueOf(resourceName) + " not found");
        }
        String pathToFolderOrJar = null;
        if (url.getProtocol().startsWith("bundleresource")) {
            try {
                url = FileLocator.resolve((URL)url);
            }
            catch (IOException e) {
                throw new WrappedException((Exception)e);
            }
        }
        if (url.getProtocol().startsWith("jar")) {
            try {
                String path = url.getPath().substring(0, url.getPath().indexOf(33));
                String encodedPath = path.replace(" ", "%20");
                pathToFolderOrJar = new URL(encodedPath).toURI().getRawPath();
            }
            catch (Exception e) {
                throw new WrappedException(e);
            }
        }
        try {
            resolvedRawPath = url.toExternalForm().contains(" ") ? URIUtil.toURI((URL)url).getRawPath() : url.toURI().getRawPath();
        }
        catch (URISyntaxException e) {
            throw new WrappedException((Exception)e);
        }
        pathToFolderOrJar = resolvedRawPath.substring(0, resolvedRawPath.indexOf(classNameAsPath));
        this.classpathEntries.add(JavaCore.newLibraryEntry((IPath)new Path(pathToFolderOrJar), null, null));
    }

    public void addContainer(String name) {
        this.classpathEntries.add(JavaCore.newContainerEntry((IPath)new Path(name)));
    }

    @Override
    public IProject create(FileSetupContext ctx, IWorkspaceRoot container, Workspace.Instance instance) throws CoreException, IOException {
        IProject project = super.create(ctx, container, instance);
        IJavaProject java = JavaCore.create((IProject)project);
        LinkedHashSet classPath = Sets.newLinkedHashSet((Iterable)Lists.newArrayList((Object[])java.getRawClasspath()));
        classPath.remove(JavaCore.newSourceEntry((IPath)project.getFullPath()));
        classPath.addAll(this.classpathEntries);
        for (SrcFolder srcFolder : this.getMembers(SrcFolder.class)) {
            classPath.add(JavaCore.newSourceEntry((IPath)project.getFolder(srcFolder.getName()).getFullPath()));
        }
        java.setRawClasspath(Lists.newArrayList((Iterable)classPath).toArray(new IClasspathEntry[classPath.size()]), (IProgressMonitor)new NullProgressMonitor());
        java.save(null, true);
        return project;
    }
}

