/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.model;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xpect.Environment;
import org.eclipse.xpect.XjmContribution;
import org.eclipse.xpect.XpectRequiredEnvironment;
import org.eclipse.xpect.model.XjmContributionImpl;
import org.eclipse.xpect.util.JvmAnnotationUtil;
import org.eclipse.xtext.common.types.JvmAnnotationTarget;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.util.Strings;

public class XjmContributionImplCustom
extends XjmContributionImpl {
    private static final Logger LOG = Logger.getLogger(XjmContributionImplCustom.class);

    public void initialize(JvmDeclaredType type, Collection<? extends Annotation> roles) {
        super.setDeactivationReason(null);
        super.setJvmClass(type);
        EList<Annotation> newRoles = super.getRoles();
        newRoles.clear();
        newRoles.addAll(roles);
        EList<Environment> newEnvironments = this.getEnvironments();
        newEnvironments.clear();
        XpectRequiredEnvironment xpectEnvironment = JvmAnnotationUtil.getJavaAnnotation((JvmAnnotationTarget)this.getJvmClass(), XpectRequiredEnvironment.class);
        if (xpectEnvironment != null) {
            newEnvironments.addAll((Collection)Lists.newArrayList((Object[])xpectEnvironment.value()));
        } else {
            newEnvironments.addAll((Collection)Lists.newArrayList((Object[])Environment.values()));
        }
    }

    @Override
    public boolean isActive() {
        JvmDeclaredType cls = this.getJvmClass();
        return cls != null && !cls.eIsProxy() && Strings.isEmpty((String)this.getDeactivationReason());
    }

    @Override
    public <T> T newInstance(Class<T> expectedType) {
        Class<?> clazz = this.getJavaClass();
        if (clazz == null || !expectedType.isAssignableFrom(clazz)) {
            return null;
        }
        try {
            T result = expectedType.cast(clazz.newInstance());
            return result;
        }
        catch (InstantiationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    @Override
    public void setJvmClass(JvmDeclaredType newJvmClass) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setReplacedBy(XjmContribution newReplacedBy) {
        super.setReplacedBy(newReplacedBy);
        this.setDeactivationReason("ReplacedBy: " + newReplacedBy.getJvmClass().getQualifiedName());
    }
}

