/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.runner;

import com.google.common.base.Preconditions;
import org.eclipse.xpect.XjmXpectMethod;
import org.eclipse.xpect.XpectInvocation;
import org.eclipse.xpect.runner.AbstractTestRunner;
import org.eclipse.xpect.runner.DescriptionFactory;
import org.eclipse.xpect.runner.TestExecutor;
import org.eclipse.xpect.runner.XpectFileRunner;
import org.eclipse.xpect.state.Creates;
import org.eclipse.xpect.state.StateContainer;
import org.junit.runner.Description;

public class XpectTestRunner
extends AbstractTestRunner {
    private final XpectInvocation invocation;
    private final StateContainer state;

    public XpectTestRunner(StateContainer state, XpectFileRunner uriRunner, XpectInvocation invocation) {
        super(uriRunner);
        Preconditions.checkNotNull((Object)invocation);
        this.invocation = invocation;
        this.state = state;
    }

    @Creates
    public XpectTestRunner create() {
        return this;
    }

    @Override
    public Description createDescription() {
        XpectFileRunner runner = this.getFileRunner();
        Class<?> javaClass = runner.getJavaTestClass();
        Description description = DescriptionFactory.createTestDescription(javaClass, runner.getURIProvider(), this.invocation);
        return description;
    }

    public XpectInvocation getInvocation() {
        return this.invocation;
    }

    @Override
    public XjmXpectMethod getMethod() {
        return this.invocation.getMethod();
    }

    @Override
    public StateContainer getState() {
        return this.state;
    }

    @Override
    protected boolean isIgnore() {
        return this.invocation.getFile().isIgnore() || this.invocation.isIgnore() || super.isIgnore();
    }

    @Override
    protected void runInternal() throws Throwable {
        TestExecutor.runTest(this.state, this.invocation);
    }
}

