/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.utils.di.scopes;

import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.ScopeAnnotation;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public final class ScopeManager
implements Scope {
    private final ThreadLocal<ScopeRegistry> registry = new ThreadLocal();

    private ScopeRegistry getRegistry() {
        ScopeRegistry reg = this.registry.get();
        if (reg == null) {
            ScopeRegistry newReg = new ScopeRegistry();
            this.registry.set(newReg);
            return newReg;
        }
        return reg;
    }

    public void enter(Class<? extends Annotation> scope) {
        ScopeManager.checkScopeAnnotation(scope);
        ScopeRegistry reg = this.getRegistry();
        if (reg.isScopeActive(scope)) {
            throw new IllegalStateException("attempt to enter an already active scope: " + scope.getName());
        }
        reg.activateScope(scope);
    }

    public <T> void bind(Class<? extends Annotation> scope, Class<T> key, T value) {
        this.bind(scope, Key.get(key), value);
    }

    private <T> void bind(Class<? extends Annotation> scope, Key<T> key, T value) {
        ScopeManager.checkScopeAnnotation(scope);
        ScopeRegistry reg = this.getRegistry();
        if (!reg.isScopeActive(scope)) {
            throw new IllegalStateException("attempt to bind a scoped value outside its scope");
        }
        reg.bind(scope, key, value);
    }

    public <T> Provider<T> scope(final Key<T> key, Provider<T> unscoped) {
        Class clsToBeInjected = key.getTypeLiteral().getRawType();
        final Class<? extends Annotation> scope = ScopeManager.getScopeFromScopedClass(clsToBeInjected);
        if (scope == null) {
            throw new IllegalArgumentException("not a scoped class (i.e. does not have a scope annotation): " + clsToBeInjected.getName());
        }
        return new Provider<T>(){

            public T get() {
                ScopeRegistry reg = ScopeManager.this.getRegistry();
                if (!reg.isScopeActive(scope)) {
                    throw new IllegalStateException("attempt to read a scoped value outside its scope");
                }
                Object value = reg.getBinding(scope, key);
                if (value == null) {
                    throw new IllegalStateException("attempt to read a scoped value that was not bound within its scope");
                }
                return value;
            }
        };
    }

    public void exit(Class<? extends Annotation> scope) {
        ScopeManager.checkScopeAnnotation(scope);
        ScopeRegistry reg = this.getRegistry();
        if (!reg.isScopeActive(scope)) {
            throw new IllegalStateException("attempt to exit an inactive scope: " + scope.getName());
        }
        reg.deactivateScope(scope);
    }

    private static final void checkScopeAnnotation(Class<? extends Annotation> annotationClass) {
        if (!ScopeManager.isScopeAnnotation(annotationClass)) {
            throw new IllegalArgumentException("given annotation must be a goolge Guice scope annotation");
        }
    }

    public static final Class<? extends Annotation> getScopeFromScopedClass(Class<?> clsToBeInjected) {
        Annotation match = null;
        Annotation[] annotationArray = clsToBeInjected.getAnnotations();
        int n = annotationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation ann = annotationArray[n2];
            if (ScopeManager.isScopeAnnotation(ann.annotationType())) {
                if (match != null) {
                    throw new IllegalStateException("class has several scope annotations: " + clsToBeInjected.getName());
                }
                match = ann;
            }
            ++n2;
        }
        return match != null ? match.annotationType() : null;
    }

    public static final boolean isScopeAnnotation(Class<? extends Annotation> annotationClass) {
        return annotationClass.isAnnotationPresent(ScopeAnnotation.class);
    }

    private static final class ScopeRegistry {
        public final Map<Class<? extends Annotation>, Map<Key<?>, Object>> valuesPerActiveScope = new HashMap();

        private ScopeRegistry() {
        }

        public boolean isScopeActive(Class<? extends Annotation> scope) {
            return this.valuesPerActiveScope.containsKey(scope);
        }

        public void activateScope(Class<? extends Annotation> scope) {
            this.valuesPerActiveScope.put(scope, new HashMap());
        }

        public <T> void bind(Class<? extends Annotation> scope, Key<T> key, T value) {
            this.valuesPerActiveScope.get(scope).put(key, value);
        }

        public <T> T getBinding(Class<? extends Annotation> scope, Key<T> key) {
            Object resultCasted = this.valuesPerActiveScope.get(scope).get(key);
            return (T)resultCasted;
        }

        public void deactivateScope(Class<? extends Annotation> scope) {
            this.valuesPerActiveScope.remove(scope);
        }
    }
}

