/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.ui.internal.dnd;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropCommand;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropManager;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.TopLevelNode;
import org.eclipse.wst.dtd.ui.internal.dnd.DragAttributeCommand;
import org.eclipse.wst.dtd.ui.internal.dnd.DragContentModelCommand;
import org.eclipse.wst.dtd.ui.internal.dnd.DragTopLevelNodesCommand;
import org.w3c.dom.Node;

public class DTDDragAndDropManager
implements DragAndDropManager {
    public DragAndDropCommand createCommand(Object target, float location, int operations, int operation, Collection source) {
        if (target instanceof DTDNode) {
            DTDNode node = (DTDNode)target;
            source = this.mergeSource(source);
            if (node instanceof TopLevelNode) {
                return new DragTopLevelNodesCommand(target, location, operations, operation, source);
            }
            if (node instanceof Attribute) {
                return new DragAttributeCommand(target, location, operations, operation, source);
            }
            if (node instanceof CMNode) {
                return new DragContentModelCommand(target, location, operations, operation, source);
            }
        }
        return null;
    }

    private Collection mergeSource(Collection collection) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : collection) {
            if (result.contains(node)) continue;
            boolean isAdd = true;
            int i = result.size() - 1;
            while (i >= 0) {
                Node addedNode = (Node)result.get(i);
                if (this.isAncestor(node, addedNode)) {
                    if (isAdd) {
                        result.set(i, node);
                        isAdd = false;
                    } else {
                        result.remove(i);
                    }
                } else if (!isAdd && this.isAncestor(addedNode, node)) {
                    isAdd = false;
                    break;
                }
                --i;
            }
            if (!isAdd) continue;
            result.add(node);
        }
        return result;
    }

    private boolean isAncestor(Node node1, Node node2) {
        boolean result = false;
        Node parent = node2;
        while (parent != null) {
            if (parent == node1) {
                result = true;
                break;
            }
            parent = parent.getParentNode();
        }
        return result;
    }
}

