/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpect.model;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xpect.XjmContribution;
import org.eclipse.xpect.XjmXpectMethod;
import org.eclipse.xpect.XpectArgument;
import org.eclipse.xpect.XpectFactory;
import org.eclipse.xpect.XpectFile;
import org.eclipse.xpect.XpectJavaModel;
import org.eclipse.xpect.XpectPackage;
import org.eclipse.xpect.model.XpectFileImplCustom;
import org.eclipse.xpect.model.XpectInvocationImpl;
import org.eclipse.xpect.parameter.IStatementRelatedRegion;
import org.eclipse.xpect.parameter.IStatementRelatedRegionProvider;
import org.eclipse.xpect.parameter.StatementRelatedRegion;
import org.eclipse.xpect.parameter.StatementRelatedRegionProvider;
import org.eclipse.xpect.util.IJavaReflectAccess;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class XpectInvocationImplCustom
extends XpectInvocationImpl {
    @Override
    public EList<XpectArgument> getArguments() {
        Method javaMethod;
        XjmXpectMethod xjmMethod;
        if (this.arguments == null && (xjmMethod = this.getMethod()) != null && !xjmMethod.eIsProxy() && (javaMethod = xjmMethod.getJavaMethod()) != null) {
            EList<XpectArgument> sup = super.getArguments();
            int count = javaMethod.getParameterTypes().length;
            int i = 0;
            while (i < count) {
                XpectArgument argument = XpectFactory.eINSTANCE.createXpectArgument();
                argument.setIndex(i);
                sup.add((Object)argument);
                ++i;
            }
        }
        return super.getArguments();
    }

    @Override
    public XpectFile getFile() {
        return (XpectFile)this.eContainer();
    }

    @Override
    public IStatementRelatedRegion getExtendedRegion() {
        if (this.extendedRegion == null) {
            ICompositeNode node = NodeModelUtils.getNode((EObject)this);
            int offset = node.getOffset();
            int end = offset + node.getLength();
            for (IStatementRelatedRegion region : this.getRelatedRegions()) {
                int e;
                int o = region.getOffset();
                if (o < offset) {
                    offset = o;
                }
                if ((e = o + region.getLength()) <= end) continue;
                end = e;
            }
            this.extendedRegion = new StatementRelatedRegion(this, offset, end - offset);
        }
        return super.getExtendedRegion();
    }

    @Override
    public String getId() {
        if (this.id == null) {
            ((XpectFileImplCustom)this.getFile()).initalizeInvocationsIDs();
        }
        return super.getId();
    }

    @Override
    public String getMethodName() {
        XjmXpectMethod method = this.basicGetMethod();
        return method != null && !method.eIsProxy() ? method.getName() : this.getMethodNameFromNodeModel();
    }

    protected String getMethodNameFromNodeModel() {
        Iterator iterator = NodeModelUtils.findNodesForFeature((EObject)this, (EStructuralFeature)XpectPackage.Literals.XPECT_INVOCATION__METHOD).iterator();
        if (iterator.hasNext()) {
            INode node = (INode)iterator.next();
            return NodeModelUtils.getTokenText((INode)node);
        }
        return null;
    }

    protected Class<?> getParameterType(int paramIndex) {
        XjmXpectMethod xpectMethod = this.getMethod();
        if (xpectMethod == null) {
            return null;
        }
        JvmOperation jvmMethod = xpectMethod.getJvmMethod();
        if (jvmMethod == null || jvmMethod.eIsProxy()) {
            return null;
        }
        JvmTypeReference parameterType = ((JvmFormalParameter)jvmMethod.getParameters().get(paramIndex)).getParameterType();
        if (parameterType == null || parameterType.eIsProxy() || parameterType.getType() == null) {
            return null;
        }
        Class<?> expectedType = IJavaReflectAccess.INSTANCE.getRawType(parameterType.getType());
        return expectedType;
    }

    @Override
    public <T extends IStatementRelatedRegion> T getRelatedRegion(Class<T> type) {
        for (IStatementRelatedRegion region : this.getRelatedRegions()) {
            if (!type.isInstance(region)) continue;
            return (T)((IStatementRelatedRegion)type.cast(region));
        }
        return null;
    }

    @Override
    public EList<IStatementRelatedRegion> getRelatedRegions() {
        if (this.relatedRegions == null) {
            ArrayList regions = Lists.newArrayList();
            XpectJavaModel xjm = this.getFile().getJavaModel();
            if (xjm != null) {
                for (XjmContribution contrib : xjm.getContributions(StatementRelatedRegionProvider.class)) {
                    IStatementRelatedRegion region;
                    IStatementRelatedRegionProvider provider = contrib.newInstance(IStatementRelatedRegionProvider.class);
                    if (provider == null || (region = provider.getRegion(this)) == null) continue;
                    regions.add(region);
                }
                int i = 0;
                while (i < regions.size()) {
                    IStatementRelatedRegion region = (IStatementRelatedRegion)regions.get(i);
                    if (region instanceof IStatementRelatedRegionProvider.IRefinableStatementRelatedRegion) {
                        IStatementRelatedRegion refined = ((IStatementRelatedRegionProvider.IRefinableStatementRelatedRegion)region).refine(regions);
                        regions.set(i, refined);
                    }
                    ++i;
                }
            }
            super.getRelatedRegions().addAll((Collection)regions);
        }
        return super.getRelatedRegions();
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setMethod(XjmXpectMethod newMethod) {
        ((XpectFileImplCustom)this.getFile()).unsetInvocationIDs();
        this.relatedRegions = null;
        this.arguments = null;
        this.extendedRegion = null;
        super.setMethod(newMethod);
    }
}

