/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.ui.refactoring.history;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptorProxy;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.Messages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringDescriptorImageDescriptor;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryDate;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryEntry;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringHistoryNode;
import org.eclipse.ltk.internal.ui.refactoring.history.RefactoringImageDescriptor;
import org.eclipse.ltk.ui.refactoring.history.RefactoringHistoryControlConfiguration;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class RefactoringHistoryLabelProvider
extends LabelProvider {
    private final Image fCollectionImage;
    private final Image fContainerImage;
    private final RefactoringHistoryControlConfiguration fControlConfiguration;
    private DateFormat fDateFormat = null;
    private Image fDecoratedElementImage = null;
    private Image fDecoratedItemImage = null;
    private final Image fElementImage;
    private final Image fItemImage;

    public RefactoringHistoryLabelProvider(RefactoringHistoryControlConfiguration configuration) {
        Assert.isNotNull((Object)configuration);
        this.fControlConfiguration = configuration;
        this.fItemImage = RefactoringPluginImages.DESC_OBJS_REFACTORING.createImage();
        this.fContainerImage = RefactoringPluginImages.DESC_OBJS_REFACTORING_DATE.createImage();
        this.fElementImage = RefactoringPluginImages.DESC_OBJS_REFACTORING_TIME.createImage();
        this.fCollectionImage = RefactoringPluginImages.DESC_OBJS_REFACTORING_COLL.createImage();
    }

    private Image decorateImage(Image image, Object element) {
        String project;
        Image result = image;
        RefactoringDescriptorProxy extended = null;
        if (element instanceof RefactoringHistoryEntry) {
            extended = ((RefactoringHistoryEntry)element).getDescriptor();
        } else if (element instanceof RefactoringDescriptorProxy) {
            extended = (RefactoringDescriptorProxy)element;
        }
        if (extended != null && ((project = extended.getProject()) == null || "".equals(project))) {
            if (image == this.fElementImage && this.fDecoratedElementImage != null) {
                result = this.fDecoratedElementImage;
            } else if (image == this.fItemImage && this.fDecoratedItemImage != null) {
                result = this.fDecoratedItemImage;
            } else {
                Rectangle bounds = image.getBounds();
                result = new RefactoringDescriptorImageDescriptor(new RefactoringImageDescriptor(image), 2, new Point(bounds.width, bounds.height)).createImage();
                if (image == this.fElementImage) {
                    this.fDecoratedElementImage = result;
                } else if (image == this.fItemImage) {
                    this.fDecoratedItemImage = result;
                }
            }
        }
        return result;
    }

    public void dispose() {
        if (this.fContainerImage != null) {
            this.fContainerImage.dispose();
        }
        if (this.fCollectionImage != null) {
            this.fCollectionImage.dispose();
        }
        if (this.fElementImage != null) {
            this.fElementImage.dispose();
        }
        if (this.fItemImage != null) {
            this.fItemImage.dispose();
        }
        if (this.fDecoratedElementImage != null) {
            this.fDecoratedElementImage.dispose();
        }
        if (this.fDecoratedItemImage != null) {
            this.fDecoratedItemImage.dispose();
        }
    }

    private DateFormat getDateFormat() {
        if (this.fDateFormat == null) {
            this.fDateFormat = DateFormat.getTimeInstance((int)3);
        }
        return this.fDateFormat;
    }

    private String getDescriptorLabel(RefactoringDescriptorProxy descriptor) {
        long stamp;
        if (this.fControlConfiguration.isTimeDisplayed() && (stamp = descriptor.getTimeStamp()) >= 0L) {
            return Messages.format(this.fControlConfiguration.getRefactoringPattern(), new String[]{this.getDateFormat().format(new Date(stamp)), descriptor.getDescription()});
        }
        return descriptor.getDescription();
    }

    public Image getImage(Object element) {
        Image image = null;
        boolean time = this.fControlConfiguration.isTimeDisplayed();
        image = element instanceof RefactoringHistoryEntry || element instanceof RefactoringDescriptorProxy ? (time ? this.fElementImage : this.fItemImage) : (time ? this.fContainerImage : this.fCollectionImage);
        return this.decorateImage(image, element);
    }

    public String getText(Object element) {
        if (element instanceof RefactoringHistoryEntry) {
            RefactoringHistoryEntry entry = (RefactoringHistoryEntry)element;
            return this.getDescriptorLabel(entry.getDescriptor());
        }
        if (element instanceof RefactoringDescriptorProxy) {
            return this.getDescriptorLabel((RefactoringDescriptorProxy)element);
        }
        if (element instanceof RefactoringHistory) {
            return RefactoringUIMessages.RefactoringHistoryControlConfiguration_collection_label;
        }
        if (element instanceof RefactoringHistoryNode) {
            RefactoringHistoryNode node = (RefactoringHistoryNode)element;
            StringBuffer buffer = new StringBuffer(32);
            int kind = node.getKind();
            switch (kind) {
                case 11: {
                    buffer.append(this.fControlConfiguration.getCollectionLabel());
                    break;
                }
                default: {
                    if (!(node instanceof RefactoringHistoryDate)) break;
                    RefactoringHistoryDate date = (RefactoringHistoryDate)node;
                    Date stamp = new Date(date.getTimeStamp());
                    DateFormat format = null;
                    String pattern = "";
                    switch (kind) {
                        case 2: {
                            pattern = this.fControlConfiguration.getThisWeekPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_this_week_format);
                            break;
                        }
                        case 3: {
                            pattern = this.fControlConfiguration.getLastWeekPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_last_week_format);
                            break;
                        }
                        case 8: {
                            pattern = this.fControlConfiguration.getWeekPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_week_format);
                            break;
                        }
                        case 6: {
                            pattern = this.fControlConfiguration.getYearPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_year_format);
                            break;
                        }
                        case 4: {
                            pattern = this.fControlConfiguration.getThisMonthPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_this_month_format2);
                            break;
                        }
                        case 5: {
                            pattern = this.fControlConfiguration.getLastMonthPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_last_month_format2);
                            break;
                        }
                        case 7: {
                            pattern = this.fControlConfiguration.getMonthPattern();
                            format = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_month_format2);
                            break;
                        }
                        case 9: {
                            pattern = this.fControlConfiguration.getDayPattern();
                            int type = node.getParent().getKind();
                            if (type == 2 || type == 3) {
                                SimpleDateFormat simple = new SimpleDateFormat(RefactoringUIMessages.RefactoringHistoryLabelProvider_day_format);
                                buffer.append(Messages.format(RefactoringUIMessages.RefactoringHistoryControlConfiguration_day_detailed_pattern, new String[]{simple.format(stamp), DateFormat.getDateInstance().format(stamp)}));
                                break;
                            }
                            format = DateFormat.getDateInstance((int)2);
                            break;
                        }
                        case 1: {
                            pattern = this.fControlConfiguration.getYesterdayPattern();
                            format = DateFormat.getDateInstance((int)2);
                            break;
                        }
                        case 0: {
                            pattern = this.fControlConfiguration.getTodayPattern();
                            format = DateFormat.getDateInstance((int)2);
                        }
                    }
                    if (format == null) break;
                    buffer.append(Messages.format(pattern, format.format(stamp)));
                }
            }
            return buffer.toString();
        }
        return super.getText(element);
    }
}

