/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.quickfix;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.ui.MarkerTypes;
import org.eclipse.xtext.ui.util.IssueUtil;
import org.eclipse.xtext.ui.validation.MarkerTypeProvider;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public class N4JSIssue
extends Issue.IssueImpl {
    private IMarker marker;

    public IMarker getMarker() {
        return this.marker;
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public String getUserData(String key) {
        int i = 0;
        while (i < this.getData().length) {
            if (this.getData()[i].equals(key) && i + 1 < this.getData().length) {
                return this.getData()[i + 1];
            }
            i += 2;
        }
        return null;
    }

    public static class Util
    extends IssueUtil {
        @Inject(optional=true)
        private MarkerTypeProvider markerTypeProvider;

        public Issue createIssue(IMarker marker) {
            N4JSIssue issue = new N4JSIssue();
            issue.setMarker(marker);
            try {
                Map attributes = marker.getAttributes();
                String markerType = marker.getType();
                Object message = attributes.get("message");
                issue.setMessage(message instanceof String ? (String)message : null);
                Object lineNumber = attributes.get("lineNumber");
                issue.setLineNumber(lineNumber instanceof Integer ? Integer.valueOf((Integer)lineNumber - 1) : null);
                Object offset = attributes.get("charStart");
                Object endOffset = attributes.get("charEnd");
                if (offset instanceof Integer && endOffset instanceof Integer) {
                    issue.setOffset((Integer)offset);
                    issue.setLength((Integer)endOffset - (Integer)offset);
                } else {
                    issue.setOffset(-1);
                    issue.setLength(0);
                }
                Object code = attributes.get("CODE_KEY");
                issue.setCode(code instanceof String ? (String)code : null);
                Object data = attributes.get("DATA_KEY");
                issue.setData(data instanceof String ? Strings.unpack((String)((String)data)) : null);
                Object uri = attributes.get("URI_KEY");
                issue.setUriToProblem(uri instanceof String ? URI.createURI((String)((String)uri)) : null);
                Object severity = attributes.get("severity");
                Severity translatedSeverity = this.translateSeverity(severity instanceof Integer ? (Integer)severity : 0);
                if (translatedSeverity == null) {
                    throw new IllegalArgumentException(marker.toString());
                }
                issue.setSeverity(translatedSeverity);
                if (this.markerTypeProvider != null) {
                    issue.setType(this.markerTypeProvider.getCheckType(markerType));
                } else {
                    issue.setType(MarkerTypes.toCheckType((String)markerType));
                }
            }
            catch (CoreException e) {
                return null;
            }
            return issue;
        }
    }
}

