/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.tester.server.resources;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.eclipse.n4js.tester.server.resources.BaseResource;
import org.eclipse.n4js.tester.server.resources.HttpMethod;
import org.eclipse.n4js.tester.server.resources.Resource;

public class ResourceDescriptor {
    private final Class<? extends BaseResource> clazz;
    private final Pattern pathPattern;
    private final Collection<HttpMethod> methods;
    private final Collection<String> requestContentType;
    private final String responseContentType;

    public ResourceDescriptor(Resource resource, Class<? extends BaseResource> clazz) {
        this.clazz = clazz;
        this.pathPattern = this.compilePath(resource.path());
        this.methods = Collections.unmodifiableCollection(Sets.newEnumSet((Iterable)Lists.newArrayList((Object[])resource.method()), HttpMethod.class));
        this.requestContentType = Collections.unmodifiableCollection(Sets.newHashSet((Iterable)Collections2.transform((Collection)Lists.newArrayList((Object[])resource.requestContentType()), input -> input.toString())));
        this.responseContentType = resource.responseContentType();
    }

    public Class<? extends BaseResource> getClazz() {
        return this.clazz;
    }

    public boolean matchesWithPathInfo(String pathInfo) {
        return this.pathPattern.matcher(pathInfo).matches();
    }

    public Collection<HttpMethod> getMethods() {
        return this.methods;
    }

    public Collection<String> getRequestContentType() {
        return this.requestContentType;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    private Pattern compilePath(String path) {
        String s = path;
        if (s.lastIndexOf("/") == s.length() - 1) {
            s = s.substring(0, s.lastIndexOf("/"));
        }
        if (s.indexOf("/") == 0) {
            s = s.substring(1);
        }
        s = s.replaceAll("[{][^ /]+[}]", "[^ /]+");
        return Pattern.compile("^/" + s + "[/]?$");
    }
}

