/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.hlc.base;

import org.eclipse.n4js.hlc.base.ErrorExitCode;

public class ExitCodeException
extends Exception {
    private final ErrorExitCode exitCode;

    public int getExitCode() {
        return this.exitCode.getExitCodeValue();
    }

    public ExitCodeException(ErrorExitCode exitCode) {
        this.exitCode = exitCode;
    }

    public ExitCodeException(ErrorExitCode exitCode, String string) {
        super(string);
        this.exitCode = exitCode;
    }

    public ExitCodeException(ErrorExitCode exitCode, Throwable cause) {
        super(cause);
        this.exitCode = exitCode;
    }

    public ExitCodeException(ErrorExitCode exitCode, String message, Throwable cause) {
        super(message, cause);
        this.exitCode = exitCode;
    }

    public ExitCodeException(int code) {
        this.exitCode = ExitCodeException.lookupExitCodeForInt(code);
    }

    public ExitCodeException(int code, String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(message, cause, enableSuppression, writableStackTrace);
        this.exitCode = ExitCodeException.lookupExitCodeForInt(code);
    }

    public ExitCodeException(int code, String string) {
        super(string);
        this.exitCode = ExitCodeException.lookupExitCodeForInt(code);
    }

    public ExitCodeException(int code, String message, Throwable cause) {
        super(message, cause);
        this.exitCode = ExitCodeException.lookupExitCodeForInt(code);
    }

    public ExitCodeException(int code, Throwable cause) {
        super(cause);
        this.exitCode = ExitCodeException.lookupExitCodeForInt(code);
    }

    public boolean hasMessage() {
        return this.getMessage() != null && this.getMessage().length() > 0;
    }

    private static final ErrorExitCode lookupExitCodeForInt(int code) {
        ErrorExitCode exitCode = ErrorExitCode.fromInt(code);
        if (exitCode == null) {
            throw new RuntimeException("Unrecognized compiler exit code " + code);
        }
        return exitCode;
    }

    public String explanationOfExitCode() {
        return " (" + this.exitCode.getExplanation() + ")";
    }
}

