/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.compare;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.n4js.compare.ProjectCompareHelper;
import org.eclipse.n4js.compare.ProjectCompareResult;
import org.eclipse.n4js.compare.ProjectComparison;
import org.eclipse.n4js.compare.ProjectComparisonEntry;
import org.eclipse.n4js.jsdoc.N4JSDocHelper;
import org.eclipse.n4js.jsdoc.N4JSDocletParser;
import org.eclipse.n4js.jsdoc.dom.Doclet;
import org.eclipse.n4js.projectModel.IN4JSCore;
import org.eclipse.n4js.ui.labeling.N4JSLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ProjectCompareTreeHelper {
    @Inject
    private IN4JSCore n4jsCore;
    @Inject
    private N4JSLabelProvider n4jsLabelProvider;
    @Inject
    private N4JSDocHelper n4jsDocHelper;
    @Inject
    private ProjectCompareHelper projectCompareHelper;

    public Image getImage(Object element) {
        return this.n4jsLabelProvider.getImage(element);
    }

    public ProjectComparison createComparison(boolean fullCompare, List<String> addErrorMessagesHere) {
        return this.projectCompareHelper.createComparison(fullCompare, addErrorMessagesHere);
    }

    public ProjectCompareResult compareApiImpl(ProjectComparisonEntry entry, int implIdx) {
        return this.projectCompareHelper.compareApiImpl(entry, implIdx);
    }

    public Map<ProjectComparisonEntry, String> readDocumentation(ProjectComparison comparison, int[] implIndices) {
        HashMap<ProjectComparisonEntry, String> result = new HashMap<ProjectComparisonEntry, String>();
        ResourceSet resourceSetForDocRetrieval = this.n4jsCore.createResourceSet(Optional.absent());
        comparison.getAllEntries().forEach(currE -> {
            String doc = this.readDocumentation(resourceSetForDocRetrieval, (ProjectComparisonEntry)currE, implIndices);
            if (doc != null) {
                result.put((ProjectComparisonEntry)currE, doc);
            }
        });
        return result;
    }

    private String readDocumentation(ResourceSet resourceSetForDocRetrieval, ProjectComparisonEntry entry, int[] implIndices) {
        if (entry.isElementEntry()) {
            ArrayList<EObject> elemsToConsider = new ArrayList<EObject>();
            elemsToConsider.add(entry.getElementAPI());
            int[] nArray = implIndices;
            int n = implIndices.length;
            int n2 = 0;
            while (n2 < n) {
                int currImplIdx = nArray[n2];
                elemsToConsider.add(entry.getElementImpl(currImplIdx));
                ++n2;
            }
            StringBuilder sb = new StringBuilder();
            for (EObject currElem : elemsToConsider) {
                String docApiTag;
                Doclet dl;
                String docStr;
                if (currElem == null || currElem.eIsProxy() || (docStr = this.n4jsDocHelper.getDocSafely(resourceSetForDocRetrieval, currElem)) == null || (dl = this.n4jsDocHelper.getDoclet(docStr)) == null || (docApiTag = N4JSDocletParser.TAG_API_NOTE.getValue(dl, null)) == null || docApiTag.trim().length() <= 0) continue;
                String sanitized = docApiTag.replaceAll("\\s*\n\\s*", " ").trim();
                if (sb.length() > 0) {
                    sb.append(" | ");
                }
                sb.append(sanitized);
            }
            String doc = sb.toString().trim();
            if (doc.length() > 0) {
                return doc;
            }
        }
        return null;
    }
}

