/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.transpiler.sourcemap;

import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.n4js.transpiler.sourcemap.MappingEntry;

public abstract class LineMappings
extends TreeSet<MappingEntry> {
    LineMappings(Comparator<MappingEntry> comparator) {
        super(comparator);
    }

    @Override
    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder strb = new StringBuilder();
        strb.append(((MappingEntry)this.iterator().next()).genLine);
        strb.append(":");
        for (MappingEntry entry : this) {
            strb.append(" ");
            strb.append(entry.toString());
        }
        return strb.toString();
    }

    public abstract MappingEntry findEntryByColumn(int var1);

    public static class ByGen
    extends LineMappings {
        public ByGen() {
            super(new Comparator<MappingEntry>(){

                @Override
                public int compare(MappingEntry o1, MappingEntry o2) {
                    return o1.genColumn - o2.genColumn;
                }
            });
        }

        @Override
        public MappingEntry findEntryByColumn(int col) {
            MappingEntry match = null;
            for (MappingEntry entry : this) {
                if (entry.srcColumn > col) break;
                match = entry;
            }
            return match;
        }
    }

    public static class BySrc
    extends LineMappings {
        public BySrc() {
            super(new Comparator<MappingEntry>(){

                @Override
                public int compare(MappingEntry o1, MappingEntry o2) {
                    return o1.srcColumn - o2.srcColumn;
                }
            });
        }

        @Override
        public MappingEntry findEntryByColumn(int col) {
            MappingEntry match = null;
            for (MappingEntry entry : this) {
                if (entry.srcColumn > col) break;
                match = entry;
            }
            return match;
        }
    }
}

